/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi.portal;

import java.util.Optional;
import net.kyrptonaught.customportalapi.CustomPortalApiRegistry;
import net.kyrptonaught.customportalapi.portal.PortalIgnitionSource;
import net.kyrptonaught.customportalapi.portal.frame.PortalFrameTester;
import net.kyrptonaught.customportalapi.util.CustomPortalHelper;
import net.kyrptonaught.customportalapi.util.PortalLink;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;

public class PortalPlacer {
    public static boolean attemptPortalLight(Level world, BlockPos portalPos, PortalIgnitionSource ignitionSource) {
        return PortalPlacer.attemptPortalLight(world, portalPos, CustomPortalHelper.getClosestFrameBlock(world, portalPos), ignitionSource);
    }

    public static boolean attemptPortalLight(Level world, BlockPos portalPos, BlockPos framePos, PortalIgnitionSource ignitionSource) {
        Block foundationBlock = world.m_8055_(framePos).m_60734_();
        PortalLink link = CustomPortalApiRegistry.getPortalLinkFromBase(foundationBlock);
        if (link == null || !link.doesIgnitionMatch(ignitionSource) || !link.canLightInDim(world.m_46472_().m_135782_())) {
            return false;
        }
        return PortalPlacer.createPortal(link, world, portalPos, foundationBlock);
    }

    private static boolean createPortal(PortalLink link, Level world, BlockPos pos, Block foundationBlock) {
        Optional<PortalFrameTester> optional = link.getFrameTester().createInstanceOfPortalFrameTester().getNewPortal((LevelAccessor)world, pos, Direction.Axis.X, foundationBlock);
        if (optional.isPresent()) {
            if (optional.get().isRequestedSize(link.forcedWidth, link.forcedHeight)) {
                optional.get().lightPortal(foundationBlock);
            }
            return true;
        }
        return false;
    }

    public static Optional<BlockUtil.FoundRectangle> createDestinationPortal(ServerLevel world, BlockPos blockPos, BlockState frameBlock, Direction.Axis axis) {
        WorldBorder worldBorder = world.m_6857_();
        PortalLink link = CustomPortalApiRegistry.getPortalLinkFromBase(frameBlock.m_60734_());
        PortalFrameTester portalFrameTester = link.getFrameTester().createInstanceOfPortalFrameTester();
        int topY = Math.min(world.m_151558_(), world.m_141937_() + world.m_143344_()) - 5;
        int bottomY = world.m_141937_() + 5;
        if (world.m_46472_().m_135782_().equals((Object)link.dimID)) {
            if (link.portalSearchYTop != null) {
                topY = link.portalSearchYTop;
            }
            if (link.portalSearchYBottom != null) {
                bottomY = link.portalSearchYBottom;
            }
        } else {
            if (link.returnPortalSearchYTop != null) {
                topY = link.returnPortalSearchYTop;
            }
            if (link.returnPortalSearchYBottom != null) {
                bottomY = link.returnPortalSearchYBottom;
            }
        }
        for (BlockPos.MutableBlockPos mutable : BlockPos.m_121935_((BlockPos)blockPos, (int)32, (Direction)Direction.WEST, (Direction)Direction.SOUTH)) {
            BlockPos testingPos = mutable.m_7949_();
            if (!worldBorder.m_61937_(testingPos)) continue;
            for (int y = topY; y >= bottomY; --y) {
                BlockPos testRect;
                if (!PortalPlacer.canHoldPortal(world.m_8055_(testingPos.m_175288_(y))) || (testRect = portalFrameTester.doesPortalFitAt((Level)world, testingPos.m_175288_(y + 1), axis)) == null) continue;
                portalFrameTester.createPortal((Level)world, testRect, frameBlock, axis);
                return Optional.of(portalFrameTester.getRectangle());
            }
        }
        portalFrameTester.createPortal((Level)world, blockPos, frameBlock, axis);
        return Optional.of(portalFrameTester.getRectangle());
    }

    private static boolean canHoldPortal(BlockState state) {
        return state.m_280296_();
    }
}

