/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar;

import com.happysg.radar.block.controller.id.IDManager;
import com.happysg.radar.block.datalink.DataLinkBlockItem;
import com.happysg.radar.block.monitor.MonitorInputHandler;
import com.happysg.radar.compat.Mods;
import com.happysg.radar.compat.cbc.CBCCompatRegister;
import com.happysg.radar.compat.cbcmw.CBCMWCompatRegister;
import com.happysg.radar.compat.computercraft.CCCompatRegister;
import com.happysg.radar.config.RadarConfig;
import com.happysg.radar.networking.ModMessages;
import com.happysg.radar.registry.AllDataBehaviors;
import com.happysg.radar.registry.ModBlockEntityTypes;
import com.happysg.radar.registry.ModBlocks;
import com.happysg.radar.registry.ModContraptionTypes;
import com.happysg.radar.registry.ModCreativeTabs;
import com.happysg.radar.registry.ModDisplayBehaviors;
import com.happysg.radar.registry.ModItems;
import com.happysg.radar.registry.ModLang;
import com.happysg.radar.registry.ModPartials;
import com.mojang.logging.LogUtils;
import com.simibubi.create.api.stress.BlockStressValues;
import com.simibubi.create.foundation.data.CreateRegistrate;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@Mod(value="create_radar")
public class CreateRadar {
    public static final String MODID = "create_radar";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final CreateRegistrate REGISTRATE = CreateRegistrate.create((String)"create_radar");

    public CreateRadar() {
        CreateRadar.getLogger().info("Initializing Create Radar!");
        ModLoadingContext context = ModLoadingContext.get();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
        REGISTRATE.registerEventListeners(modEventBus);
        ModItems.register();
        ModBlocks.register();
        ModBlockEntityTypes.register();
        ModCreativeTabs.register(modEventBus);
        ModLang.register();
        ModPartials.init();
        RadarConfig.register(context);
        modEventBus.addListener(CreateRadar::init);
        modEventBus.addListener(CreateRadar::clientInit);
        modEventBus.addListener(CreateRadar::onLoadComplete);
        MinecraftForge.EVENT_BUS.addListener(MonitorInputHandler::monitorPlayerHovering);
        MinecraftForge.EVENT_BUS.addListener(CreateRadar::clientTick);
        MinecraftForge.EVENT_BUS.addListener(CreateRadar::onLoadWorld);
        if (Mods.CREATEBIGCANNONS.isLoaded()) {
            CBCCompatRegister.registerCBC();
        }
        if (Mods.CBCMODERNWARFARE.isLoaded()) {
            CBCMWCompatRegister.registerCBCMW();
        }
        if (Mods.COMPUTERCRAFT.isLoaded()) {
            CCCompatRegister.registerPeripherals();
        }
    }

    private static void clientTick(TickEvent.ClientTickEvent event) {
        DataLinkBlockItem.clientTick();
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    public static ResourceLocation asResource(String path) {
        return new ResourceLocation(MODID, path);
    }

    public static String toHumanReadable(String key) {
        String s = key.replace("_", " ");
        s = Arrays.stream(StringUtils.splitByCharacterTypeCamelCase((String)s)).map(StringUtils::capitalize).collect(Collectors.joining(" "));
        return StringUtils.normalizeSpace((String)s);
    }

    public static void clientInit(FMLClientSetupEvent event) {
    }

    public static void onLoadComplete(FMLLoadCompleteEvent event) {
        ModContainer container = (ModContainer)ModList.get().getModContainerById(MODID).orElseThrow(() -> new IllegalStateException("Radar mod container missing on LoadComplete"));
        container.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory(RadarConfig::createConfigScreen));
    }

    public static void onLoadWorld(LevelEvent.Load event) {
        LevelAccessor world = event.getLevel();
        if (world.m_7654_() != null) {
            IDManager.load(world.m_7654_());
        }
    }

    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ModContraptionTypes.register();
            BlockStressValues.IMPACTS.register((Object)((Block)ModBlocks.RADAR_BEARING_BLOCK.get()), () -> 4.0);
            BlockStressValues.IMPACTS.register((Object)((Block)ModBlocks.AUTO_YAW_CONTROLLER_BLOCK.get()), () -> 128.0);
            BlockStressValues.IMPACTS.register((Object)((Block)ModBlocks.AUTO_PITCH_CONTROLLER_BLOCK.get()), () -> 128.0);
            BlockStressValues.IMPACTS.register((Object)((Block)ModBlocks.TRACK_CONTROLLER_BLOCK.get()), () -> 16.0);
            BlockStressValues.IMPACTS.register((Object)((Block)ModBlocks.RADAR_RECEIVER_BLOCK.get()), () -> 0.0);
            BlockStressValues.IMPACTS.register((Object)((Block)ModBlocks.RADAR_DISH_BLOCK.get()), () -> 0.0);
            BlockStressValues.IMPACTS.register((Object)((Block)ModBlocks.RADAR_PLATE_BLOCK.get()), () -> 0.0);
            BlockStressValues.IMPACTS.register((Object)((Block)ModBlocks.CREATIVE_RADAR_PLATE_BLOCK.get()), () -> 0.0);
        });
        ModMessages.register();
        ModDisplayBehaviors.register();
        AllDataBehaviors.registerDefaults();
    }
}

