/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.block.radar.behavior;

import com.happysg.radar.block.radar.track.RadarTrack;
import com.happysg.radar.block.radar.track.RadarTrackUtil;
import com.happysg.radar.compat.Mods;
import com.happysg.radar.compat.vs2.PhysicsHandler;
import com.happysg.radar.compat.vs2.VS2Utils;
import com.happysg.radar.config.RadarConfig;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.valkyrienskies.core.api.ships.Ship;

public class RadarScanningBlockBehavior
extends BlockEntityBehaviour {
    public static final BehaviourType<RadarScanningBlockBehavior> TYPE = new BehaviourType();
    private int trackExpiration = 100;
    private int fov;
    private int yRange;
    private double range;
    private double angle;
    private boolean running;
    private SmartBlockEntity bearingEntity;
    Vec3 scanPos;
    private final Set<Entity> scannedEntities;
    private final Set<Ship> scannedShips;
    private final Set<Projectile> scannedProjectiles;
    private final HashMap<String, RadarTrack> radarTracks;

    public RadarScanningBlockBehavior(SmartBlockEntity be) {
        super(be);
        this.fov = (Integer)RadarConfig.server().radarFOV.get();
        this.yRange = 20;
        this.range = ((Integer)RadarConfig.server().radarBaseRange.get()).intValue();
        this.running = false;
        this.scanPos = Vec3.f_82478_;
        this.scannedEntities = new HashSet<Entity>();
        this.scannedShips = new HashSet<Ship>();
        this.scannedProjectiles = new HashSet<Projectile>();
        this.radarTracks = new HashMap();
        this.bearingEntity = be;
        this.setLazyTickRate(5);
    }

    public void tick() {
        super.tick();
        if (this.blockEntity.m_58904_() == null || this.blockEntity.m_58904_().f_46443_) {
            return;
        }
        this.removeDeadTracks();
        if (this.running) {
            this.updateRadarTracks();
        }
    }

    private void updateRadarTracks() {
        this.scanPos = PhysicsHandler.getWorldPos((BlockEntity)this.bearingEntity).m_252807_();
        Level level = this.blockEntity.m_58904_();
        if (level == null) {
            return;
        }
        for (Entity entity : this.scannedEntities) {
            if (!entity.m_6084_() || !this.isInFovAndRange(entity.m_20182_())) continue;
            this.radarTracks.compute(entity.m_20148_().toString(), (id, track) -> {
                if (track == null) {
                    return new RadarTrack(entity);
                }
                track.updateRadarTrack(entity);
                return track;
            });
            if (!(entity instanceof Projectile)) continue;
            this.scannedProjectiles.add((Projectile)entity);
        }
        for (Ship ship : this.scannedShips) {
            Vec3 pos = RadarTrackUtil.getPosition(ship);
            if (!this.isInFovAndRange(pos)) continue;
            this.radarTracks.compute(ship.getSlug(), (id, track) -> {
                if (track == null) {
                    return RadarTrackUtil.getRadarTrack(ship, level);
                }
                track.updateRadarTrack(ship, level);
                return track;
            });
        }
    }

    private boolean isInFovAndRange(Vec3 target) {
        double distance = this.scanPos.m_82554_(target);
        if (distance < 2.0) {
            return true;
        }
        double angleToEntity = Math.toDegrees(Math.atan2(target.m_7096_() - this.scanPos.m_7096_(), target.m_7094_() - this.scanPos.m_7094_()));
        double angleDiff = Math.abs((angleToEntity = (angleToEntity + 360.0) % 360.0) - this.angle);
        if (angleDiff > 180.0) {
            angleDiff = 360.0 - angleDiff;
        }
        return angleDiff <= (double)this.fov / 2.0 && distance <= this.range;
    }

    private void removeDeadTracks() {
        for (Entity entity : this.scannedEntities) {
            if (entity.m_6084_()) continue;
            this.radarTracks.remove(entity.m_20148_().toString());
        }
        ArrayList<String> toRemove = new ArrayList<String>();
        long currentTime = this.blockEntity.m_58904_().m_46467_();
        for (RadarTrack track : this.radarTracks.values()) {
            if (currentTime - track.scannedTime() <= (long)this.trackExpiration) continue;
            toRemove.add(track.id());
        }
        toRemove.forEach(this.radarTracks::remove);
        this.scannedProjectiles.removeIf(p -> {
            boolean dead;
            boolean bl = dead = !p.m_6084_();
            if (dead) {
                this.radarTracks.remove(p.m_20148_().toString());
            }
            return dead;
        });
    }

    public void lazyTick() {
        if (this.running) {
            this.scannedEntities.clear();
            this.scannedShips.clear();
            this.scannedProjectiles.clear();
            this.scanForEntityTracks();
            if (Mods.VALKYRIENSKIES.isLoaded()) {
                this.scanForVSTracks();
            }
        }
        super.lazyTick();
    }

    private void scanForEntityTracks() {
        if (this.blockEntity.m_58904_() == null) {
            return;
        }
        RadarScanningBlockBehavior.splitAABB(this.getRadarAABB(), 999.0).forEach(aabb -> this.scannedEntities.addAll(this.blockEntity.m_58904_().m_45933_(null, aabb)));
    }

    private void scanForVSTracks() {
        if (this.blockEntity.m_58904_() == null || !Mods.VALKYRIENSKIES.isLoaded()) {
            return;
        }
        RadarScanningBlockBehavior.splitAABB(this.getRadarAABB(), 999.0).forEach(aabb -> VS2Utils.getLoadedShips(this.blockEntity.m_58904_(), aabb).forEach(this.scannedShips::add));
        this.scannedShips.remove(VS2Utils.getShipManagingPos((BlockEntity)this.blockEntity));
    }

    private AABB getRadarAABB() {
        BlockPos radarPos = PhysicsHandler.getWorldPos((BlockEntity)this.blockEntity);
        double xOffset = this.range * Math.sin(Math.toRadians(this.angle));
        double zOffset = this.range * Math.cos(Math.toRadians(this.angle));
        return new AABB((double)radarPos.m_123341_() - xOffset, (double)(radarPos.m_123342_() - (Integer)RadarConfig.server().radarYScanRange.get()), (double)radarPos.m_123343_() - zOffset, (double)radarPos.m_123341_() + xOffset, (double)(radarPos.m_123342_() + (Integer)RadarConfig.server().radarYScanRange.get()), (double)radarPos.m_123343_() + zOffset);
    }

    public static List<AABB> splitAABB(AABB aabb, double maxSize) {
        ArrayList<AABB> result = new ArrayList<AABB>();
        for (double x = aabb.f_82288_; x < aabb.f_82291_; x += maxSize) {
            for (double y = aabb.f_82289_; y < aabb.f_82292_; y += maxSize) {
                for (double z = aabb.f_82290_; z < aabb.f_82293_; z += maxSize) {
                    result.add(new AABB(x, y, z, Math.min(x + maxSize, aabb.f_82291_), Math.min(y + maxSize, aabb.f_82292_), Math.min(z + maxSize, aabb.f_82293_)));
                }
            }
        }
        return result;
    }

    public void read(CompoundTag nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        if (nbt.m_128441_("fov")) {
            this.fov = nbt.m_128451_("fov");
        }
        if (nbt.m_128441_("yRange")) {
            this.yRange = nbt.m_128451_("yRange");
        }
        if (nbt.m_128441_("range")) {
            this.range = nbt.m_128459_("range");
        }
        if (nbt.m_128441_("angle")) {
            this.angle = nbt.m_128459_("angle");
        }
        if (nbt.m_128441_("scanPosX")) {
            this.scanPos = new Vec3(nbt.m_128459_("scanPosX"), nbt.m_128459_("scanPosY"), nbt.m_128459_("scanPosZ"));
        }
        if (nbt.m_128441_("running")) {
            this.running = nbt.m_128471_("running");
        }
        if (nbt.m_128441_("trackExpiration")) {
            this.trackExpiration = nbt.m_128451_("trackExpiration");
        }
    }

    public void write(CompoundTag nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        nbt.m_128405_("fov", this.fov);
        nbt.m_128405_("yRange", this.yRange);
        nbt.m_128347_("range", this.range);
        nbt.m_128347_("angle", this.angle);
        nbt.m_128347_("scanPosX", this.scanPos.f_82479_);
        nbt.m_128347_("scanPosY", this.scanPos.f_82480_);
        nbt.m_128347_("scanPosZ", this.scanPos.f_82481_);
        nbt.m_128379_("running", this.running);
        nbt.m_128405_("trackExpiration", this.trackExpiration);
    }

    public void setFov(int fov) {
        this.fov = fov;
    }

    public void setYRange(int yRange) {
        this.yRange = yRange;
    }

    public void setRange(double range) {
        this.range = range;
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }

    public void setScanPos(Vec3 scanPos) {
        this.scanPos = scanPos;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public void setTrackExpiration(int trackExpiration) {
        this.trackExpiration = trackExpiration;
    }

    public Collection<RadarTrack> getRadarTracks() {
        return this.radarTracks.values();
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    public float getAngle() {
        return (float)this.angle;
    }
}

