/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block.display.properties.components;

import de.mrjulsen.crn.block.display.properties.IDisplaySettings;
import de.mrjulsen.crn.block.display.properties.components.GuiBuilderWrapper;
import de.mrjulsen.crn.client.gui.widgets.modular.GuiBuilderContext;
import de.mrjulsen.mcdragonlib.client.ber.BERLabel;
import de.mrjulsen.mcdragonlib.core.ITranslatableEnum;
import java.util.Arrays;

public interface ITextWidthSetting {
    public static final int USED_LINE_SPACE = 22;
    public static final String GUI_LINE_TEXT_MAX_WIDTH_NAME = "text_max_width";
    public static final float MIN_VALUE = 0.0f;
    public static final float MAX_VALUE = 250.0f;
    public static final float DEFAULT_TEXT_MAX_WIDTH = 250.0f;
    public static final TextScaleBounds DEFAULT_BOUNDS_ACTION = TextScaleBounds.SCALE_SCROLL;
    public static final String NBT_TEXT_MAX_WIDTH = "TextMaxWidth";
    public static final String NBT_BOUNDS_ACTION = "BoundsAction";

    public float getTextMaxWidth();

    public void setTextMaxWidth(float var1);

    public TextScaleBounds getBoundsAction();

    public void setBoundsAction(TextScaleBounds var1);

    default public void buildTextMaxWidthGui(GuiBuilderContext context) {
        GuiBuilderWrapper.buildTextMaxWidthGui(this, context);
    }

    default public void copyTextMaxWidthSetting(IDisplaySettings oldSettings) {
        if (oldSettings instanceof ITextWidthSetting) {
            ITextWidthSetting o = (ITextWidthSetting)((Object)oldSettings);
            this.setTextMaxWidth(o.getTextMaxWidth());
            this.setBoundsAction(o.getBoundsAction());
        }
    }

    default public boolean isMaxTextWidth() {
        return this.getTextMaxWidth() >= 250.0f;
    }

    public static enum TextScaleBounds implements ITranslatableEnum
    {
        CUT_OFF(0, "cut_off", BERLabel.BoundsHitReaction.CUT_OFF),
        SCALE_SCROLL(1, "scale_scroll", BERLabel.BoundsHitReaction.SCALE_SCROLL),
        SCROLL(2, "scroll", BERLabel.BoundsHitReaction.SCROLL);

        final byte index;
        final String name;
        final BERLabel.BoundsHitReaction hit;

        private TextScaleBounds(byte index, String name, BERLabel.BoundsHitReaction hit) {
            this.index = index;
            this.hit = hit;
            this.name = name;
        }

        public byte getIndex() {
            return this.index;
        }

        public BERLabel.BoundsHitReaction hit() {
            return this.hit;
        }

        public static TextScaleBounds getByIndex(int b) {
            return Arrays.stream(TextScaleBounds.values()).filter(x -> x.getIndex() == b).findFirst().orElse(SCALE_SCROLL);
        }

        public String getEnumName() {
            return "text_scale_bounds";
        }

        public String getEnumValueName() {
            return this.name;
        }
    }
}

