/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.api.squedule;

import com.rae.creatingspace.CreatingSpace;
import com.rae.creatingspace.api.squedule.ScheduleEntry;
import com.rae.creatingspace.api.squedule.condition.FluidThresholdCondition;
import com.rae.creatingspace.api.squedule.condition.ItemThresholdCondition;
import com.rae.creatingspace.api.squedule.condition.PlayerPassengerCondition;
import com.rae.creatingspace.api.squedule.condition.ScheduleWaitCondition;
import com.rae.creatingspace.api.squedule.condition.ScheduledDelay;
import com.rae.creatingspace.api.squedule.condition.TimeOfDayCondition;
import com.rae.creatingspace.api.squedule.instruction.DestinationInstruction;
import com.rae.creatingspace.api.squedule.instruction.ScheduleInstruction;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class RocketSchedule {
    public static List<Pair<ResourceLocation, Supplier<? extends ScheduleInstruction>>> INSTRUCTION_TYPES = new ArrayList<Pair<ResourceLocation, Supplier<? extends ScheduleInstruction>>>();
    public static List<Pair<ResourceLocation, Supplier<? extends ScheduleWaitCondition>>> CONDITION_TYPES = new ArrayList<Pair<ResourceLocation, Supplier<? extends ScheduleWaitCondition>>>();
    public List<ScheduleEntry> entries = new ArrayList<ScheduleEntry>();
    public boolean cyclic = true;
    public int savedProgress = 0;

    private static void registerInstruction(String name, Supplier<? extends ScheduleInstruction> factory) {
        INSTRUCTION_TYPES.add((Pair<ResourceLocation, Supplier<? extends ScheduleInstruction>>)Pair.of((Object)CreatingSpace.resource(name), factory));
    }

    private static void registerCondition(String name, Supplier<? extends ScheduleWaitCondition> factory) {
        CONDITION_TYPES.add((Pair<ResourceLocation, Supplier<? extends ScheduleWaitCondition>>)Pair.of((Object)CreatingSpace.resource(name), factory));
    }

    public static <T> List<? extends Component> getTypeOptions(List<Pair<ResourceLocation, T>> list) {
        String langSection = list.equals(INSTRUCTION_TYPES) ? "instruction." : "condition.";
        return list.stream().map(Pair::getFirst).map(rl -> rl.m_135827_() + ".schedule." + langSection + rl.m_135815_()).map(Component::m_237115_).toList();
    }

    public CompoundTag write() {
        CompoundTag tag = new CompoundTag();
        ListTag list = NBTHelper.writeCompoundList(this.entries, ScheduleEntry::write);
        tag.m_128365_("Entries", (Tag)list);
        tag.m_128379_("Cyclic", this.cyclic);
        if (this.savedProgress > 0) {
            tag.m_128405_("Progress", this.savedProgress);
        }
        return tag;
    }

    public static RocketSchedule fromTag(CompoundTag tag) {
        RocketSchedule schedule = new RocketSchedule();
        schedule.entries = NBTHelper.readCompoundList((ListTag)tag.m_128437_("Entries", 10), ScheduleEntry::fromTag);
        schedule.cyclic = tag.m_128471_("Cyclic");
        if (tag.m_128441_("Progress")) {
            schedule.savedProgress = tag.m_128451_("Progress");
        }
        return schedule;
    }

    static {
        RocketSchedule.registerInstruction("destination", DestinationInstruction::new);
        RocketSchedule.registerCondition("delay", ScheduledDelay::new);
        RocketSchedule.registerCondition("time_of_day", TimeOfDayCondition::new);
        RocketSchedule.registerCondition("fluid_threshold", FluidThresholdCondition::new);
        RocketSchedule.registerCondition("item_threshold", ItemThresholdCondition::new);
        RocketSchedule.registerCondition("player_count", PlayerPassengerCondition::new);
    }
}

