/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.api.squedule.condition;

import com.google.common.collect.ImmutableList;
import com.rae.creatingspace.CreatingSpace;
import com.rae.creatingspace.api.squedule.condition.ScheduleWaitCondition;
import com.rae.creatingspace.content.rocket.RocketContraptionEntity;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.createmod.catnip.data.Pair;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PlayerPassengerCondition
extends ScheduleWaitCondition {
    public Pair<ItemStack, Component> getSummary() {
        int target = this.getTarget();
        return Pair.of((Object)AllBlocks.SEATS.get(DyeColor.YELLOW).asStack(), (Object)CreateLang.translateDirect((String)("schedule.condition.player_count." + (target == 1 ? "summary" : "summary_plural")), (Object[])new Object[]{target}));
    }

    public ResourceLocation getId() {
        return CreatingSpace.resource("player_count");
    }

    public int getTarget() {
        return this.intData("Count");
    }

    public boolean canOvershoot() {
        return this.intData("Exact") != 0;
    }

    public List<Component> getTitleAs(String type) {
        int target = this.getTarget();
        return ImmutableList.of((Object)CreateLang.translateDirect((String)"schedule.condition.player_count.seated", (Object[])new Object[]{CreateLang.translateDirect((String)("schedule.condition.player_count." + (target == 1 ? "summary" : "summary_plural")), (Object[])new Object[]{Component.m_237113_((String)("" + target)).m_130940_(ChatFormatting.DARK_AQUA)})}));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initConfigurationWidgets(ModularGuiLineBuilder builder) {
        builder.addScrollInput(0, 31, (i, l) -> i.titled(CreateLang.translateDirect((String)"schedule.condition.player_count.players", (Object[])new Object[0])).withShiftStep(5).withRange(0, 21), "Count");
        builder.addSelectionScrollInput(36, 85, (i, l) -> i.forOptions(CreateLang.translatedOptions((String)"schedule.condition.player_count", (String[])new String[]{"exactly", "or_above"})).titled(CreateLang.translateDirect((String)"schedule.condition.player_count.condition", (Object[])new Object[0])), "Exact");
    }

    @Override
    public boolean tickCompletion(Level level, RocketContraptionEntity rocket, CompoundTag context) {
        int prev = context.m_128451_("PrevPlayerCount");
        int present = rocket.countPlayerPassengers();
        int target = this.getTarget();
        context.m_128405_("PrevPlayerCount", present);
        if (prev != present) {
            this.requestStatusToUpdate(context);
        }
        return this.canOvershoot() ? present >= target : present == target;
    }

    @Override
    public MutableComponent getWaitingStatus(Level level, RocketContraptionEntity rocket, CompoundTag tag) {
        return CreateLang.translateDirect((String)"schedule.condition.player_count.status", (Object[])new Object[]{rocket.countPlayerPassengers(), this.getTarget()});
    }
}

