/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.api.squedule.condition;

import com.google.common.collect.ImmutableList;
import com.rae.creatingspace.CreatingSpace;
import com.rae.creatingspace.api.squedule.condition.ScheduleWaitCondition;
import com.rae.creatingspace.content.rocket.RocketContraptionEntity;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.gui.widget.Label;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.createmod.catnip.data.Pair;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableObject;

public class TimeOfDayCondition
extends ScheduleWaitCondition {
    public TimeOfDayCondition() {
        this.data.m_128405_("Hour", 8);
        this.data.m_128405_("Rotation", 5);
    }

    @Override
    public boolean tickCompletion(Level level, RocketContraptionEntity train, CompoundTag context) {
        int targetTicks;
        int maxTickDiff = 40;
        int targetHour = this.intData("Hour");
        int targetMinute = this.intData("Minute");
        int dayTime = (int)(level.m_46468_() % (long)this.getRotation());
        int diff = dayTime - (targetTicks = (int)(((double)((targetHour + 18) % 24 * 1000) + Math.ceil((float)targetMinute / 60.0f * 1000.0f)) % (double)this.getRotation()));
        return diff >= 0 && maxTickDiff >= diff;
    }

    public int getRotation() {
        int index = this.intData("Rotation");
        return switch (index) {
            case 9 -> 250;
            case 8 -> 500;
            case 7 -> 750;
            case 6 -> 1000;
            case 5 -> 2000;
            case 4 -> 3000;
            case 3 -> 4000;
            case 2 -> 6000;
            case 1 -> 12000;
            default -> 24000;
        };
    }

    public Pair<ItemStack, Component> getSummary() {
        return Pair.of((Object)new ItemStack((ItemLike)Items.f_42263_), (Object)this.getDigitalDisplay(this.intData("Hour"), this.intData("Minute"), false));
    }

    public MutableComponent getDigitalDisplay(int hour, int minute, boolean doubleDigitHrs) {
        int hour12raw = hour % 12 == 0 ? 12 : hour % 12;
        Object hr12 = doubleDigitHrs ? this.twoDigits(hour12raw) : "" + hour12raw;
        Object hr24 = doubleDigitHrs ? this.twoDigits(hour) : "" + hour;
        return CreateLang.translateDirect((String)"schedule.condition.time_of_day.digital_format", (Object[])new Object[]{hr12, hr24, this.twoDigits(minute), hour > 11 ? CreateLang.translateDirect((String)"generic.daytime.pm", (Object[])new Object[0]) : CreateLang.translateDirect((String)"generic.daytime.am", (Object[])new Object[0])});
    }

    public List<Component> getTitleAs(String type) {
        return ImmutableList.of((Object)CreateLang.translateDirect((String)"schedule.condition.time_of_day.scheduled", (Object[])new Object[0]), (Object)this.getDigitalDisplay(this.intData("Hour"), this.intData("Minute"), false).m_130940_(ChatFormatting.DARK_AQUA).m_7220_((Component)Component.m_237113_((String)" -> ").m_130940_(ChatFormatting.DARK_GRAY)).m_7220_((Component)((Component)CreateLang.translatedOptions((String)"schedule.condition.time_of_day.rotation", (String[])new String[]{"every_24", "every_12", "every_6", "every_4", "every_3", "every_2", "every_1", "every_0_45", "every_0_30", "every_0_15"}).get(this.intData("Rotation"))).m_6881_().m_130940_(ChatFormatting.GRAY)));
    }

    public String twoDigits(int t) {
        return t < 10 ? "0" + t : "" + t;
    }

    public ResourceLocation getId() {
        return CreatingSpace.resource("time_of_day");
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean renderSpecialIcon(GuiGraphics graphics, int x, int y) {
        int displayHr = (this.intData("Hour") + 12) % 24;
        float progress = ((float)displayHr * 60.0f + (float)this.intData("Minute")) / 1440.0f;
        ResourceLocation location = new ResourceLocation("textures/item/clock_" + this.twoDigits(Mth.m_14045_((int)((int)(progress * 64.0f)), (int)0, (int)63)) + ".png");
        graphics.m_280398_(location, x, y, 0, 0.0f, 0.0f, 16, 16, 16, 16);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initConfigurationWidgets(ModularGuiLineBuilder builder) {
        MutableObject minuteInput = new MutableObject();
        MutableObject hourInput = new MutableObject();
        MutableObject timeLabel = new MutableObject();
        builder.addScrollInput(0, 16, (i, l) -> {
            i.withRange(0, 24);
            timeLabel.setValue(l);
            hourInput.setValue(i);
        }, "Hour");
        builder.addScrollInput(18, 16, (i, l) -> {
            i.withRange(0, 60);
            minuteInput.setValue(i);
            l.f_93624_ = false;
        }, "Minute");
        builder.addSelectionScrollInput(52, 62, (i, l) -> i.forOptions(CreateLang.translatedOptions((String)"schedule.condition.time_of_day.rotation", (String[])new String[]{"every_24", "every_12", "every_6", "every_4", "every_3", "every_2", "every_1", "every_0_45", "every_0_30", "every_0_15"})).titled(CreateLang.translateDirect((String)"schedule.condition.time_of_day.rotation", (Object[])new Object[0])), "Rotation");
        ((ScrollInput)hourInput.getValue()).titled(CreateLang.translateDirect((String)"generic.daytime.hour", (Object[])new Object[0])).calling(t -> {
            this.data.m_128405_("Hour", t.intValue());
            ((Label)timeLabel.getValue()).text = this.getDigitalDisplay((int)t, ((ScrollInput)minuteInput.getValue()).getState(), true);
        }).writingTo(null).withShiftStep(6);
        ((ScrollInput)minuteInput.getValue()).titled(CreateLang.translateDirect((String)"generic.daytime.minute", (Object[])new Object[0])).calling(t -> {
            this.data.m_128405_("Minute", t.intValue());
            ((Label)timeLabel.getValue()).text = this.getDigitalDisplay(((ScrollInput)hourInput.getValue()).getState(), (int)t, true);
        }).writingTo(null).withShiftStep(15);
        ((ScrollInput)hourInput.getValue()).lockedTooltipX = -15;
        ((ScrollInput)minuteInput.getValue()).lockedTooltipX = -15;
        ((ScrollInput)hourInput.getValue()).lockedTooltipY = 35;
        ((ScrollInput)minuteInput.getValue()).lockedTooltipY = 35;
        ((ScrollInput)hourInput.getValue()).setState(this.intData("Hour"));
        ((ScrollInput)minuteInput.getValue()).setState(this.intData("Minute")).onChanged();
        builder.customArea(0, 52);
        builder.customArea(52, 69);
    }

    @Override
    public MutableComponent getWaitingStatus(Level level, RocketContraptionEntity train, CompoundTag tag) {
        int targetHour = this.intData("Hour");
        int targetMinute = this.intData("Minute");
        int dayTime = (int)(level.m_46468_() % (long)this.getRotation());
        int targetTicks = (int)(((double)((targetHour + 18) % 24 * 1000) + Math.ceil((float)targetMinute / 60.0f * 1000.0f)) % (double)this.getRotation());
        int diff = targetTicks - dayTime;
        if (diff < 0) {
            diff += this.getRotation();
        }
        int departureTime = (int)(level.m_46468_() + (long)diff) % 24000;
        int departingHour = (departureTime / 1000 + 6) % 24;
        int departingMinute = departureTime % 1000 * 60 / 1000;
        return CreateLang.translateDirect((String)"schedule.condition.time_of_day.status", (Object[])new Object[0]).m_7220_((Component)this.getDigitalDisplay(departingHour, departingMinute, false));
    }
}

