/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.api.squedule.instruction;

import com.google.common.collect.ImmutableList;
import com.rae.creatingspace.CreatingSpace;
import com.rae.creatingspace.api.squedule.instruction.ScheduleInstruction;
import com.rae.creatingspace.content.planets.CSDimensionUtil;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.createmod.catnip.data.Pair;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class DestinationInstruction
extends ScheduleInstruction {
    private List<ResourceLocation> planets;

    @Override
    public boolean supportsConditions() {
        return true;
    }

    public ResourceLocation getId() {
        return CreatingSpace.resource("destination");
    }

    public ItemStack getSecondLineIcon() {
        return AllBlocks.TRACK_STATION.asStack();
    }

    public ResourceLocation getDestination() {
        this.updateDataFromId();
        String data = this.textData("Text");
        if (data.isBlank()) {
            return null;
        }
        return ResourceLocation.m_135820_((String)data);
    }

    private void updateDataFromId() {
        int id = this.intData("intId");
        if (this.planets != null && id < this.planets.size()) {
            this.data.m_128359_("Text", this.planets.get(id).toString());
        }
    }

    public List<Component> getSecondLineTooltip(int slot) {
        return ImmutableList.of((Object)CreateLang.translateDirect((String)"schedule.instruction.filter_edit_box", (Object[])new Object[0]), (Object)CreateLang.translateDirect((String)"schedule.instruction.filter_edit_box_1", (Object[])new Object[0]).m_130940_(ChatFormatting.GRAY), (Object)CreateLang.translateDirect((String)"schedule.instruction.filter_edit_box_2", (Object[])new Object[0]).m_130940_(ChatFormatting.DARK_GRAY), (Object)CreateLang.translateDirect((String)"schedule.instruction.filter_edit_box_3", (Object[])new Object[0]).m_130940_(ChatFormatting.DARK_GRAY));
    }

    public Pair<ItemStack, Component> getSummary() {
        this.updateDataFromId();
        return Pair.of((Object)AllBlocks.TRACK_STATION.asStack(), (Object)Component.m_237115_((String)this.textData("Text")));
    }

    public List<Component> getTitleAs(String type) {
        this.updateDataFromId();
        return ImmutableList.of((Object)CreateLang.translateDirect((String)("schedule." + type + "." + this.getId().m_135815_() + ".summary"), (Object[])new Object[0]).m_130940_(ChatFormatting.GOLD), (Object)CreateLang.translateDirect((String)"generic.in_quotes", (Object[])new Object[]{Component.m_237115_((String)this.textData("destination"))}));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initConfigurationWidgets(ModularGuiLineBuilder builder) {
        this.planets = DestinationInstruction.getPlanets();
        builder.addSelectionScrollInput(0, 121, (s, t) -> s.forOptions(this.planets.stream().map(r -> Component.m_237115_((String)r.toString())).toList()), "intId");
    }

    @NotNull
    private static List<ResourceLocation> getPlanets() {
        return CSDimensionUtil.getPlanets();
    }
}

