/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.compat.jei.category;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.rae.creatingspace.compat.jei.AnimatedAirLiquefier;
import com.rae.creatingspace.content.recipes.air_liquefying.AirLiquefyingRecipe;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedKinetics;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

@ParametersAreNonnullByDefault
public class AirLiquefyingCategory
extends CreateRecipeCategory<AirLiquefyingRecipe> {
    private final AnimatedAirLiquefier airLiquefier = new AnimatedAirLiquefier();
    protected static final int SCALE = 24;

    public AirLiquefyingCategory(CreateRecipeCategory.Info<AirLiquefyingRecipe> info) {
        super(info);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AirLiquefyingRecipe recipe, IFocusGroup focuses) {
        int size = recipe.getRollableResults().size() + recipe.getFluidResults().size();
        int i = 0;
        for (FluidStack fluidResult : recipe.getFluidResults()) {
            int xPosition = 142 - (size % 2 != 0 && i == size - 1 ? 0 : (i % 2 == 0 ? 10 : -9));
            int yPosition = -19 * (i / 2) + 51;
            AirLiquefyingCategory.addFluidSlot((IRecipeLayoutBuilder)builder, (int)xPosition, (int)yPosition, (FluidStack)fluidResult);
            ++i;
        }
    }

    public void draw(AirLiquefyingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        HeatCondition requiredHeat = recipe.getRequiredHeat();
        boolean noHeat = requiredHeat == HeatCondition.NONE;
        int vRows = (1 + recipe.getFluidResults().size() + recipe.getRollableResults().size()) / 2;
        if (vRows <= 2) {
            AllGuiTextures.JEI_DOWN_ARROW.render(graphics, 136, -19 * (vRows - 1) + 32);
        }
        AllGuiTextures shadow = noHeat ? AllGuiTextures.JEI_SHADOW : AllGuiTextures.JEI_LIGHT;
        shadow.render(graphics, 70, 58 + (noHeat ? 10 : 30));
        this.airLiquefier.draw(graphics, this.getBackground().getWidth() / 2 + 3, 34);
        PoseStack matrixStack = graphics.m_280168_();
        matrixStack.m_85836_();
        matrixStack.m_252880_(80.0f, 60.0f, 0.0f);
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(-12.5f));
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(22.5f));
        GuiGameElement.of((BlockState)((Block)ForgeRegistries.BLOCKS.getValue(recipe.getBlockInFront())).m_49966_()).lighting(AnimatedKinetics.DEFAULT_LIGHTING).scale(24.0).render(graphics);
        matrixStack.m_85849_();
    }
}

