/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.configs;

import com.rae.creatingspace.configs.CSCfgClient;
import com.rae.creatingspace.configs.CSCfgCommon;
import com.rae.creatingspace.configs.CSCfgServer;
import com.rae.creatingspace.configs.CSConfigBase;
import com.rae.creatingspace.configs.CSStress;
import com.simibubi.create.api.stress.BlockStressValues;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import net.createmod.catnip.config.ConfigBase;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CSConfigs {
    private static final Map<ModConfig.Type, ConfigBase> CONFIGS = new EnumMap<ModConfig.Type, ConfigBase>(ModConfig.Type.class);
    public static CSCfgClient CLIENT;
    public static CSCfgCommon COMMON;
    public static CSCfgServer SERVER;

    public static ConfigBase byType(ModConfig.Type type) {
        return CONFIGS.get(type);
    }

    private static <T extends CSConfigBase> T register(Supplier<T> factory, ModConfig.Type side) {
        Pair specPair = new ForgeConfigSpec.Builder().configure(builder -> {
            CSConfigBase config = (CSConfigBase)((Object)((Object)factory.get()));
            config.registerAll((ForgeConfigSpec.Builder)builder);
            return config;
        });
        CSConfigBase config = (CSConfigBase)((Object)specPair.getLeft());
        config.specification = (ForgeConfigSpec)specPair.getRight();
        CONFIGS.put(side, config);
        return (T)((Object)config);
    }

    public static void registerConfigs(ModLoadingContext context) {
        CLIENT = CSConfigs.register(CSCfgClient::new, ModConfig.Type.CLIENT);
        COMMON = CSConfigs.register(CSCfgCommon::new, ModConfig.Type.COMMON);
        SERVER = CSConfigs.register(CSCfgServer::new, ModConfig.Type.SERVER);
        for (Map.Entry<ModConfig.Type, ConfigBase> pair : CONFIGS.entrySet()) {
            context.registerConfig(pair.getKey(), (IConfigSpec)pair.getValue().specification);
        }
        CSStress stress = CSConfigs.SERVER.kinetics.stressValues;
        BlockStressValues.IMPACTS.registerProvider(stress::getImpact);
        BlockStressValues.CAPACITIES.registerProvider(stress::getCapacity);
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading event) {
        for (ConfigBase config : CONFIGS.values()) {
            if (config.specification != event.getConfig().getSpec()) continue;
            config.onLoad();
        }
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading event) {
        for (ConfigBase config : CONFIGS.values()) {
            if (config.specification != event.getConfig().getSpec()) continue;
            config.onReload();
        }
    }
}

