/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.content.life_support.sealer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import com.rae.creatingspace.configs.CSConfigs;
import com.rae.creatingspace.content.life_support.INeedOxygen;
import com.rae.creatingspace.content.life_support.sealer.RoomPressuriserBlockEntity;
import com.rae.creatingspace.content.life_support.sealer.RoomShape;
import com.rae.creatingspace.init.EntityDataSerializersInit;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.decoration.copycat.CopycatBlock;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Queue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class RoomAtmosphere
extends Entity {
    private static final EntityDataAccessor<RoomShape> SHAPE_DATA_ACCESSOR = SynchedEntityData.m_135353_(RoomAtmosphere.class, (EntityDataSerializer)EntityDataSerializersInit.SHAPE_SERIALIZER);
    private static final EntityDataAccessor<Integer> O2_AMOUNT = SynchedEntityData.m_135353_(RoomAtmosphere.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    ArrayList<BlockPos> roomSealers = new ArrayList();
    HashMap<ResourceLocation, AtmosphereFilterData> passiveFilters = new HashMap();
    Queue<BlockPos> toVist = new ArrayDeque<BlockPos>();
    private static final double[][] DEPTH_TEST_COORDINATES = new double[][]{{0.25, 0.25}, {0.25, 0.75}, {0.5, 0.5}, {0.75, 0.25}, {0.75, 0.75}};
    private static final UnboundedMapCodec<ResourceLocation, AtmosphereFilterData> PASSIVE_FILTER_CODEC = Codec.unboundedMap((Codec)ResourceLocation.f_135803_, AtmosphereFilterData.CODEC);

    public float getO2concentration() {
        return (float)((Integer)this.f_19804_.m_135370_(O2_AMOUNT)).intValue() / (float)this.getShape().volume;
    }

    public void addO2(int o2amount) {
        this.f_19804_.m_135381_(O2_AMOUNT, (Object)((int)Math.min((double)((Integer)this.f_19804_.m_135370_(O2_AMOUNT) + o2amount), 100.0 * this.getShape().getVolume())));
    }

    public RoomAtmosphere(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.f_19794_ = true;
    }

    public void regenerateRoom(BlockPos firstPos) {
        this.passiveFilters = new HashMap();
        this.roomSealers = new ArrayList();
        RoomShape shape = this.searchTopology(firstPos);
        this.m_20011_(shape.getEncapsulatingBox());
        this.f_19804_.m_135381_(SHAPE_DATA_ACCESSOR, (Object)shape);
    }

    private boolean contains(List<AABB> tempRoom, BlockPos tempPos) {
        for (AABB aabb : tempRoom) {
            if (!aabb.m_82390_(Vec3.m_82512_((Vec3i)tempPos))) continue;
            return true;
        }
        return false;
    }

    private RoomShape searchTopology(BlockPos start) {
        this.toVist.add(start);
        ArrayList<AABB> tempRoom = this.getShape().getListOfBox();
        tempRoom.removeIf(a -> a.m_82390_(Vec3.m_82512_((Vec3i)start)));
        int addedSize = 0;
        while (!this.toVist.isEmpty() && addedSize < (Integer)CSConfigs.SERVER.maxBlockPerTick.get()) {
            BlockPos tempPos = this.toVist.poll();
            assert (tempPos != null);
            if (this.contains(tempRoom, tempPos)) continue;
            AABB tempAabb = new AABB(tempPos);
            boolean canContinue = true;
            while (canContinue && tempAabb.m_82309_() < 30.0) {
                canContinue = false;
                for (Direction dir : Direction.values()) {
                    AABB expansion = tempAabb.m_82363_((double)dir.m_122436_().m_123341_(), (double)dir.m_122436_().m_123342_(), (double)dir.m_122436_().m_123343_());
                    AABB expandedPart = RoomAtmosphere.getExpandedPart(dir, tempAabb).m_82310_(1.0, 1.0, 1.0);
                    ArrayList<BlockPos> collectedPos = new ArrayList<BlockPos>();
                    boolean canBeExpandedToward = true;
                    for (BlockPos pos : BlockPos.m_121976_((int)Mth.m_14107_((double)expandedPart.f_82288_), (int)Mth.m_14107_((double)expandedPart.f_82289_), (int)Mth.m_14107_((double)expandedPart.f_82290_), (int)Mth.m_14107_((double)expandedPart.f_82291_), (int)Mth.m_14107_((double)expandedPart.f_82292_), (int)Mth.m_14107_((double)expandedPart.f_82293_))) {
                        if (!this.contains(tempRoom, pos)) {
                            collectedPos.add(pos.m_7949_());
                            continue;
                        }
                        canBeExpandedToward = false;
                    }
                    if (canBeExpandedToward) {
                        for (BlockPos pos : collectedPos) {
                            if (this.canGoThrough(this.m_9236_(), pos, dir) && this.canGoThrough(this.m_9236_(), tempPos, dir.m_122424_())) continue;
                            canBeExpandedToward = false;
                            break;
                        }
                    }
                    if (canBeExpandedToward) {
                        tempAabb = expansion;
                        canContinue = true;
                        continue;
                    }
                    for (BlockPos pos : collectedPos) {
                        if (this.canGoThrough(this.m_9236_(), pos, dir)) {
                            this.toVist.add(pos);
                            if (this.m_9236_().m_8055_(pos).m_60795_()) continue;
                            this.applyOnBlock(pos);
                            continue;
                        }
                        this.applyOnBlock(pos);
                    }
                }
            }
            tempRoom.add(tempAabb);
            addedSize += (int)(tempAabb.m_82362_() * tempAabb.m_82376_() * tempAabb.m_82385_());
        }
        RoomShape shape = new RoomShape(tempRoom, this.getShape().volume + addedSize);
        if (shape.volume >= (Integer)CSConfigs.SERVER.maxSizePerSealer.get() * Math.max(this.roomSealers.size(), 1)) {
            shape.setOpen();
            this.toVist = new ArrayDeque<BlockPos>();
        } else if (this.toVist.isEmpty()) {
            shape.setClosed();
            this.toVist = new ArrayDeque<BlockPos>();
        } else {
            shape.setOpen();
        }
        return shape;
    }

    @NotNull
    private static AABB getExpandedPart(Direction dir, AABB tempAabb) {
        double minX = tempAabb.f_82288_;
        double minY = tempAabb.f_82289_;
        double minZ = tempAabb.f_82290_;
        double maxX = tempAabb.f_82291_;
        double maxY = tempAabb.f_82292_;
        double maxZ = tempAabb.f_82293_;
        if (dir.m_122436_().m_123341_() < 0) {
            maxX = minX;
            minX -= 1.0;
        } else if (dir.m_122436_().m_123341_() > 0) {
            minX = maxX;
            maxX += 1.0;
        }
        if (dir.m_122436_().m_123342_() < 0) {
            maxY = minY;
            minY -= 1.0;
        } else if (dir.m_122436_().m_123342_() > 0) {
            minY = maxY;
            maxY += 1.0;
        }
        if (dir.m_122436_().m_123343_() < 0) {
            maxZ = minZ;
            minZ -= 1.0;
        } else if (dir.m_122436_().m_123343_() > 0) {
            minZ = maxZ;
            maxZ += 1.0;
        }
        return new AABB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    private void applyOnBlock(BlockPos pos) {
        BlockState state = this.m_9236_().m_8055_(pos);
        BlockEntity blockEntity = this.m_9236_().m_7702_(pos);
        if (blockEntity instanceof RoomPressuriserBlockEntity) {
            RoomPressuriserBlockEntity rp = (RoomPressuriserBlockEntity)blockEntity;
            if (!this.roomSealers.contains(pos)) {
                this.roomSealers.add(pos);
            }
        }
        if (state.m_60734_() instanceof LeavesBlock) {
            ResourceLocation location = state.m_60734_().m_204297_().m_205785_().m_135782_();
            if (this.passiveFilters.containsKey(location)) {
                this.passiveFilters.put(location, this.passiveFilters.get(location).add(pos));
            } else {
                this.passiveFilters.put(location, new AtmosphereFilterData(new ArrayList<BlockPos>(List.of(pos)), (Integer)CSConfigs.SERVER.leafOxygenProduction.get()));
            }
        }
    }

    private boolean canGoThrough(Level world, BlockPos currentPos, Direction dir) {
        BlockState state = world.m_8055_(currentPos);
        BlockState copycatState = CopycatBlock.getMaterial((BlockGetter)world, (BlockPos)currentPos);
        if (RoomAtmosphere.shouldAlwaysPass(copycatState.m_60795_() ? state : copycatState)) {
            return true;
        }
        VoxelShape shape = state.m_60812_((BlockGetter)world, currentPos);
        if (shape.m_83281_()) {
            return true;
        }
        if (shape == Shapes.m_83144_()) {
            return false;
        }
        double shapeDepth = RoomAtmosphere.findMaxDepth(shape, dir);
        return shapeDepth == Double.POSITIVE_INFINITY;
    }

    private static double findMaxDepth(VoxelShape shape, Direction direction) {
        Direction.Axis axis = direction.m_122434_();
        Direction.AxisDirection axisDirection = direction.m_122421_();
        double maxDepth = 0.0;
        for (double[] coordinates : DEPTH_TEST_COORDINATES) {
            double depth;
            if (axisDirection == Direction.AxisDirection.POSITIVE) {
                double min = shape.m_166078_(axis, coordinates[0], coordinates[1]);
                if (min == Double.POSITIVE_INFINITY) {
                    return Double.POSITIVE_INFINITY;
                }
                depth = min;
            } else {
                double max = shape.m_83290_(axis, coordinates[0], coordinates[1]);
                if (max == Double.NEGATIVE_INFINITY) {
                    return Double.POSITIVE_INFINITY;
                }
                depth = 1.0 - max;
            }
            if (!(depth > maxDepth)) continue;
            maxDepth = depth;
        }
        return maxDepth;
    }

    private static boolean shouldAlwaysPass(BlockState state) {
        return AllTags.AllBlockTags.FAN_TRANSPARENT.matches(state);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(SHAPE_DATA_ACCESSOR, (Object)new RoomShape(new ArrayList<AABB>()));
        this.f_19804_.m_135372_(O2_AMOUNT, (Object)0);
    }

    protected void m_7378_(CompoundTag nbt) {
        this.passiveFilters = new HashMap(PASSIVE_FILTER_CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)nbt.m_128423_("passiveFilters")).result().orElse(new HashMap()));
        this.f_19804_.m_135381_(O2_AMOUNT, (Object)nbt.m_128451_("o2amount"));
        this.f_19804_.m_135381_(SHAPE_DATA_ACCESSOR, (Object)RoomShape.fromNbt((CompoundTag)nbt.m_128423_("shape")));
    }

    protected void m_7380_(CompoundTag nbt) {
        nbt.m_128365_("passiveFilters", (Tag)PASSIVE_FILTER_CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, this.passiveFilters).result().orElse(new CompoundTag()));
        nbt.m_128405_("o2amount", ((Integer)this.f_19804_.m_135370_(O2_AMOUNT)).intValue());
        nbt.m_128365_("shape", (Tag)this.getShape().toNbt());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static EntityType.Builder<?> build(EntityType.Builder<?> builder) {
        EntityType.Builder<?> entityBuilder = builder;
        return entityBuilder.m_20699_(1.0f, 1.0f);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            if (!this.toVist.isEmpty()) {
                this.f_19804_.m_135381_(SHAPE_DATA_ACCESSOR, (Object)this.searchTopology(this.toVist.poll()));
            }
            if (!this.getShape().closed) {
                this.f_19804_.m_135381_(O2_AMOUNT, (Object)0);
            }
            if (this.hasShape()) {
                List<Entity> entitiesInside = this.getShape().getEntitiesInside(this.m_9236_());
                for (Entity entity : entitiesInside) {
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity living = (LivingEntity)entity;
                    if (!this.breathable()) continue;
                    this.consumeO2();
                    ((INeedOxygen)living).setInsideOxygenRoom(true);
                }
                for (AtmosphereFilterData data : this.passiveFilters.values()) {
                    this.addO2(data.globalImpact);
                }
            }
        }
        if (this.f_19797_ % 10 == 0) {
            this.lazyTick();
        }
    }

    public void lazyTick() {
        AABB box = this.getShape().getEncapsulatingBox();
        this.m_20011_(box == null ? new AABB(this.m_20097_()) : box);
    }

    public boolean hasShape() {
        return !this.getShape().listOfBox.isEmpty();
    }

    public void consumeO2() {
        if ((Integer)this.f_19804_.m_135370_(O2_AMOUNT) >= (Integer)CSConfigs.SERVER.livingO2Consumption.get()) {
            this.f_19804_.m_135381_(O2_AMOUNT, (Object)((Integer)this.f_19804_.m_135370_(O2_AMOUNT) - (Integer)CSConfigs.SERVER.livingO2Consumption.get()));
        }
    }

    public boolean breathable() {
        return (double)((Integer)this.f_19804_.m_135370_(O2_AMOUNT)).intValue() / this.getShape().getVolume() > 10.0 && this.getShape().isClosed();
    }

    protected boolean m_20073_() {
        return false;
    }

    public RoomShape getShape() {
        return (RoomShape)this.f_19804_.m_135370_(SHAPE_DATA_ACCESSOR);
    }

    public void resetShape() {
        this.f_19804_.m_135381_(SHAPE_DATA_ACCESSOR, (Object)new RoomShape(List.of()));
    }

    public record AtmosphereFilterData(ArrayList<BlockPos> positions, Integer individualImpact, int globalImpact) {
        public static Codec<AtmosphereFilterData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)BlockPos.f_121852_).fieldOf("positions").forGetter(i -> i.positions), (App)Codec.INT.fieldOf("individualImpact").forGetter(i -> i.individualImpact)).apply((Applicative)instance, AtmosphereFilterData::new));

        AtmosphereFilterData(List<BlockPos> positions, int individualImpact) {
            this(new ArrayList<BlockPos>(positions), individualImpact, individualImpact * positions.size());
        }

        public AtmosphereFilterData add(BlockPos pos) {
            if (!this.positions.contains(pos)) {
                this.positions.add(pos);
            }
            return new AtmosphereFilterData(this.positions, this.individualImpact, this.globalImpact + this.individualImpact);
        }

        public AtmosphereFilterData remove(BlockPos pos) {
            boolean flag = this.positions.remove(pos);
            return new AtmosphereFilterData(this.positions, this.individualImpact, flag ? this.globalImpact - this.individualImpact : this.globalImpact);
        }
    }
}

