/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.content.life_support.sealer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.rae.creatingspace.CreatingSpace;
import com.rae.creatingspace.configs.CSConfigs;
import com.rae.creatingspace.content.life_support.sealer.RoomAtmosphere;
import java.util.ConcurrentModificationException;
import java.util.List;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.outliner.AABBOutline;
import net.createmod.catnip.render.DefaultSuperRenderTypeBuffer;
import net.createmod.catnip.render.SuperRenderTypeBuffer;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class RoomAtmosphereRenderer
extends EntityRenderer<RoomAtmosphere> {
    private static final ResourceLocation ROOM_ATMOSPHERE_LOCATION = CreatingSpace.resource("textures/entity/room_atmosphere_overlay.png");

    public RoomAtmosphereRenderer(EntityRendererProvider.Context p_174008_) {
        super(p_174008_);
    }

    public boolean shouldRender(@NotNull RoomAtmosphere atmosphere, @NotNull Frustum frustum, double p_114493_, double p_114494_, double p_114495_) {
        return (Boolean)CSConfigs.CLIENT.oxygenRoomDebugMode.get();
    }

    public void render(@NotNull RoomAtmosphere roomAtmosphere, float cameraX, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int p_114604_) {
        try {
            poseStack.m_85836_();
            float pt = AnimationTickHolder.getPartialTicks();
            DefaultSuperRenderTypeBuffer superBuffer = DefaultSuperRenderTypeBuffer.getInstance();
            List<AABB> tempCopy = List.copyOf(roomAtmosphere.getShape().getListOfBox());
            for (AABB aabb : tempCopy) {
                AABBOutline outline = new AABBOutline(aabb);
                Color outlineColor = roomAtmosphere.breathable() ? new Color(30, 50, (int)(200.0f * roomAtmosphere.getO2concentration() / 100.0f), 20) : new Color(50, 30, 0);
                outline.getParams().colored(outlineColor);
                outline.render(poseStack, (SuperRenderTypeBuffer)superBuffer, roomAtmosphere.m_20182_(), pt);
            }
            superBuffer.draw();
            RenderSystem.enableCull();
            poseStack.m_85849_();
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        super.m_7392_((Entity)roomAtmosphere, cameraX, partialTick, poseStack, bufferSource, p_114604_);
    }

    public ResourceLocation getTextureLocation(RoomAtmosphere atmosphere) {
        return ROOM_ATMOSPHERE_LOCATION;
    }
}

