/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.content.life_support.spacesuit;

import com.rae.creatingspace.content.life_support.spacesuit.OxygenBacktankUtil;
import com.rae.creatingspace.content.life_support.spacesuit.UpgradableEquipment;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class SpacesuitHelmetItem
extends UpgradableEquipment {
    public static final ArmorItem.Type TYPE = ArmorItem.Type.HELMET;

    public SpacesuitHelmetItem(ArmorMaterial material, Item.Properties properties, ResourceLocation textureLoc) {
        super(material, TYPE, properties, textureLoc);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44971_) {
            return false;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public int getEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44971_) {
            return 1;
        }
        return super.getEnchantmentLevel(stack, enchantment);
    }

    public Map<Enchantment, Integer> getAllEnchantments(ItemStack stack) {
        Map map = super.getAllEnchantments(stack);
        map.put(Enchantments.f_44971_, 1);
        return map;
    }

    public static boolean isWornBy(Entity entity) {
        return !SpacesuitHelmetItem.getWornItem(entity).m_41619_();
    }

    public static ItemStack getWornItem(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return ItemStack.f_41583_;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        ItemStack stack = livingEntity.m_6844_(TYPE.m_266308_());
        if (!(stack.m_41720_() instanceof SpacesuitHelmetItem)) {
            return ItemStack.f_41583_;
        }
        return stack;
    }

    @SubscribeEvent
    public static void breatheUnderwater(LivingEvent.LivingTickEvent event) {
        ServerPlayer sp;
        ItemStack helmet;
        boolean drowning;
        LivingEntity entity = event.getEntity();
        Level world = entity.m_9236_();
        boolean second = world.m_46467_() % 20L == 0L;
        boolean bl = drowning = entity.m_20146_() == 0;
        if (world.f_46443_) {
            entity.getPersistentData().m_128473_("VisualBacktankAir");
        }
        if ((helmet = SpacesuitHelmetItem.getWornItem((Entity)entity)).m_41619_()) {
            return;
        }
        boolean lavaDiving = entity.m_20077_();
        if (!helmet.m_41720_().m_41475_() && lavaDiving) {
            return;
        }
        if (!entity.canDrownInFluidType(entity.getEyeInFluidType()) && !lavaDiving) {
            return;
        }
        if (entity instanceof Player && ((Player)entity).m_7500_()) {
            return;
        }
        List<ItemStack> O2Backtanks = OxygenBacktankUtil.getAllWithOxygen(entity);
        if (O2Backtanks.isEmpty()) {
            return;
        }
        if (lavaDiving) {
            if (entity instanceof ServerPlayer) {
                sp = (ServerPlayer)entity;
                AllAdvancements.DIVING_SUIT_LAVA.awardTo((Player)sp);
            }
            if (O2Backtanks.stream().noneMatch(backtank -> backtank.m_41720_().m_41475_())) {
                return;
            }
        }
        if (drowning) {
            entity.m_20301_(10);
        }
        if (world.f_46443_) {
            entity.getPersistentData().m_128405_("VisualBacktankAir", Math.round(O2Backtanks.stream().map(OxygenBacktankUtil::getOxygen).reduce(Float.valueOf(0.0f), Float::sum).floatValue()));
        }
        if (!second) {
            return;
        }
        OxygenBacktankUtil.consumeOxygen(entity, O2Backtanks.get(0), 1);
        if (lavaDiving) {
            return;
        }
        if (entity instanceof ServerPlayer) {
            sp = (ServerPlayer)entity;
            AllAdvancements.DIVING_SUIT.awardTo((Player)sp);
        }
        entity.m_20301_(Math.min(entity.m_6062_(), entity.m_20146_() + 10));
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19608_, 30, 0, true, false, true));
    }
}

