/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.content.planets.worldgen;

import com.mojang.serialization.Codec;
import com.rae.creatingspace.content.planets.worldgen.CraterCarverConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.createmod.catnip.data.Couple;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class CraterCarver
extends WorldCarver<CraterCarverConfig> {
    public HashMap<Couple<Integer>, Integer> heightMap = new HashMap();

    public CraterCarver(Codec codec) {
        super(codec);
    }

    public boolean carve(CarvingContext context, CraterCarverConfig config, ChunkAccess chunk, Function<BlockPos, Holder<Biome>> posToBiome, RandomSource random, Aquifer aquiferSampler, ChunkPos pos, CarvingMask carvingMask) {
        boolean fresh;
        int x = random.m_188503_(16);
        int z = random.m_188503_(16);
        int y = this.getHeightInInitialChunkIfClose(context, config, chunk, pos, x, z);
        BlockPos craterCenter = pos.m_151384_(x, y, z);
        BlockPos.MutableBlockPos mutable = craterCenter.m_122032_();
        double radius = 8.0 + random.m_188500_() * (double)(config.maxRadius - config.minRadius);
        if (random.m_188499_() && radius < (double)(config.minRadius + config.idealRangeOffset) || radius > (double)(config.maxRadius - config.idealRangeOffset)) {
            radius = 8.0 + random.m_188500_() * (double)(config.maxRadius - config.minRadius);
        }
        double depthMultiplier = 1.0 - (random.m_188500_() - 0.5) * 0.3;
        boolean bl = fresh = random.m_188503_(16) == 1;
        if (chunk.m_187678_()) {
            for (Map.Entry entry : chunk.m_6633_().entrySet()) {
                if (!((Structure)entry.getKey()).m_226619_().equals((Object)GenerationStep.Decoration.SURFACE_STRUCTURES)) continue;
                double xDev = Math.abs(chunk.m_7697_().m_151382_(((StructureStart)entry.getValue()).m_73601_().m_162394_().m_123341_()) - craterCenter.m_123341_());
                double zDev = Math.abs(chunk.m_7697_().m_151391_(((StructureStart)entry.getValue()).m_73601_().m_162394_().m_123343_()) - craterCenter.m_123343_());
                if (!(xDev >= 0.0) || !(xDev < 32.0) || !(zDev >= 0.0) || !(zDev < 32.0) || !(xDev * xDev + zDev * zDev < radius * radius)) continue;
                double sqrtY = (xDev /= radius) * xDev + (zDev /= radius) * zDev;
                double yDev = sqrtY * sqrtY * 6.0;
                double craterDepth = 5.0 - yDev;
                BoundingBox boundingBox = ((StructureStart)entry.getValue()).m_73601_().m_71045_(0, (int)(-(craterDepth *= depthMultiplier)), 0);
                ((Structure)entry.getKey()).m_226569_(boundingBox);
            }
        }
        for (int innerChunkX = 0; innerChunkX < 16; ++innerChunkX) {
            for (int innerChunkZ = 0; innerChunkZ < 16; ++innerChunkZ) {
                double toDig = 0.0;
                double xDev = Math.abs(chunk.m_7697_().m_151382_(innerChunkX) - craterCenter.m_123341_());
                double zDev = Math.abs(chunk.m_7697_().m_151391_(innerChunkZ) - craterCenter.m_123343_());
                if (!(xDev >= 0.0) || !(xDev < 32.0) || !(zDev >= 0.0) || !(zDev < 32.0)) continue;
                if (xDev * xDev + zDev * zDev < radius * radius) {
                    double sqrtY = (xDev /= radius) * xDev + (zDev /= radius) * zDev;
                    double yDev = sqrtY * sqrtY * 6.0;
                    double craterDepth = 5.0 - yDev;
                    if ((craterDepth *= depthMultiplier) > 0.0) {
                        toDig = craterDepth;
                    }
                }
                if (toDig >= 1.0) {
                    toDig += 1.0;
                    if (fresh) {
                        toDig += 1.0;
                    }
                }
                BlockPos.MutableBlockPos copy = new BlockPos.MutableBlockPos();
                mutable.m_122178_(innerChunkX, y, innerChunkZ);
                if (toDig > 0.0) {
                    while (!chunk.m_8055_((BlockPos)mutable).m_60795_()) {
                        mutable.m_122173_(Direction.UP);
                        toDig += 1.0;
                    }
                }
                int dug = 0;
                while ((double)dug < toDig) {
                    mutable.m_122173_(Direction.DOWN);
                    if (!chunk.m_8055_((BlockPos)mutable).m_60795_() || carvingMask.m_187594_(innerChunkX, mutable.m_123342_(), innerChunkZ) || dug > 0) {
                        if (!carvingMask.m_187594_(innerChunkX, mutable.m_123342_(), innerChunkZ)) {
                            chunk.m_6978_((BlockPos)mutable, f_64979_, true);
                            carvingMask.m_187585_(innerChunkX, mutable.m_123342_(), innerChunkZ);
                            if (!fresh && (double)(dug + 1) >= toDig && !chunk.m_8055_((BlockPos)copy.m_122190_((Vec3i)mutable).m_122175_(Direction.DOWN, 2)).m_60795_()) {
                                context.m_190646_(posToBiome, chunk, (BlockPos)mutable, true).ifPresent(blockStates -> chunk.m_6978_((BlockPos)mutable.m_122173_(Direction.DOWN), blockStates, true));
                            }
                        }
                    } else {
                        --dug;
                        toDig -= 1.0;
                    }
                    ++dug;
                }
            }
        }
        return true;
    }

    private int getHeightInInitialChunkIfClose(CarvingContext context, CraterCarverConfig config, ChunkAccess chunk, final ChunkPos pos, final int x, final int z) {
        double density = -1.0;
        int y = chunk.m_151558_();
        Couple coor = Couple.create((Object)pos.m_151382_(x), (Object)pos.m_151391_(z));
        if (chunk.m_7697_().m_45594_(pos) <= config.maxRadius / 16 + 1) {
            if (this.heightMap.containsKey(coor)) {
                return this.heightMap.get(coor);
            }
            while (density < 0.0 && y > chunk.m_141937_()) {
                final int finalY = y--;
                DensityFunction.FunctionContext functionContext = new DensityFunction.FunctionContext(){

                    public int m_207115_() {
                        return pos.m_151382_(x);
                    }

                    public int m_207114_() {
                        return finalY;
                    }

                    public int m_207113_() {
                        return pos.m_151391_(z);
                    }
                };
                density = context.m_224851_().m_224578_().f_209391_().m_207386_(functionContext);
                if (!(density < 0.0)) continue;
            }
            this.heightMap.put((Couple<Integer>)coor, y);
        }
        return y;
    }

    public boolean isStartChunk(CraterCarverConfig config, RandomSource random) {
        return random.m_188501_() <= config.f_67859_;
    }
}

