/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.content.ponders;

import com.rae.creatingspace.init.PonderInit;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.crank.ValveHandleBlock;
import com.simibubi.create.content.logistics.packagePort.postbox.PostboxBlock;
import com.simibubi.create.content.logistics.tableCloth.TableClothBlock;
import com.simibubi.create.foundation.ponder.PonderWorldBlockEntityFix;
import com.simibubi.create.infrastructure.ponder.AllCreatePonderTags;
import net.createmod.ponder.api.level.PonderLevel;
import net.createmod.ponder.api.registration.IndexExclusionHelper;
import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.api.registration.PonderSceneRegistrationHelper;
import net.createmod.ponder.api.registration.PonderTagRegistrationHelper;
import net.createmod.ponder.api.registration.SharedTextRegistrationHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import org.lwjgl.system.NonnullDefault;

@NonnullDefault
public class CSPonderPlugin
implements PonderPlugin {
    public String getModId() {
        return "creatingspace";
    }

    public void registerScenes(PonderSceneRegistrationHelper<ResourceLocation> helper) {
        PonderInit.register(helper);
    }

    public void registerTags(PonderTagRegistrationHelper<ResourceLocation> helper) {
        AllCreatePonderTags.register(helper);
    }

    public void registerSharedText(SharedTextRegistrationHelper helper) {
        helper.registerSharedText("rpm8", "8 RPM");
        helper.registerSharedText("rpm16", "16 RPM");
        helper.registerSharedText("rpm16_source", "Source: 16 RPM");
        helper.registerSharedText("rpm32", "32 RPM");
        helper.registerSharedText("movement_anchors", "With the help of Super Glue, larger structures can be moved.");
        helper.registerSharedText("behaviour_modify_value_panel", "This behaviour can be modified using the value panel");
        helper.registerSharedText("storage_on_contraption", "Inventories attached to the Contraption will pick up their drops automatically");
    }

    public void onPonderLevelRestore(PonderLevel ponderLevel) {
        PonderWorldBlockEntityFix.fixControllerBlockEntities((PonderLevel)ponderLevel);
    }

    public void indexExclusions(IndexExclusionHelper helper) {
        helper.excludeBlockVariants(ValveHandleBlock.class, (Block)AllBlocks.COPPER_VALVE_HANDLE.get());
        helper.excludeBlockVariants(PostboxBlock.class, (Block)AllBlocks.PACKAGE_POSTBOXES.get(DyeColor.WHITE).get());
        helper.excludeBlockVariants(TableClothBlock.class, (Block)AllBlocks.TABLE_CLOTHS.get(DyeColor.WHITE).get());
    }
}

