/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.content.recipes;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.AbstractIngredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class IntRangeNbtIngredient
extends AbstractIngredient {
    public final Set<Item> items;
    ArrayList<String> path = null;
    int min;
    int max;
    public CompoundTag range_data;

    public IntRangeNbtIngredient(Set<Item> items, CompoundTag range_data) {
        this.items = items;
        this.range_data = range_data;
        this.path = new ArrayList<String>(List.of(range_data.m_128461_("path").split("/")));
        this.min = range_data.m_128441_("min") ? range_data.m_128451_("min") : Integer.MIN_VALUE;
        this.max = range_data.m_128441_("max") ? range_data.m_128451_("max") : Integer.MAX_VALUE;
    }

    public boolean test(@Nullable ItemStack input) {
        if (input == null) {
            return false;
        }
        boolean flag1 = this.items.contains(input.m_41720_());
        boolean flag2 = this.matches(input.getShareTag());
        return flag1 && flag2;
    }

    private boolean matches(CompoundTag shareTag) {
        try {
            CompoundTag tag = shareTag.m_6426_();
            for (String partialPath : this.path.subList(0, this.path.size() - 1)) {
                assert (tag != null);
                tag = (CompoundTag)tag.m_128423_(partialPath);
            }
            assert (tag != null);
            int value = tag.m_128451_(this.path.get(this.path.size() - 1));
            if (value >= this.min || value <= this.max) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement m_43942_() {
        return null;
    }

    public ItemStack[] m_43908_() {
        ItemStack[] acc = new ItemStack[2 * this.items.size()];
        int i = 0;
        if (!this.path.isEmpty()) {
            for (Item item : this.items) {
                ItemStack firstLimit = item.m_7968_();
                ItemStack lastLimit = item.m_7968_();
                CompoundTag minTag = new CompoundTag();
                CompoundTag maxTag = new CompoundTag();
                minTag.m_128405_(this.path.get(this.path.size() - 1), this.min);
                maxTag.m_128405_(this.path.get(this.path.size() - 1), this.max);
                if (this.path.size() > 1) {
                    List<String> shallowCopy = this.path.subList(1, this.path.size());
                    Collections.reverse(shallowCopy);
                    for (String partialPath : shallowCopy) {
                        CompoundTag tempMin = new CompoundTag();
                        CompoundTag tempMax = new CompoundTag();
                        tempMin.m_128365_(partialPath, (Tag)minTag.m_6426_());
                        tempMax.m_128365_(partialPath, (Tag)maxTag.m_6426_());
                        minTag = tempMin.m_6426_();
                        maxTag = tempMax.m_6426_();
                    }
                }
                firstLimit.m_41751_(minTag);
                lastLimit.m_41751_(maxTag);
                acc[i] = firstLimit;
                acc[i + 1] = lastLimit;
                ++i;
            }
        }
        return acc;
    }

    public static class Serializer
    implements IIngredientSerializer<IntRangeNbtIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        public IntRangeNbtIngredient parse(JsonObject json) {
            ImmutableSet items;
            if (json.has("item")) {
                items = Set.of(CraftingHelper.getItem((String)GsonHelper.m_13906_((JsonObject)json, (String)"item"), (boolean)true));
            } else if (json.has("items")) {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                JsonArray itemArray = GsonHelper.m_13933_((JsonObject)json, (String)"items");
                for (int i = 0; i < itemArray.size(); ++i) {
                    builder.add((Object)CraftingHelper.getItem((String)GsonHelper.m_13805_((JsonElement)itemArray.get(i), (String)("items[" + i + "]")), (boolean)true));
                }
                items = builder.build();
            } else {
                throw new JsonSyntaxException("Must set either 'item' or 'items'");
            }
            if (!json.has("range_data")) {
                throw new JsonSyntaxException("Missing range_data, expected to find a JsonObject");
            }
            CompoundTag nbt = CraftingHelper.getNBT((JsonElement)json.get("range_data"));
            return new IntRangeNbtIngredient((Set<Item>)items, nbt);
        }

        public IntRangeNbtIngredient parse(FriendlyByteBuf buffer) {
            Set<Item> items = Stream.generate(() -> (Item)buffer.readRegistryIdUnsafe(ForgeRegistries.ITEMS)).limit(buffer.m_130242_()).collect(Collectors.toSet());
            CompoundTag nbt = buffer.m_130260_();
            return new IntRangeNbtIngredient(items, Objects.requireNonNull(nbt));
        }

        public void write(FriendlyByteBuf buffer, IntRangeNbtIngredient ingredient) {
            buffer.m_130130_(ingredient.items.size());
            for (Item item : ingredient.items) {
                buffer.writeRegistryIdUnsafe(ForgeRegistries.ITEMS, (Object)item);
            }
            buffer.m_130079_(ingredient.range_data);
        }
    }
}

