/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.content.recipes.air_liquefying;

import com.google.gson.JsonObject;
import com.rae.creatingspace.content.recipes.air_liquefying.AirLiquefierBlock;
import com.rae.creatingspace.content.recipes.air_liquefying.AirLiquefierBlockEntity;
import com.rae.creatingspace.init.RecipeInit;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class AirLiquefyingRecipe
extends ProcessingRecipe<SmartInventory> {
    private ResourceLocation blockInFront;
    private ResourceLocation dimension;

    public static boolean match(AirLiquefierBlockEntity airLiquefierBlockEntity, Recipe<?> recipe) {
        return AirLiquefyingRecipe.apply(airLiquefierBlockEntity, recipe, true);
    }

    public static boolean apply(AirLiquefierBlockEntity airLiquefierBlockEntity, Recipe<?> recipe) {
        return AirLiquefyingRecipe.apply(airLiquefierBlockEntity, recipe, false);
    }

    private static boolean apply(AirLiquefierBlockEntity airLiquefierBlockEntity, Recipe<?> recipe, boolean test) {
        if (recipe instanceof AirLiquefyingRecipe) {
            AirLiquefyingRecipe airLiquefyingRecipe = (AirLiquefyingRecipe)recipe;
            BlockState state = airLiquefierBlockEntity.m_58900_();
            BlockState targetedState = airLiquefierBlockEntity.m_58904_().m_8055_(airLiquefierBlockEntity.m_58899_().m_121945_((Direction)state.m_61143_((Property)AirLiquefierBlock.FACING)));
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(airLiquefyingRecipe.getBlockInFront());
            if (block != null && !targetedState.m_60713_(block)) {
                return false;
            }
            ResourceLocation currentDimension = airLiquefierBlockEntity.m_58904_().m_46472_().m_135782_();
            if (airLiquefyingRecipe.getDimension() != null && !currentDimension.equals((Object)airLiquefyingRecipe.getDimension())) {
                return false;
            }
        } else {
            return false;
        }
        ArrayList<FluidStack> recipeOutputFluids = new ArrayList<FluidStack>();
        for (boolean simulate : Iterate.trueAndFalse) {
            if (!simulate && test) {
                return true;
            }
            if (simulate) {
                AirLiquefyingRecipe basinRecipe = (AirLiquefyingRecipe)recipe;
                recipeOutputFluids.addAll((Collection<FluidStack>)basinRecipe.getFluidResults());
            }
            if (airLiquefierBlockEntity.acceptOutputs(recipeOutputFluids, simulate)) continue;
            return false;
        }
        return true;
    }

    protected AirLiquefyingRecipe(IRecipeTypeInfo type, ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        super(type, params);
    }

    public ResourceLocation getBlockInFront() {
        return this.blockInFront;
    }

    public ResourceLocation getDimension() {
        return this.dimension;
    }

    protected int getMaxInputCount() {
        return 0;
    }

    protected int getMaxOutputCount() {
        return 0;
    }

    public AirLiquefyingRecipe(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        this(RecipeInit.AIR_LIQUEFYING, params);
    }

    protected int getMaxFluidOutputCount() {
        return 2;
    }

    protected boolean canSpecifyDuration() {
        return true;
    }

    public boolean matches(SmartInventory inv, @Nonnull Level worldIn) {
        return false;
    }

    public void readAdditional(JsonObject json) {
        super.readAdditional(json);
        this.blockInFront = json.get("blockInFront") != null ? new ResourceLocation(String.valueOf(json.get("blockInFront")).replaceAll(String.valueOf('\"'), "")) : null;
        this.dimension = json.get("dimension") != null ? new ResourceLocation(String.valueOf(json.get("dimension")).replaceAll(String.valueOf('\"'), "")) : null;
    }

    public void readAdditional(FriendlyByteBuf buffer) {
        super.readAdditional(buffer);
        this.blockInFront = buffer.m_130281_();
        if (this.blockInFront.equals((Object)new ResourceLocation("minecraft:_"))) {
            this.blockInFront = null;
        }
        this.dimension = buffer.m_130281_();
        if (this.dimension.equals((Object)new ResourceLocation("minecraft:_"))) {
            this.dimension = null;
        }
    }

    public void writeAdditional(JsonObject json) {
        super.writeAdditional(json);
        if (this.blockInFront != null) {
            json.addProperty("blockInFront", this.blockInFront.toString());
        }
        if (this.dimension != null) {
            json.addProperty("dimension", this.dimension.toString());
        }
    }

    public void writeAdditional(FriendlyByteBuf buffer) {
        super.writeAdditional(buffer);
        if (this.blockInFront != null) {
            buffer.m_130085_(this.blockInFront);
        } else {
            buffer.m_130085_(new ResourceLocation("minecraft:_"));
        }
        if (this.dimension != null) {
            buffer.m_130085_(this.dimension);
        } else {
            buffer.m_130085_(new ResourceLocation("minecraft:_"));
        }
    }
}

