/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.content.rocket;

import com.rae.creatingspace.content.planets.CSDimensionUtil;
import com.rae.creatingspace.content.rocket.RocketContraptionEntity;
import java.util.function.Function;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import org.jetbrains.annotations.Nullable;

public class CustomTeleporter
implements ITeleporter {
    protected final ServerLevel level;

    public CustomTeleporter(ServerLevel level) {
        this.level = level;
    }

    public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
        return repositionEntity.apply(false);
    }

    @Nullable
    public PortalInfo getPortalInfo(Entity entity, ServerLevel destWorld, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
        Vec3 position;
        double height = CSDimensionUtil.arrivalHeight(destWorld.m_46472_().m_135782_());
        if (entity instanceof RocketContraptionEntity) {
            RocketContraptionEntity rocketContraptionEntity = (RocketContraptionEntity)entity;
            position = new Vec3((double)rocketContraptionEntity.getInitialPosMap().get(destWorld.m_46472_().m_135782_()).m_123341_(), height, (double)rocketContraptionEntity.getInitialPosMap().get(destWorld.m_46472_().m_135782_()).m_123343_());
        } else {
            position = new Vec3(entity.m_20185_(), height, entity.m_20189_());
        }
        return new PortalInfo(position, Vec3.f_82478_, entity.m_146908_(), entity.m_146909_());
    }

    public boolean isVanilla() {
        return false;
    }

    public boolean playTeleportSound(ServerPlayer player, ServerLevel sourceWorld, ServerLevel destWorld) {
        return false;
    }
}

