/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.content.rocket;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.rae.creatingspace.CreatingSpace;
import com.rae.creatingspace.api.squedule.RocketPath;
import com.rae.creatingspace.api.squedule.RocketScheduleRuntime;
import com.rae.creatingspace.configs.CSConfigs;
import com.rae.creatingspace.content.planets.CSDimensionUtil;
import com.rae.creatingspace.content.rocket.CustomTeleporter;
import com.rae.creatingspace.content.rocket.contraption.RocketContraption;
import com.rae.creatingspace.content.rocket.engine.design.PropellantType;
import com.rae.creatingspace.content.rocket.network.RocketContraptionUpdatePacket;
import com.rae.creatingspace.content.rocket.network.RocketEntryPosMapClientPacket;
import com.rae.creatingspace.content.rocket.rocket_control.RocketControlsBlockEntity;
import com.rae.creatingspace.init.EntityDataSerializersInit;
import com.rae.creatingspace.init.PacketInit;
import com.rae.creatingspace.init.ingameobject.EntityInit;
import com.rae.creatingspace.init.ingameobject.PropellantTypeInit;
import com.rae.creatingspace.init.ingameobject.SoundInit;
import com.rae.creatingspace.legacy.utilities.CSNBTUtil;
import com.rae.creatingspace.legacy.utilities.data.FlightDataHelper;
import com.simibubi.create.api.contraption.storage.fluid.MountedFluidStorageWrapper;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ContraptionCollider;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.contraptions.TranslatingContraption;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class RocketContraptionEntity
extends AbstractContraptionEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    double clientOffsetDiff;
    double speed;
    int soundEffectTickCount = 0;
    static int ROCKET_SOUND_LENGTH = 60;
    boolean shouldHandleCalculation = false;
    HashMap<PropellantType, RocketContraption.ConsumptionInfo> theoreticalPerTagFluidConsumption;
    HashMap<PropellantType, RocketContraption.ConsumptionInfo> realPerTagFluidConsumption;
    HashMap<TagKey<Fluid>, Float> partialDrainAmountPerFluid = new HashMap();
    public static Codec<HashMap<PropellantType, RocketContraption.ConsumptionInfo>> CODEC_MAP_INFO = Codec.unboundedMap((Codec)PropellantTypeInit.getSyncedPropellantRegistry().m_194605_(), RocketContraption.ConsumptionInfo.CODEC).xmap(HashMap::new, i -> i);
    public static Codec<HashMap<TagKey<Fluid>, Float>> CODEC_MAP_CONSUMPTION = Codec.unboundedMap((Codec)TagKey.m_203877_((ResourceKey)Registries.f_256808_), (Codec)Codec.FLOAT).xmap(HashMap::new, i -> i);
    public float totalThrust = 0.0f;
    public float initialMass;
    public ResourceLocation originDimension = Level.f_46428_.m_135782_();
    public ResourceLocation destination;
    private List<BlockPos> localPosOfFlightRecorders;
    public FlightDataHelper.RocketAssemblyData assemblyData;
    public HashMap<TagKey<Fluid>, ArrayList<Fluid>> consumableFluids = new HashMap();
    private HashMap<ResourceLocation, BlockPos> initialPosMap;
    public RocketScheduleRuntime schedule = new RocketScheduleRuntime(this);
    public static final EntityDataAccessor<RocketStatus> STATUS_DATA_ACCESSOR = SynchedEntityData.m_135353_(RocketContraptionEntity.class, EntityDataSerializersInit.STATUS_SERIALIZER);

    public RocketContraptionEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public static RocketContraptionEntity create(Level level, RocketContraption contraption, ResourceLocation destination) {
        RocketContraptionEntity entity = new RocketContraptionEntity((EntityType)EntityInit.ROCKET_CONTRAPTION.get(), level);
        entity.originDimension = level.m_46472_().m_135782_();
        entity.destination = destination;
        entity.setContraption((Contraption)contraption);
        entity.realPerTagFluidConsumption = new HashMap();
        entity.consumableFluids = new HashMap();
        entity.totalThrust = contraption.getThrust();
        entity.localPosOfFlightRecorders = contraption.getLocalPosOfFlightRecorders();
        entity.f_19794_ = false;
        LOGGER.info("finishing setting up parameters");
        return entity;
    }

    public static void handelTrajectoryCalculation(@NotNull RocketContraptionEntity rocketContraptionEntity) {
        FlightDataHelper.RocketAssemblyData assemblyData;
        Object fluidInTank;
        RocketContraption contraption = (RocketContraption)rocketContraptionEntity.contraption;
        float deltaVNeeded = CSDimensionUtil.cost(rocketContraptionEntity.originDimension, rocketContraptionEntity.destination);
        if (((Boolean)CSConfigs.COMMON.additionalLogInfo.get()).booleanValue()) {
            CreatingSpace.LOGGER.info("-------------------trajectory calculation---------------------");
        }
        if (contraption == null) {
            CreatingSpace.LOGGER.warn("no contraption, aborting calculation");
            return;
        }
        float totalThrust = 0.0f;
        float totalFluidMass = 0.0f;
        MountedFluidStorageWrapper fluidHandler = contraption.getStorage().getFluids();
        int nbrOfTank = fluidHandler.getTanks();
        float totalTheoreticalConsumption = 0.0f;
        for (PropellantType combination : ((RocketContraption)rocketContraptionEntity.contraption).getTPTFluidConsumption().keySet()) {
            RocketContraption.ConsumptionInfo info = ((RocketContraption)rocketContraptionEntity.contraption).getTPTFluidConsumption().get(combination);
            for (float f : info.propellantConsumption().values()) {
                totalTheoreticalConsumption += f;
            }
            totalThrust += (float)info.partialThrust();
            for (TagKey tagKey : combination.getPropellantRatio().keySet()) {
                RocketContraptionEntity.addToConsumableFluids(rocketContraptionEntity, (TagKey<Fluid>)tagKey);
            }
        }
        float meanVe = totalThrust / totalTheoreticalConsumption;
        if (((Boolean)CSConfigs.COMMON.additionalLogInfo.get()).booleanValue()) {
            CreatingSpace.LOGGER.info("finished propellants loading pass, result :");
            CreatingSpace.LOGGER.info("thrust : {}N", (Object)Float.valueOf(totalThrust));
            CreatingSpace.LOGGER.info("total theoretical consumption : {} Kg/s", (Object)Float.valueOf(totalTheoreticalConsumption));
            CreatingSpace.LOGGER.info("mean exhaust velocity {} m/s", (Object)Float.valueOf(meanVe));
            CreatingSpace.LOGGER.info("consumable fluid found in rocket : {}", rocketContraptionEntity.consumableFluids);
        }
        HashMap<TagKey<Fluid>, Integer> massForEachPropellant = RocketContraptionEntity.getMassMap(rocketContraptionEntity);
        for (int i = 0; i < nbrOfTank; ++i) {
            fluidInTank = fluidHandler.getFluidInTank(i);
            FluidType fluidType = fluidInTank.getFluid().getFluidType();
            totalFluidMass += (float)(fluidInTank.getAmount() * fluidType.getDensity()) / 1000.0f;
        }
        float initialPropellantMass = 0.0f;
        fluidInTank = massForEachPropellant.values().iterator();
        while (fluidInTank.hasNext()) {
            int n = (Integer)fluidInTank.next();
            initialPropellantMass += (float)n;
        }
        float emptyMass = totalFluidMass - initialPropellantMass + contraption.getDryMass();
        if (((Boolean)CSConfigs.COMMON.additionalLogInfo.get()).booleanValue()) {
            CreatingSpace.LOGGER.info("finished mass pass, result:");
            CreatingSpace.LOGGER.info("total initial mass for propellants {}Kg", (Object)Float.valueOf(initialPropellantMass));
            CreatingSpace.LOGGER.info("inert mass {} Kg (inert fluid {}| dry mass{})", new Object[]{Float.valueOf(emptyMass), Float.valueOf(totalFluidMass - initialPropellantMass), Float.valueOf(contraption.getDryMass())});
        }
        float f = (float)((double)(emptyMass + initialPropellantMass) / Math.exp(deltaVNeeded / meanVe) - (double)emptyMass);
        float consumedPropellantMass = initialPropellantMass - f;
        if (((Boolean)CSConfigs.COMMON.additionalLogInfo.get()).booleanValue()) {
            CreatingSpace.LOGGER.info("estimated propellant consumption : {} Kg", (Object)Float.valueOf(consumedPropellantMass));
        }
        rocketContraptionEntity.initialMass = emptyMass + initialPropellantMass;
        int distance = (int)(300.0 - rocketContraptionEntity.m_20182_().m_7098_());
        float gravity = CSDimensionUtil.gravity(rocketContraptionEntity.m_9236_().m_220362_().m_135782_());
        float acceleration = totalThrust / (emptyMass + initialPropellantMass) - gravity;
        float perTickSpeed = RocketContraptionEntity.getPerTickSpeed(acceleration);
        float totalTickTime = (float)distance / perTickSpeed;
        if (((Boolean)CSConfigs.COMMON.additionalLogInfo.get()).booleanValue()) {
            CreatingSpace.LOGGER.info("distance : {}", (Object)distance);
            CreatingSpace.LOGGER.info("speed : {}blocks/ticks", (Object)Float.valueOf(perTickSpeed));
            CreatingSpace.LOGGER.info("travel time : {} ticks", (Object)Float.valueOf(totalTickTime));
        }
        HashMap<TagKey<Fluid>, Integer> consumedMassForEachPropellant = new HashMap<TagKey<Fluid>, Integer>();
        float realPartialConsumption = consumedPropellantMass / totalTheoreticalConsumption;
        for (PropellantType propellantType : ((RocketContraption)rocketContraptionEntity.contraption).getTPTFluidConsumption().keySet()) {
            RocketContraption.ConsumptionInfo info = ((RocketContraption)rocketContraptionEntity.contraption).getTPTFluidConsumption().get(propellantType);
            HashMap<TagKey<Fluid>, Float> correctedConsumptions = new HashMap<TagKey<Fluid>, Float>(info.propellantConsumption());
            RocketContraption.multiplyMap(correctedConsumptions, realPartialConsumption / totalTickTime);
            rocketContraptionEntity.realPerTagFluidConsumption.put(propellantType, new RocketContraption.ConsumptionInfo(correctedConsumptions, info.partialThrust()));
            correctedConsumptions.keySet().forEach(fluid -> consumedMassForEachPropellant.put((TagKey<Fluid>)fluid, (int)((float)consumedMassForEachPropellant.getOrDefault(fluid, 0).intValue() + ((Float)correctedConsumptions.get(fluid)).floatValue())));
        }
        if (((Boolean)CSConfigs.COMMON.additionalLogInfo.get()).booleanValue()) {
            CreatingSpace.LOGGER.info("finished correction of consumption path :");
            CreatingSpace.LOGGER.info("consumed mass for each fluid tag :{}", consumedMassForEachPropellant);
            CreatingSpace.LOGGER.info("consumed mass per propellant : {}", rocketContraptionEntity.realPerTagFluidConsumption);
        }
        rocketContraptionEntity.assemblyData = assemblyData = FlightDataHelper.RocketAssemblyData.create(massForEachPropellant, consumedMassForEachPropellant, f, totalThrust, (emptyMass + initialPropellantMass) * gravity);
        if (((Boolean)CSConfigs.COMMON.additionalLogInfo.get()).booleanValue()) {
            CreatingSpace.LOGGER.info("determining if the rocket can go :");
            CreatingSpace.LOGGER.info(String.valueOf(assemblyData));
        }
        if (distance <= 0) {
            rocketContraptionEntity.m_20088_().m_135381_(STATUS_DATA_ACCESSOR, (Object)RocketStatus.BLOCKED);
            return;
        }
        if (assemblyData.hasFailed()) {
            rocketContraptionEntity.m_20088_().m_135381_(STATUS_DATA_ACCESSOR, (Object)RocketStatus.BLOCKED);
            return;
        }
        rocketContraptionEntity.m_20088_().m_135381_(STATUS_DATA_ACCESSOR, (Object)RocketStatus.TRAVELING);
    }

    public float deltaV() {
        Object fluidInTank;
        float totalThrust = 0.0f;
        float inertFluidsMass = 0.0f;
        MountedFluidStorageWrapper fluidHandler = this.contraption.getStorage().getFluids();
        int nbrOfTank = fluidHandler.getTanks();
        float totalTheoreticalConsumption = 0.0f;
        for (PropellantType combination : ((RocketContraption)this.contraption).getTPTFluidConsumption().keySet()) {
            RocketContraption.ConsumptionInfo info = ((RocketContraption)this.contraption).getTPTFluidConsumption().get(combination);
            for (float f : info.propellantConsumption().values()) {
                totalTheoreticalConsumption += f;
            }
            totalThrust += (float)info.partialThrust();
            for (TagKey tagKey : combination.getPropellantRatio().keySet()) {
                RocketContraptionEntity.addToConsumableFluids(this, (TagKey<Fluid>)tagKey);
            }
        }
        float meanVe = totalThrust > 0.0f ? totalThrust / totalTheoreticalConsumption : 0.0f;
        HashMap<TagKey<Fluid>, Integer> massForEachPropellant = RocketContraptionEntity.getMassMap(this);
        for (int i = 0; i < nbrOfTank; ++i) {
            fluidInTank = fluidHandler.getFluidInTank(i);
            FluidType fluidType = fluidInTank.getFluid().getFluidType();
            inertFluidsMass += (float)(fluidInTank.getAmount() * fluidType.getDensity()) / 1000.0f;
        }
        float initialPropellantMass = 0.0f;
        fluidInTank = massForEachPropellant.values().iterator();
        while (fluidInTank.hasNext()) {
            int n = (Integer)fluidInTank.next();
            initialPropellantMass += (float)n;
        }
        float emptyMass = inertFluidsMass + ((RocketContraption)this.contraption).getDryMass();
        return (float)((double)meanVe * Math.log((emptyMass + initialPropellantMass) / emptyMass));
    }

    private static void addToConsumableFluids(RocketContraptionEntity rocketContraptionEntity, TagKey<Fluid> consumedFluid) {
        rocketContraptionEntity.consumableFluids.put(consumedFluid, new ArrayList());
        MountedFluidStorageWrapper fluidHandler = rocketContraptionEntity.contraption.getStorage().getFluids();
        if (fluidHandler != null) {
            int nbrOfTank = fluidHandler.getTanks();
            for (int i = 0; i < nbrOfTank; ++i) {
                FluidStack fluidInTank = fluidHandler.getFluidInTank(i);
                if (!fluidInTank.getFluid().m_205067_(consumedFluid) || rocketContraptionEntity.consumableFluids.get(consumedFluid).contains(fluidInTank.getFluid())) continue;
                rocketContraptionEntity.consumableFluids.get(consumedFluid).add(fluidInTank.getFluid());
            }
        }
    }

    private static HashMap<TagKey<Fluid>, Integer> getMassMap(RocketContraptionEntity rocketContraptionEntity) {
        HashMap<TagKey<Fluid>, Integer> massForEachPropellant = new HashMap<TagKey<Fluid>, Integer>();
        ArrayList<TagKey<Fluid>> allPropellantTags = new ArrayList<TagKey<Fluid>>(rocketContraptionEntity.consumableFluids.keySet());
        MountedFluidStorageWrapper fluidHandler = rocketContraptionEntity.contraption.getStorage().getFluids();
        int nbrOfTank = fluidHandler.getTanks();
        for (TagKey<Fluid> consumedFluid : allPropellantTags) {
            for (int i = 0; i < nbrOfTank; ++i) {
                FluidStack fluidInTank = fluidHandler.getFluidInTank(i);
                FluidType fluidType = fluidInTank.getFluid().getFluidType();
                if (!fluidInTank.getFluid().m_205067_(consumedFluid)) continue;
                Integer prevFluidMass = massForEachPropellant.get(consumedFluid);
                if (prevFluidMass == null) {
                    prevFluidMass = 0;
                }
                float ro = (float)fluidType.getDensity() / 1000.0f;
                massForEachPropellant.put(consumedFluid, (int)((float)prevFluidMass.intValue() + (float)fluidHandler.getFluidInTank(i).getAmount() * ro));
            }
        }
        return massForEachPropellant;
    }

    private static float getPerTickSpeed(float acceleration) {
        float perTickSpeed = (float)((double)Math.signum(acceleration) * Math.log(1.4 + (double)(Math.abs(acceleration) / 20.0f)));
        perTickSpeed = Mth.m_14036_((float)perTickSpeed, (float)-1.0f, (float)1.0f);
        return perTickSpeed;
    }

    public void disassemble() {
        for (BlockPos localPos : this.localPosOfFlightRecorders) {
            StructureTemplate.StructureBlockInfo oldStructureInfo = (StructureTemplate.StructureBlockInfo)this.contraption.getBlocks().get(localPos);
            CompoundTag nbt = oldStructureInfo.f_74677_();
            assert (nbt != null);
            nbt.m_128365_("lastAssemblyData", (Tag)FlightDataHelper.RocketAssemblyData.toNBT(this.assemblyData));
            StructureTemplate.StructureBlockInfo newStructureInfo = new StructureTemplate.StructureBlockInfo(oldStructureInfo.f_74675_(), oldStructureInfo.f_74676_(), nbt);
            this.contraption.getBlocks().put(localPos, newStructureInfo);
        }
        super.disassemble();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STATUS_DATA_ACCESSOR, (Object)RocketStatus.IDLE);
    }

    public void m_8119_() {
        ROCKET_SOUND_LENGTH = 35;
        boolean wasRunning = this.isInPropulsionPhase();
        if (this.isInPropulsionPhase()) {
            if (this.soundEffectTickCount <= 0) {
                if (!this.m_9236_().f_46443_) {
                    this.m_5496_((SoundEvent)SoundInit.ROCKET_LAUNCH.get(), 1.0f, 1.0f);
                }
                this.soundEffectTickCount = ROCKET_SOUND_LENGTH;
            } else {
                --this.soundEffectTickCount;
            }
            if (!this.m_9236_().m_5776_() && this.shouldHandleCalculation) {
                RocketContraptionEntity.handelTrajectoryCalculation(this);
                this.shouldHandleCalculation = false;
            }
        }
        this.schedule.tick(this.m_9236_());
        super.m_8119_();
        if (wasRunning && !this.isInPropulsionPhase()) {
            this.schedule.destinationReached();
        }
    }

    protected void tickContraption() {
        if (!(this.contraption instanceof RocketContraption)) {
            return;
        }
        if (this.m_9236_().f_46443_) {
            this.clientOffsetDiff *= 0.75;
            this.updateClientMotion();
        }
        this.tickActors();
        if (!this.m_9236_().f_46443_) {
            if (this.isInPropulsionPhase()) {
                this.tickConsumptionAndSpeed();
                Vec3 movementVec = this.m_20184_();
                this.tickDimensionChangeLogic();
                if (ContraptionCollider.collideBlocks((AbstractContraptionEntity)this) && !((double)this.m_9236_().m_151558_() < this.m_20191_().f_82292_ + movementVec.f_82480_)) {
                    this.m_20088_().m_135381_(STATUS_DATA_ACCESSOR, (Object)(this.isReentry() ? RocketStatus.IDLE : RocketStatus.BLOCKED));
                    this.setContraptionMotion(Vec3.f_82478_);
                } else if (this.f_19797_ > 2) {
                    movementVec = VecHelper.clampComponentWise((Vec3)movementVec, (float)1.0f);
                    this.move(movementVec.f_82479_, movementVec.f_82480_, movementVec.f_82481_);
                }
            }
            this.sendPacket();
        }
        if (!this.isInPropulsionPhase()) {
            this.setContraptionMotion(Vec3.f_82478_);
            this.speed = 0.0;
        }
    }

    public boolean m_142535_(float p_146828_, float p_146829_, @NotNull DamageSource damageSource) {
        return false;
    }

    public Vec3 getContactPointMotion(Vec3 globalContactPoint) {
        if (this.contraption instanceof TranslatingContraption) {
            return this.m_20184_();
        }
        return super.getContactPointMotion(globalContactPoint);
    }

    private void tickDimensionChangeLogic() {
        if (this.m_20182_().m_82507_(Direction.Axis.Y) > 300.0 && !this.isReentry()) {
            ServerLevel destServerLevel = Objects.requireNonNull(this.m_9236_().m_7654_()).m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)this.destination));
            if (destServerLevel != null) {
                this.changeDimension(destServerLevel, new CustomTeleporter(destServerLevel));
            } else {
                LOGGER.error("rocket failed to get server for destination : {}", (Object)this.destination);
                this.f_19804_.m_135381_(STATUS_DATA_ACCESSOR, (Object)RocketStatus.ON_FINAL);
            }
        }
    }

    protected void tickConsumptionAndSpeed() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        float gravity = CSDimensionUtil.gravity(this.m_9236_().m_220362_().m_135782_());
        if (!this.isReentry() && !this.m_9236_().m_5776_()) {
            this.consumePropellant(this);
        }
        float acceleration = RocketContraptionEntity.getAcceleration(this.initialMass, (int)this.totalThrust, gravity, this.isReentry());
        float speed = RocketContraptionEntity.getPerTickSpeed(acceleration);
        Vec3 movementVec = new Vec3(0.0, (double)speed, 0.0);
        this.speed = speed;
        this.setContraptionMotion(movementVec);
    }

    private void consumePropellant(RocketContraptionEntity rocketContraptionEntity) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        RocketContraption rocketContraption = (RocketContraption)rocketContraptionEntity.contraption;
        MountedFluidStorageWrapper fluidHandler = rocketContraption.getStorage().getFluids();
        for (PropellantType combination : this.realPerTagFluidConsumption.keySet()) {
            RocketContraption.ConsumptionInfo info = this.realPerTagFluidConsumption.get(combination);
            for (TagKey<Fluid> fluidTag : info.propellantConsumption().keySet()) {
                Float prevPartialDrainValue = this.partialDrainAmountPerFluid.get(fluidTag);
                ArrayList<Fluid> fluids = this.consumableFluids.get(fluidTag);
                if (fluids == null || fluids.isEmpty()) continue;
                Fluid oxFluid = fluids.get(0);
                FluidType oxFluidType = oxFluid.getFluidType();
                float oxRo = (float)oxFluidType.getDensity() / 1000.0f;
                float oxAmount = info.propellantConsumption().get(fluidTag).floatValue() / oxRo;
                if (prevPartialDrainValue == null) {
                    prevPartialDrainValue = Float.valueOf(0.0f);
                }
                float partialOxConsumedAmount = prevPartialDrainValue.floatValue();
                if ((partialOxConsumedAmount = partialOxConsumedAmount + oxAmount - (float)((int)oxAmount)) >= 1.0f) {
                    oxAmount += 1.0f;
                    partialOxConsumedAmount -= 1.0f;
                }
                this.partialDrainAmountPerFluid.put(fluidTag, Float.valueOf(partialOxConsumedAmount));
                int consumedOx = fluidHandler.drain(new FluidStack(oxFluid, (int)oxAmount), IFluidHandler.FluidAction.EXECUTE).getAmount();
                if (consumedOx != 0) continue;
                RocketContraptionEntity.addToConsumableFluids(this, fluidTag);
            }
        }
    }

    @Nullable
    public Entity changeDimension(ServerLevel destLevel, @NotNull ITeleporter teleporter) {
        if (!ForgeHooks.onTravelToDimension((Entity)this, (ResourceKey)destLevel.m_46472_())) {
            return null;
        }
        if (this.m_9236_() instanceof ServerLevel && !this.m_213877_()) {
            this.m_9236_().m_46473_().m_6180_("changeDimension");
            List passengers = this.m_20197_();
            List collidingEntities = this.m_9236_().m_45933_((Entity)this, this.m_20191_());
            collidingEntities.removeAll(passengers);
            this.m_19877_();
            BlockPos previousRocketPos = this.m_20097_();
            this.m_9236_().m_46473_().m_6180_("reposition");
            PortalInfo portalinfo = teleporter.getPortalInfo((Entity)this, destLevel, x$0 -> this.m_7937_((ServerLevel)x$0));
            if (portalinfo == null) {
                return null;
            }
            Entity transportedEntity = teleporter.placeEntity((Entity)this, (ServerLevel)this.m_9236_(), destLevel, this.m_146908_(), spawnPortal -> {
                this.m_9236_().m_46473_().m_6182_("reloading");
                RocketContraptionEntity entity = (RocketContraptionEntity)this.m_6095_().m_20615_((Level)destLevel);
                if (entity != null) {
                    entity.m_20361_((Entity)this);
                    entity.m_7678_(portalinfo.f_77676_.f_82479_, portalinfo.f_77676_.f_82480_, portalinfo.f_77676_.f_82481_, portalinfo.f_77678_, entity.m_146909_());
                    entity.m_20256_(portalinfo.f_77677_);
                    for (int i = 0; i < passengers.size(); ++i) {
                        Entity passenger = (Entity)passengers.get(i);
                        passenger.m_7678_(portalinfo.f_77676_.f_82479_, portalinfo.f_77676_.f_82480_, portalinfo.f_77676_.f_82481_, passenger.m_146908_(), passenger.m_146909_());
                        if (passenger instanceof ServerPlayer) {
                            ServerPlayer player = (ServerPlayer)passenger;
                            player.changeDimension(destLevel, (ITeleporter)new CustomTeleporter(destLevel));
                            entity.addSittingPassenger((Entity)player, i);
                            continue;
                        }
                        if (passenger instanceof Player) continue;
                        passenger.changeDimension(destLevel, (ITeleporter)new CustomTeleporter(destLevel));
                        entity.addSittingPassenger(passenger, i);
                    }
                    for (Entity movedEntity : collidingEntities) {
                        BlockPos posDif = movedEntity.m_20097_().m_121996_((Vec3i)previousRocketPos);
                        movedEntity.m_7678_(portalinfo.f_77676_.f_82479_ + (double)posDif.m_123341_(), portalinfo.f_77676_.f_82480_ + (double)posDif.m_123342_(), portalinfo.f_77676_.f_82481_ + (double)posDif.m_123343_(), movedEntity.m_146908_(), movedEntity.m_146909_());
                        if (movedEntity instanceof ServerPlayer) {
                            ServerPlayer player = (ServerPlayer)movedEntity;
                            player.changeDimension(destLevel, (ITeleporter)new CustomTeleporter(destLevel));
                            continue;
                        }
                        if (movedEntity instanceof Player) continue;
                        movedEntity.changeDimension(destLevel, (ITeleporter)new CustomTeleporter(destLevel));
                    }
                    destLevel.m_143334_((Entity)entity);
                    if (CSDimensionUtil.isOrbit(destLevel.m_46472_().m_135782_())) {
                        entity.stopRocket();
                        entity.schedule.destinationReached();
                    } else {
                        entity.f_19804_.m_135381_(STATUS_DATA_ACCESSOR, (Object)RocketStatus.ON_FINAL);
                    }
                }
                return entity;
            });
            this.m_6089_();
            this.m_9236_().m_46473_().m_7238_();
            ((ServerLevel)this.m_9236_()).m_8886_();
            destLevel.m_8886_();
            this.m_9236_().m_46473_().m_7238_();
            return transportedEntity;
        }
        return null;
    }

    public Vec3 applyRotation(Vec3 localPos, float partialTicks) {
        return localPos;
    }

    public Vec3 reverseRotation(Vec3 localPos, float partialTicks) {
        return localPos;
    }

    protected StructureTransform makeStructureTransform() {
        return new StructureTransform(BlockPos.m_274446_((Position)this.getAnchorVec().m_82520_(0.5, 0.5, 0.5)), 0.0f, 0.0f, 0.0f);
    }

    protected float getStalledAngle() {
        return 0.0f;
    }

    protected void handleStallInformation(double x, double y, double z, float angle) {
        this.m_20343_(x, y, z);
        this.clientOffsetDiff = 0.0;
    }

    public AbstractContraptionEntity.ContraptionRotationState getRotationState() {
        return AbstractContraptionEntity.ContraptionRotationState.NONE;
    }

    public static float getAcceleration(float initialMass, int thrust, float gravity, boolean reentry) {
        if (!reentry) {
            float acceleration = (float)thrust / initialMass;
            return acceleration - gravity;
        }
        return -gravity;
    }

    public AABB m_6921_() {
        return this.isInPropulsionPhase() ? new AABB(-2.147483648E9, -2.147483648E9, -2.147483648E9, 2.147483647E9, 2.147483647E9, 2.147483647E9) : super.m_6921_();
    }

    public double getAxisCoord() {
        Vec3 anchorVec = this.getAnchorVec();
        return anchorVec.f_82480_;
    }

    public void updateClientMotion() {
        Vec3 motion = new Vec3(0.0, (this.speed + this.clientOffsetDiff / 2.0) * (double)ServerSpeedProvider.get(), 0.0);
        motion = VecHelper.clampComponentWise((Vec3)motion, (float)1.0f);
        this.move(motion.f_82479_, motion.f_82480_, motion.f_82481_);
    }

    public void sendPacket() {
        PacketInit.getChannel().send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new RocketContraptionUpdatePacket(this.m_19879_(), this.getAxisCoord(), this.speed));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handlePacket(RocketContraptionUpdatePacket packet) {
        assert (Minecraft.m_91087_().f_91073_ != null);
        Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(packet.entityID);
        if (!(entity instanceof RocketContraptionEntity)) {
            return;
        }
        RocketContraptionEntity ce = (RocketContraptionEntity)entity;
        ce.speed = packet.speed;
        ce.clientOffsetDiff = packet.coord - ce.getAxisCoord();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void applyLocalTransforms(PoseStack matrixStack, float partialTicks) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6453_(double x, double y, double z, float yw, float pt, int inc, boolean t) {
    }

    protected void readAdditional(CompoundTag compound, boolean spawnData) {
        super.readAdditional(compound, spawnData);
        this.initialPosMap = RocketControlsBlockEntity.getPosMap((CompoundTag)compound.m_128423_("initialPosMap"));
        this.localPosOfFlightRecorders = CSNBTUtil.LongsToBlockPos(compound.m_128467_("localPosOfFlightRecorders"));
        this.totalThrust = compound.m_128457_("thrust");
        this.initialMass = compound.m_128457_("initialMass");
        this.realPerTagFluidConsumption = CODEC_MAP_INFO.parse((DynamicOps)NbtOps.f_128958_, (Object)compound.m_128469_("realPerTagFluidConsumption")).result().orElse(new HashMap());
        this.partialDrainAmountPerFluid = CODEC_MAP_CONSUMPTION.parse((DynamicOps)NbtOps.f_128958_, (Object)compound.m_128469_("partialDrainAmountPerFluid")).result().orElse(new HashMap());
        this.assemblyData = FlightDataHelper.RocketAssemblyData.fromNBT(compound.m_128469_("assemblyData"));
        this.f_19804_.m_135381_(STATUS_DATA_ACCESSOR, (Object)RocketStatus.valueOf(compound.m_128461_("status")));
        this.destination = (ResourceLocation)ResourceLocation.f_135803_.parse((DynamicOps)NbtOps.f_128958_, (Object)compound.m_128423_("destination")).get().orThrow();
        this.originDimension = (ResourceLocation)ResourceLocation.f_135803_.parse((DynamicOps)NbtOps.f_128958_, (Object)compound.m_128423_("origin")).get().orThrow();
        this.schedule.read((CompoundTag)compound.m_128423_("Runtime"));
    }

    protected void writeAdditional(CompoundTag compound, boolean spawnPacket) {
        compound.m_128365_("initialPosMap", (Tag)RocketControlsBlockEntity.putPosMap(this.initialPosMap));
        compound.m_128428_("localPosOfFlightRecorders", CSNBTUtil.BlockPosToLong(this.localPosOfFlightRecorders));
        compound.m_128350_("initialMass", this.initialMass);
        compound.m_128365_("realPerTagFluidConsumption", (Tag)CODEC_MAP_INFO.encodeStart((DynamicOps)NbtOps.f_128958_, this.realPerTagFluidConsumption).get().left().orElse(new CompoundTag()));
        compound.m_128365_("partialDrainAmountPerFluid", (Tag)CODEC_MAP_CONSUMPTION.encodeStart((DynamicOps)NbtOps.f_128958_, this.partialDrainAmountPerFluid).get().left().orElse(new CompoundTag()));
        compound.m_128365_("assemblyData", (Tag)FlightDataHelper.RocketAssemblyData.toNBT(this.assemblyData));
        compound.m_128350_("thrust", this.totalThrust);
        compound.m_128359_("status", ((RocketStatus)((Object)this.f_19804_.m_135370_(STATUS_DATA_ACCESSOR))).toString());
        compound.m_128365_("origin", (Tag)ResourceLocation.f_135803_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.originDimension).get().orThrow());
        compound.m_128365_("destination", (Tag)ResourceLocation.f_135803_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.destination).get().orThrow());
        compound.m_128365_("Runtime", (Tag)this.schedule.write());
        super.writeAdditional(compound, spawnPacket);
    }

    public boolean m_20067_() {
        return false;
    }

    @NotNull
    public SoundSource m_5720_() {
        return SoundSource.MASTER;
    }

    public boolean isReentry() {
        return this.f_19804_.m_135370_(STATUS_DATA_ACCESSOR) == RocketStatus.ON_FINAL;
    }

    public boolean isInPropulsionPhase() {
        return ((RocketStatus)((Object)this.f_19804_.m_135370_(RocketContraptionEntity.STATUS_DATA_ACCESSOR))).propelled_phase;
    }

    public HashMap<ResourceLocation, BlockPos> getInitialPosMap() {
        return this.initialPosMap;
    }

    public void setInitialPosMap(HashMap<ResourceLocation, BlockPos> map) {
        this.initialPosMap = map;
        if (this.m_9236_().f_46443_) {
            PacketInit.getChannel().sendToServer((Object)new RocketEntryPosMapClientPacket(this.m_19879_(), this.initialPosMap));
        }
    }

    public void successfulNavigation() {
    }

    public int countPlayerPassengers() {
        AtomicInteger count = new AtomicInteger();
        this.m_146897_().forEach(p -> {
            if (p instanceof Player) {
                count.incrementAndGet();
            }
        });
        return count.intValue();
    }

    public int startNavigation(RocketPath nextPath) {
        if (!this.m_9236_().m_5776_()) {
            this.originDimension = nextPath.origin;
            this.destination = nextPath.destination;
            this.m_20088_().m_135381_(STATUS_DATA_ACCESSOR, (Object)RocketStatus.TRAVELING);
            this.shouldHandleCalculation = false;
            RocketContraptionEntity.handelTrajectoryCalculation(this);
            if (((RocketStatus)((Object)this.m_20088_().m_135370_(STATUS_DATA_ACCESSOR))).equals((Object)RocketStatus.BLOCKED)) {
                return -1;
            }
        }
        return 0;
    }

    private void stopRocket() {
        this.m_20088_().m_135381_(STATUS_DATA_ACCESSOR, (Object)RocketStatus.IDLE);
        this.setContraptionMotion(Vec3.f_82478_);
    }

    public static enum RocketStatus {
        IDLE(false),
        TRAVELING(true),
        BLOCKED(false),
        ON_FINAL(true);

        final boolean propelled_phase;

        private RocketStatus(boolean propelled_phase) {
            this.propelled_phase = propelled_phase;
        }
    }
}

