/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.content.rocket;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.rae.creatingspace.api.gui.elements.LabeledBoxWidget;
import com.rae.creatingspace.api.squedule.RocketSchedule;
import com.rae.creatingspace.api.squedule.ScheduleEntry;
import com.rae.creatingspace.api.squedule.condition.ScheduleWaitCondition;
import com.rae.creatingspace.api.squedule.condition.ScheduledDelay;
import com.rae.creatingspace.api.squedule.instruction.DestinationInstruction;
import com.rae.creatingspace.api.squedule.instruction.ScheduleInstruction;
import com.rae.creatingspace.content.planets.CSDimensionUtil;
import com.rae.creatingspace.content.rocket.RocketContraptionEntity;
import com.rae.creatingspace.content.rocket.RocketMenu;
import com.rae.creatingspace.content.rocket.network.RocketContraptionDisassemblePacket;
import com.rae.creatingspace.content.rocket.network.RocketScheduleEditPacket;
import com.rae.creatingspace.init.PacketInit;
import com.rae.creatingspace.init.graphics.GuiTexturesInit;
import com.rae.creatingspace.legacy.utilities.CSUtil;
import com.simibubi.create.content.trains.schedule.IScheduleInput;
import com.simibubi.create.content.trains.schedule.ScheduleDataEntry;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.ModularGuiLine;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.Indicator;
import com.simibubi.create.foundation.gui.widget.Label;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.gui.widget.SelectionScrollInput;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.gui.TextureSheetSegment;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.gui.element.ScreenElement;
import net.createmod.catnip.lang.FontHelper;
import net.createmod.catnip.theme.Color;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public class ScheduleMakingScreen
extends AbstractSimiContainerScreen<RocketMenu> {
    private static final int CARD_HEADER = 22;
    private static final int CARD_WIDTH = 195;
    private final LerpedFloat scroll = LerpedFloat.linear().startWithValue(0.0);
    private final List<LerpedFloat> horizontalScrolls = new ArrayList<LerpedFloat>();
    private final RocketSchedule schedule;
    private IconButton cyclicButton;
    private Indicator cyclicIndicator;
    private IconButton resetProgress;
    private IconButton skipProgress;
    private ScheduleInstruction editingDestination;
    private ScheduleWaitCondition editingCondition;
    private SelectionScrollInput scrollInput;
    private Label scrollInputLabel;
    private IconButton editorConfirm;
    private IconButton editorDelete;
    private final ModularGuiLine editorSubWidgets;
    private Consumer<Boolean> onEditorClose;
    private boolean destinationChanged;
    private Button disassembleButton;
    HashMap<ResourceLocation, BlockPos> initialPosMap;
    private final RocketContraptionEntity rocketContraption;
    private final ResourceLocation currentDimension;
    private ResourceLocation destination;
    private LabeledBoxWidget destinationCost;
    private EditBox Xinput;
    private EditBox Zinput;
    IconButton validateSetting;
    private final Component clickToEdit = CreateLang.translateDirect((String)"gui.schedule.lmb_edit", (Object[])new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC});
    private final Component rClickToDelete = CreateLang.translateDirect((String)"gui.schedule.rmb_remove", (Object[])new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC});

    public ScheduleMakingScreen(RocketMenu container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, (Component)Component.m_237115_((String)"gui.destination_screen.title"));
        this.rocketContraption = (RocketContraptionEntity)((Object)container.contentHolder);
        this.initialPosMap = new HashMap<ResourceLocation, BlockPos>(((RocketContraptionEntity)((Object)container.contentHolder)).getInitialPosMap());
        this.currentDimension = ((RocketContraptionEntity)((Object)container.contentHolder)).m_9236_().m_46472_().m_135782_();
        this.destinationChanged = false;
        this.schedule = ((RocketContraptionEntity)((Object)container.contentHolder)).schedule.getSchedule() == null ? new RocketSchedule() : ((RocketContraptionEntity)((Object)container.contentHolder)).schedule.getSchedule();
        this.editorSubWidgets = new ModularGuiLine();
    }

    protected void m_7856_() {
        this.setWindowSize(this.f_96543_, this.f_96544_);
        this.m_169413_();
        super.m_7856_();
        int x = this.f_97735_;
        int y = this.f_97736_;
        this.disassembleButton = new ExtendedButton(this.f_96543_ - 110, y + 120, 64, 20, (Component)Component.m_237115_((String)"creatingspace.gui.rocket_controls.disassemble"), $ -> {
            PacketInit.getChannel().sendToServer((Object)new RocketContraptionDisassemblePacket(this.rocketContraption.m_19879_()));
            this.m_7379_();
        });
        this.m_142416_((GuiEventListener)this.disassembleButton);
        this.destinationCost = new LabeledBoxWidget(this.f_96543_ - 97, y + 20, (Component)Component.m_237113_((String)"  500 "));
        this.destinationCost.setToolTip((Component)Component.m_237115_((String)"creatingspace.gui.rocket_controls.destination_cost"));
        this.validateSetting = new IconButton(this.f_96543_ - 45, y + 70, (ScreenElement)AllIcons.I_CONFIG_SAVE);
        this.validateSetting.setToolTip((Component)Component.m_237115_((String)"creatingspace.gui.rocket_controls.send_setting"));
        this.validateSetting.withCallback(this::updatePosMap);
        this.Xinput = new EditBox(this.f_96547_, this.f_96543_ - 100, y + 63, 50, 14, (Component)Component.m_237113_((String)""));
        this.Zinput = new EditBox(this.f_96547_, this.f_96543_ - 100, y + 83, 50, 14, (Component)Component.m_237113_((String)""));
        this.m_142416_((GuiEventListener)this.Xinput);
        this.m_142416_((GuiEventListener)this.Zinput);
        this.m_142416_((GuiEventListener)this.validateSetting);
        this.m_142416_((GuiEventListener)this.destinationCost);
        this.cyclicIndicator = new Indicator(x + 21, y + 196, (Component)Component.m_237119_());
        this.cyclicIndicator.state = this.schedule.cyclic ? Indicator.State.ON : Indicator.State.OFF;
        this.m_142416_((GuiEventListener)this.cyclicIndicator);
        this.cyclicButton = new IconButton(x + 21, y + 202, (ScreenElement)AllIcons.I_REFRESH);
        this.cyclicButton.withCallback(() -> {
            this.schedule.cyclic = !this.schedule.cyclic;
            this.cyclicIndicator.state = this.schedule.cyclic ? Indicator.State.ON : Indicator.State.OFF;
        });
        List tip = this.cyclicButton.getToolTip();
        tip.add(CreateLang.translateDirect((String)"schedule.loop", (Object[])new Object[0]));
        tip.add(CreateLang.translateDirect((String)"schedule.loop1", (Object[])new Object[0]).m_130940_(ChatFormatting.GRAY));
        tip.add(CreateLang.translateDirect((String)"schedule.loop2", (Object[])new Object[0]).m_130940_(ChatFormatting.GRAY));
        this.m_142416_((GuiEventListener)this.cyclicButton);
        this.resetProgress = new IconButton(x + 45, y + 202, (ScreenElement)AllIcons.I_PRIORITY_VERY_HIGH);
        this.resetProgress.withCallback(() -> {
            this.schedule.savedProgress = 0;
            this.resetProgress.f_93623_ = false;
        });
        this.resetProgress.f_93623_ = this.schedule.savedProgress > 0 && !this.schedule.entries.isEmpty();
        this.resetProgress.setToolTip((Component)CreateLang.translateDirect((String)"schedule.reset", (Object[])new Object[0]));
        this.m_142416_((GuiEventListener)this.resetProgress);
        this.skipProgress = new IconButton(x + 63, y + 202, (ScreenElement)AllIcons.I_PRIORITY_LOW);
        this.skipProgress.withCallback(() -> {
            ++this.schedule.savedProgress;
            this.schedule.savedProgress %= this.schedule.entries.size();
            this.resetProgress.f_93623_ = this.schedule.savedProgress > 0;
        });
        this.skipProgress.f_93623_ = this.schedule.entries.size() > 1;
        this.skipProgress.setToolTip((Component)CreateLang.translateDirect((String)"schedule.skip", (Object[])new Object[0]));
        this.m_142416_((GuiEventListener)this.skipProgress);
        this.stopEditing();
        this.horizontalScrolls.clear();
        for (int i = 0; i < this.schedule.entries.size(); ++i) {
            this.horizontalScrolls.add(LerpedFloat.linear().startWithValue(0.0));
        }
        IconButton launchButton = new IconButton(x + 214, y + 202, (ScreenElement)AllIcons.I_CONFIRM);
        launchButton.withCallback(() -> ((ScheduleMakingScreen)this).m_7379_());
        this.m_142416_((GuiEventListener)launchButton);
    }

    private void updatePosMap() {
        if (this.destination != null) {
            BlockPos pos = this.initialPosMap.get(this.destination);
            if (pos == null) {
                pos = this.rocketContraption.m_20097_();
            }
            String X = this.Xinput.m_94155_().replace(" ", "");
            String Z = this.Zinput.m_94155_().replace(" ", "");
            if (CSUtil.isInteger(X)) {
                pos = new BlockPos(Integer.parseInt(X), pos.m_123342_(), pos.m_123343_());
            } else {
                this.Xinput.m_94144_(String.valueOf(pos.m_123341_()));
            }
            if (CSUtil.isInteger(Z)) {
                pos = new BlockPos(pos.m_123341_(), pos.m_123342_(), Integer.parseInt(Z));
            } else {
                this.Zinput.m_94144_(String.valueOf(pos.m_123343_()));
            }
            this.initialPosMap.put(this.destination, pos);
            this.rocketContraption.setInitialPosMap(this.initialPosMap);
        }
    }

    public void m_88315_(GuiGraphics matrixStack, int mouseX, int mouseY, float partialTicks) {
        partialTicks = this.f_96541_.m_91296_();
        this.m_280273_(matrixStack);
        this.m_7286_(matrixStack, partialTicks, mouseX, mouseY);
        for (Renderable widget : this.f_169369_) {
            widget.m_88315_(matrixStack, mouseX, mouseY, partialTicks);
        }
        this.renderForeground(matrixStack, mouseX, mouseY, partialTicks);
    }

    protected void renderForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.f_97735_;
        int y = this.f_97736_;
        if (this.editingDestination != null) {
            if (this.destinationChanged) {
                this.updateXZInput();
                this.destinationChanged = false;
            }
            this.Xinput.f_93624_ = true;
            this.Xinput.f_93623_ = true;
            this.Zinput.f_93624_ = true;
            this.Zinput.f_93623_ = true;
            this.validateSetting.f_93623_ = true;
            this.validateSetting.f_93624_ = true;
            this.destinationCost.f_93624_ = true;
            this.destinationCost.setTextAndTrim((Component)Component.m_237113_((String)String.valueOf(CSDimensionUtil.cost(this.currentDimension, this.destination != null ? this.destination : ResourceLocation.m_135820_((String)this.editingDestination.getData().m_128461_("Text"))))), true, 112);
        } else {
            this.Xinput.f_93624_ = false;
            this.Xinput.f_93623_ = false;
            this.Zinput.f_93624_ = false;
            this.Zinput.f_93623_ = false;
            this.validateSetting.f_93623_ = false;
            this.validateSetting.f_93624_ = false;
            this.destinationCost.f_93624_ = false;
        }
        super.renderForeground(graphics, mouseX, mouseY, partialTicks);
        this.action(graphics, mouseX, mouseY, -1);
    }

    private void updateXZInput() {
        BlockPos pos = this.initialPosMap.get(this.destination);
        if (pos == null) {
            pos = this.rocketContraption.m_20097_();
        }
        this.Xinput.m_94144_(String.valueOf(pos.m_123341_()));
        this.Zinput.m_94144_(String.valueOf(pos.m_123343_()));
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        GuiTexturesInit.SCHEDULE_BACKGROUND.render(graphics, this.f_97735_, this.f_97736_);
        GuiTexturesInit.ROCKET_INFO.render(graphics, this.f_96543_ - 130, 10);
        this.renderSchedule(graphics, partialTicks);
        if (this.editingCondition == null && this.editingDestination == null) {
            return;
        }
        AllGuiTextures.SCHEDULE_EDITOR.render(graphics, this.f_97735_ - 2, this.f_97736_ + 40);
        PoseStack pPoseStack = graphics.m_280168_();
        pPoseStack.m_85836_();
        pPoseStack.m_252880_(0.0f, (float)(this.f_97736_ + 87), 0.0f);
        this.editorSubWidgets.renderWidgetBG(this.f_97735_ + 77, graphics);
        pPoseStack.m_85849_();
    }

    public void m_181908_() {
        this.scroll.tickChaser();
        for (LerpedFloat lerpedFloat : this.horizontalScrolls) {
            lerpedFloat.tickChaser();
        }
        this.schedule.savedProgress = this.schedule.entries.isEmpty() ? 0 : Mth.m_14045_((int)this.schedule.savedProgress, (int)0, (int)(this.schedule.entries.size() - 1));
        this.resetProgress.f_93623_ = this.schedule.savedProgress > 0;
        this.skipProgress.f_93623_ = this.schedule.entries.size() > 1;
    }

    private void fillToolTip(IconButton button, String tooltipKey) {
        if (!button.m_198029_()) {
            return;
        }
        List tip = button.getToolTip();
        tip.addAll(TooltipHelper.cutTextComponent((Component)Component.m_237115_((String)("creatingspace.gui.rocket_controls." + tooltipKey + ".description")), (FontHelper.Palette)FontHelper.Palette.ALL_GRAY));
    }

    private void renderActionTooltip(@Nullable GuiGraphics graphics, List<Component> tooltip, int mx, int my) {
        if (graphics != null) {
            graphics.m_280677_(this.f_96547_, tooltip, Optional.empty(), mx, my);
        }
    }

    protected void renderSchedule(GuiGraphics graphics, float partialTicks) {
        PoseStack matrixStack = graphics.m_280168_();
        UIRenderHelper.swapAndBlitColor((RenderTarget)this.f_96541_.m_91385_(), (RenderTarget)UIRenderHelper.framebuffer);
        UIRenderHelper.drawStretched((GuiGraphics)graphics, (int)(this.f_97735_ + 33), (int)(this.f_97736_ + 16), (int)3, (int)173, (int)-100, (TextureSheetSegment)AllGuiTextures.SCHEDULE_STRIP_DARK);
        int yOffset = 25;
        List<ScheduleEntry> entries = this.schedule.entries;
        float scrollOffset = -this.scroll.getValue(partialTicks);
        for (int i = 0; i <= entries.size(); ++i) {
            if (this.schedule.savedProgress == i && !this.schedule.entries.isEmpty()) {
                matrixStack.m_85836_();
                float expectedY = scrollOffset + (float)this.f_97736_ + (float)yOffset + 4.0f;
                float actualY = Mth.m_14036_((float)expectedY, (float)(this.f_97736_ + 18), (float)(this.f_97736_ + 170));
                matrixStack.m_252880_(0.0f, actualY, 0.0f);
                (expectedY == actualY ? AllGuiTextures.SCHEDULE_POINTER : AllGuiTextures.SCHEDULE_POINTER_OFFSCREEN).render(graphics, this.f_97735_, 0);
                matrixStack.m_85849_();
            }
            this.startStencil(graphics, this.f_97735_ + 16, this.f_97736_ + 16, 220.0f, 173.0f);
            matrixStack.m_85836_();
            matrixStack.m_252880_(0.0f, scrollOffset, 0.0f);
            if (i == 0 || entries.size() == 0) {
                UIRenderHelper.drawStretched((GuiGraphics)graphics, (int)(this.f_97735_ + 33), (int)(this.f_97736_ + 16), (int)3, (int)10, (int)-100, (TextureSheetSegment)AllGuiTextures.SCHEDULE_STRIP_LIGHT);
            }
            if (i == entries.size()) {
                if (i > 0) {
                    yOffset += 9;
                }
                AllGuiTextures.SCHEDULE_STRIP_END.render(graphics, this.f_97735_ + 29, this.f_97736_ + yOffset);
                AllGuiTextures.SCHEDULE_CARD_NEW.render(graphics, this.f_97735_ + 43, this.f_97736_ + yOffset);
                matrixStack.m_85849_();
                this.endStencil();
                break;
            }
            ScheduleEntry scheduleEntry = entries.get(i);
            int cardY = yOffset;
            int cardHeight = this.renderScheduleEntry(graphics, scheduleEntry, cardY);
            yOffset += cardHeight;
            if (i + 1 < entries.size()) {
                AllGuiTextures.SCHEDULE_STRIP_DOTTED.render(graphics, this.f_97735_ + 29, this.f_97736_ + yOffset - 3);
                yOffset += 10;
            }
            matrixStack.m_85849_();
            this.endStencil();
            if (!scheduleEntry.instruction.supportsConditions()) continue;
            float y1 = (float)(cardY + 24) + scrollOffset;
            float h = cardHeight - 26;
            float y2 = y1 + h;
            if (y2 > 189.0f) {
                h -= y2 - 189.0f;
            }
            if (y1 < 16.0f) {
                float correction = 16.0f - y1;
                y1 += correction;
                h -= correction;
            }
            if (h <= 0.0f) continue;
            this.startStencil(graphics, this.f_97735_ + 43, (float)this.f_97736_ + y1, 161.0f, h);
            matrixStack.m_85836_();
            matrixStack.m_252880_(0.0f, scrollOffset, 0.0f);
            this.renderScheduleConditions(graphics, scheduleEntry, cardY, partialTicks, cardHeight, i);
            matrixStack.m_85849_();
            this.endStencil();
            if (!this.isConditionAreaScrollable(scheduleEntry)) continue;
            this.startStencil(graphics, this.f_97735_ + 16, this.f_97736_ + 16, 220.0f, 173.0f);
            matrixStack.m_85836_();
            matrixStack.m_252880_(0.0f, scrollOffset, 0.0f);
            int center = (cardHeight - 8 + 22) / 2;
            float chaseTarget = this.horizontalScrolls.get(i).getChaseTarget();
            if (!Mth.m_14033_((float)chaseTarget, (float)0.0f)) {
                AllGuiTextures.SCHEDULE_SCROLL_LEFT.render(graphics, this.f_97735_ + 40, this.f_97736_ + cardY + center);
            }
            if (!Mth.m_14033_((float)chaseTarget, (float)(scheduleEntry.conditions.size() - 1))) {
                AllGuiTextures.SCHEDULE_SCROLL_RIGHT.render(graphics, this.f_97735_ + 203, this.f_97736_ + cardY + center);
            }
            matrixStack.m_85849_();
            this.endStencil();
        }
        int zLevel = 200;
        graphics.m_280120_(this.f_97735_ + 16, this.f_97736_ + 16, this.f_97735_ + 16 + 220, this.f_97736_ + 16 + 10, zLevel, 0x77000000, 0);
        graphics.m_280120_(this.f_97735_ + 16, this.f_97736_ + 179, this.f_97735_ + 16 + 220, this.f_97736_ + 179 + 10, zLevel, 0, 0x77000000);
        UIRenderHelper.swapAndBlitColor((RenderTarget)UIRenderHelper.framebuffer, (RenderTarget)this.f_96541_.m_91385_());
    }

    public int renderScheduleEntry(GuiGraphics graphics, ScheduleEntry entry, int yOffset) {
        int zLevel = -100;
        AllGuiTextures light = AllGuiTextures.SCHEDULE_CARD_LIGHT;
        AllGuiTextures medium = AllGuiTextures.SCHEDULE_CARD_MEDIUM;
        AllGuiTextures dark = AllGuiTextures.SCHEDULE_CARD_DARK;
        int cardWidth = 195;
        int cardHeader = 22;
        int maxRows = 0;
        for (List<ScheduleWaitCondition> list : entry.conditions) {
            maxRows = Math.max(maxRows, list.size());
        }
        boolean supportsConditions = entry.instruction.supportsConditions();
        int cardHeight = cardHeader + (supportsConditions ? 24 + maxRows * 18 : 4);
        PoseStack matrixStack = graphics.m_280168_();
        matrixStack.m_85836_();
        matrixStack.m_252880_((float)(this.f_97735_ + 25), (float)(this.f_97736_ + yOffset), 0.0f);
        UIRenderHelper.drawStretched((GuiGraphics)graphics, (int)0, (int)1, (int)cardWidth, (int)(cardHeight - 2), (int)zLevel, (TextureSheetSegment)light);
        UIRenderHelper.drawStretched((GuiGraphics)graphics, (int)1, (int)0, (int)(cardWidth - 2), (int)cardHeight, (int)zLevel, (TextureSheetSegment)light);
        UIRenderHelper.drawStretched((GuiGraphics)graphics, (int)1, (int)1, (int)(cardWidth - 2), (int)(cardHeight - 2), (int)zLevel, (TextureSheetSegment)dark);
        UIRenderHelper.drawStretched((GuiGraphics)graphics, (int)2, (int)2, (int)(cardWidth - 4), (int)(cardHeight - 4), (int)zLevel, (TextureSheetSegment)medium);
        UIRenderHelper.drawStretched((GuiGraphics)graphics, (int)2, (int)2, (int)(cardWidth - 4), (int)cardHeader, (int)zLevel, (TextureSheetSegment)(supportsConditions ? light : medium));
        AllGuiTextures.SCHEDULE_CARD_REMOVE.render(graphics, cardWidth - 14, 2);
        AllGuiTextures.SCHEDULE_CARD_DUPLICATE.render(graphics, cardWidth - 14, cardHeight - 14);
        int i = this.schedule.entries.indexOf(entry);
        if (i > 0) {
            AllGuiTextures.SCHEDULE_CARD_MOVE_UP.render(graphics, cardWidth, cardHeader - 14);
        }
        if (i < this.schedule.entries.size() - 1) {
            AllGuiTextures.SCHEDULE_CARD_MOVE_DOWN.render(graphics, cardWidth, cardHeader);
        }
        UIRenderHelper.drawStretched((GuiGraphics)graphics, (int)8, (int)0, (int)3, (int)(cardHeight + 10), (int)zLevel, (TextureSheetSegment)AllGuiTextures.SCHEDULE_STRIP_LIGHT);
        (supportsConditions ? AllGuiTextures.SCHEDULE_STRIP_TRAVEL : AllGuiTextures.SCHEDULE_STRIP_ACTION).render(graphics, 4, 6);
        if (supportsConditions) {
            AllGuiTextures.SCHEDULE_STRIP_WAIT.render(graphics, 4, 28);
        }
        Pair destination = entry.instruction.getSummary();
        this.renderInput(graphics, (Pair<ItemStack, Component>)destination, 26, 5, false, 100);
        entry.instruction.renderSpecialIcon(graphics, 30, 5);
        matrixStack.m_85849_();
        return cardHeight;
    }

    public void renderScheduleConditions(GuiGraphics graphics, ScheduleEntry entry, int yOffset, float partialTicks, int cardHeight, int entryIndex) {
        int cardWidth = 195;
        int cardHeader = 22;
        PoseStack matrixStack = graphics.m_280168_();
        matrixStack.m_85836_();
        matrixStack.m_252880_((float)(this.f_97735_ + 25), (float)(this.f_97736_ + yOffset), 0.0f);
        int xOffset = 26;
        float scrollOffset = this.getConditionScroll(entry, partialTicks, entryIndex);
        matrixStack.m_85836_();
        matrixStack.m_252880_(-scrollOffset, 0.0f, 0.0f);
        for (List<ScheduleWaitCondition> list : entry.conditions) {
            int maxWidth = this.getConditionColumnWidth(list);
            for (int i = 0; i < list.size(); ++i) {
                ScheduleWaitCondition scheduleWaitCondition = list.get(i);
                Math.max(maxWidth, this.renderInput(graphics, (Pair<ItemStack, Component>)scheduleWaitCondition.getSummary(), xOffset, 29 + i * 18, i != 0, maxWidth));
                scheduleWaitCondition.renderSpecialIcon(graphics, xOffset + 4, 29 + i * 18);
            }
            AllGuiTextures.SCHEDULE_CONDITION_APPEND.render(graphics, xOffset + (maxWidth - 10) / 2, 29 + list.size() * 18);
            xOffset += maxWidth + 10;
        }
        AllGuiTextures.SCHEDULE_CONDITION_NEW.render(graphics, xOffset - 3, 29);
        matrixStack.m_85849_();
        if (xOffset + 16 > cardWidth - 26) {
            matrixStack.m_252781_(Axis.f_252393_.m_252977_(90.0f));
            Matrix4f m = matrixStack.m_85850_().m_252922_();
            graphics.m_280120_(200, -cardHeight + 2, 18, -2 - cardHeader, 28, 0x44000000, 0);
            graphics.m_280120_(200, -cardHeight + 2, cardWidth - 26, -2 - cardHeader, cardWidth - 16, 0, 0x44000000);
        }
        matrixStack.m_85849_();
    }

    private boolean isConditionAreaScrollable(ScheduleEntry entry) {
        int xOffset = 26;
        for (List<ScheduleWaitCondition> list : entry.conditions) {
            xOffset += this.getConditionColumnWidth(list) + 10;
        }
        return xOffset + 16 > 169;
    }

    private float getConditionScroll(ScheduleEntry entry, float partialTicks, int entryIndex) {
        float scrollOffset = 0.0f;
        float scrollIndex = this.horizontalScrolls.get(entryIndex).getValue(partialTicks);
        for (List<ScheduleWaitCondition> list : entry.conditions) {
            int maxWidth = this.getConditionColumnWidth(list);
            float partialOfThisColumn = Math.min(1.0f, scrollIndex);
            scrollOffset += (float)(maxWidth + 10) * partialOfThisColumn;
            scrollIndex -= partialOfThisColumn;
        }
        return scrollOffset;
    }

    private int getConditionColumnWidth(List<ScheduleWaitCondition> list) {
        int maxWidth = 0;
        for (ScheduleWaitCondition scheduleWaitCondition : list) {
            maxWidth = Math.max(maxWidth, this.getFieldSize(32, (Pair<ItemStack, Component>)scheduleWaitCondition.getSummary()));
        }
        return maxWidth;
    }

    private int getFieldSize(int minSize, Pair<ItemStack, Component> pair) {
        ItemStack stack = (ItemStack)pair.getFirst();
        Component text = (Component)pair.getSecond();
        boolean hasItem = !stack.m_41619_();
        return Math.max((text == null ? 0 : this.f_96547_.m_92852_((FormattedText)text)) + (hasItem ? 20 : 0) + 16, minSize);
    }

    protected int renderInput(GuiGraphics graphics, Pair<ItemStack, Component> pair, int x, int y, boolean clean, int minSize) {
        ItemStack stack = (ItemStack)pair.getFirst();
        Component text = (Component)pair.getSecond();
        boolean hasItem = !stack.m_41619_();
        int fieldSize = Math.min(this.getFieldSize(minSize, pair), 150);
        PoseStack matrixStack = graphics.m_280168_();
        matrixStack.m_85836_();
        AllGuiTextures left = clean ? AllGuiTextures.SCHEDULE_CONDITION_LEFT_CLEAN : AllGuiTextures.SCHEDULE_CONDITION_LEFT;
        AllGuiTextures middle = AllGuiTextures.SCHEDULE_CONDITION_MIDDLE;
        AllGuiTextures item = AllGuiTextures.SCHEDULE_CONDITION_ITEM;
        AllGuiTextures right = AllGuiTextures.SCHEDULE_CONDITION_RIGHT;
        matrixStack.m_252880_((float)x, (float)y, 0.0f);
        UIRenderHelper.drawStretched((GuiGraphics)graphics, (int)0, (int)0, (int)fieldSize, (int)16, (int)-100, (TextureSheetSegment)middle);
        left.render(graphics, clean ? 0 : -3, 0);
        right.render(graphics, fieldSize - 2, 0);
        if (hasItem) {
            item.render(graphics, 3, 0);
        }
        if (hasItem) {
            item.render(graphics, 3, 0);
            if (stack.m_41720_() != Items.f_42263_) {
                GuiGameElement.of((ItemStack)stack).at(4.0f, 0.0f).render(graphics);
            }
        }
        if (text != null) {
            graphics.m_280488_(this.f_96547_, this.f_96547_.m_92854_((FormattedText)text, 120).getString(), hasItem ? 28 : 8, 4, -855314);
        }
        matrixStack.m_85849_();
        return fieldSize;
    }

    protected void startStencil(GuiGraphics graphics, float x, float y, float w, float h) {
        RenderSystem.clear((int)1280, (boolean)Minecraft.f_91002_);
        GL11.glDisable((int)2960);
        RenderSystem.stencilMask((int)-1);
        RenderSystem.clear((int)1024, (boolean)Minecraft.f_91002_);
        GL11.glEnable((int)2960);
        RenderSystem.stencilOp((int)7681, (int)7680, (int)7680);
        RenderSystem.stencilMask((int)255);
        RenderSystem.stencilFunc((int)512, (int)1, (int)255);
        PoseStack matrixStack = graphics.m_280168_();
        matrixStack.m_85836_();
        matrixStack.m_252880_(x, y, 0.0f);
        matrixStack.m_85841_(w, h, 1.0f);
        graphics.m_280120_(0, 0, 1, 1, -100, -16777216, -16777216);
        matrixStack.m_85849_();
        GL11.glEnable((int)2960);
        RenderSystem.stencilOp((int)7680, (int)7680, (int)7680);
        RenderSystem.stencilFunc((int)514, (int)1, (int)255);
    }

    protected void endStencil() {
        GL11.glDisable((int)2960);
    }

    protected void startEditing(IScheduleInput field, Consumer<Boolean> onClose, boolean allowDeletion) {
        int i;
        int startIndex;
        this.onEditorClose = onClose;
        this.validateSetting.f_93624_ = true;
        this.validateSetting.f_93623_ = true;
        this.cyclicButton.f_93624_ = false;
        this.cyclicIndicator.f_93624_ = false;
        this.skipProgress.f_93624_ = false;
        this.resetProgress.f_93624_ = false;
        this.scrollInput = new SelectionScrollInput(this.f_97735_ + 56, this.f_97736_ + 65, 143, 16);
        this.scrollInputLabel = new Label(this.f_97735_ + 59, this.f_97736_ + 69, (Component)Component.m_237119_()).withShadow();
        this.editorConfirm = new IconButton(this.f_97735_ + 56 + 168, this.f_97736_ + 65 + 22, (ScreenElement)AllIcons.I_CONFIRM);
        if (allowDeletion) {
            this.editorDelete = new IconButton(this.f_97735_ + 56 - 45, this.f_97736_ + 65 + 22, (ScreenElement)AllIcons.I_TRASH);
        }
        if (field instanceof ScheduleInstruction) {
            ScheduleInstruction instruction = (ScheduleInstruction)field;
            startIndex = 0;
            for (i = 0; i < RocketSchedule.INSTRUCTION_TYPES.size(); ++i) {
                if (!((ResourceLocation)RocketSchedule.INSTRUCTION_TYPES.get(i).getFirst()).equals((Object)instruction.getId())) continue;
                startIndex = i;
            }
            this.editingDestination = instruction;
            this.updateEditorSubwidgets((IScheduleInput)this.editingDestination);
            this.scrollInput.forOptions(RocketSchedule.getTypeOptions(RocketSchedule.INSTRUCTION_TYPES)).titled(CreateLang.translateDirect((String)"schedule.instruction_type", (Object[])new Object[0])).writingTo(this.scrollInputLabel).calling(index -> {
                ScheduleInstruction newlyCreated = (ScheduleInstruction)((Object)((Object)((Supplier)RocketSchedule.INSTRUCTION_TYPES.get((int)index).getSecond()).get()));
                if (this.editingDestination.getId().equals((Object)newlyCreated.getId())) {
                    return;
                }
                this.editingDestination = newlyCreated;
                this.updateEditorSubwidgets((IScheduleInput)this.editingDestination);
            }).setState(startIndex);
        }
        if (field instanceof ScheduleWaitCondition) {
            ScheduleWaitCondition cond = (ScheduleWaitCondition)field;
            startIndex = 0;
            for (i = 0; i < RocketSchedule.CONDITION_TYPES.size(); ++i) {
                if (!((ResourceLocation)RocketSchedule.CONDITION_TYPES.get(i).getFirst()).equals((Object)cond.getId())) continue;
                startIndex = i;
            }
            this.editingCondition = cond;
            this.updateEditorSubwidgets((IScheduleInput)this.editingCondition);
            this.scrollInput.forOptions(RocketSchedule.getTypeOptions(RocketSchedule.CONDITION_TYPES)).titled(CreateLang.translateDirect((String)"schedule.condition_type", (Object[])new Object[0])).writingTo(this.scrollInputLabel).calling(index -> {
                ScheduleWaitCondition newlyCreated = (ScheduleWaitCondition)((Object)((Object)((Supplier)RocketSchedule.CONDITION_TYPES.get((int)index).getSecond()).get()));
                if (this.editingCondition.getId().equals((Object)newlyCreated.getId())) {
                    return;
                }
                this.editingCondition = newlyCreated;
                this.updateEditorSubwidgets((IScheduleInput)this.editingCondition);
            }).setState(startIndex);
        }
        this.m_142416_((GuiEventListener)this.scrollInput);
        this.m_142416_((GuiEventListener)this.scrollInputLabel);
        this.m_142416_((GuiEventListener)this.editorConfirm);
        if (allowDeletion) {
            this.m_142416_((GuiEventListener)this.editorDelete);
        }
    }

    protected void updateEditorSubwidgets(IScheduleInput field) {
        this.editorSubWidgets.forEach(x$0 -> this.m_169411_((GuiEventListener)x$0));
        this.editorSubWidgets.clear();
        field.initConfigurationWidgets(new ModularGuiLineBuilder(this.f_96547_, this.editorSubWidgets, this.f_97735_ + 77, this.f_97736_ + 92).speechBubble());
        this.editorSubWidgets.loadValues(field.getData(), x$0 -> this.m_142416_((GuiEventListener)x$0), x$0 -> {
            GuiEventListener cfr_ignored_0 = (GuiEventListener)this.m_169394_((Renderable)x$0);
        });
        if (!(field instanceof DestinationInstruction)) {
            return;
        }
        this.editorSubWidgets.forEach(e -> {
            if (!(e instanceof ScrollInput)) {
                return;
            }
            this.updateCostWidget(((ScrollInput)e).getState());
            ((ScrollInput)e).calling(this::updateCostWidget);
        });
    }

    private void updateCostWidget(int e) {
        this.destinationCost.setTextAndTrim((Component)Component.m_237113_((String)String.valueOf(CSDimensionUtil.cost(this.currentDimension, CSDimensionUtil.getPlanets().get(e)))), true, 112);
        this.destinationCost.withBorderColors(this.rocketContraption.deltaV() < (float)CSDimensionUtil.cost(this.currentDimension, CSDimensionUtil.getPlanets().get(e)) ? Couple.create((Object)Color.RED, (Object)Color.RED) : Couple.create((Object)Color.GREEN, (Object)Color.GREEN));
        this.destination = CSDimensionUtil.getPlanets().get(e);
        this.destinationChanged = true;
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (this.editorConfirm != null && this.editorConfirm.m_5953_(pMouseX, pMouseY) && this.onEditorClose != null) {
            this.onEditorClose.accept(true);
            this.stopEditing();
            return true;
        }
        if (this.editorDelete != null && this.editorDelete.m_5953_(pMouseX, pMouseY) && this.onEditorClose != null) {
            this.onEditorClose.accept(false);
            this.stopEditing();
            return true;
        }
        if (this.action(null, pMouseX, pMouseY, pButton)) {
            return true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        int maxRows;
        if (this.editingCondition != null || this.editingDestination != null) {
            return super.m_6050_(pMouseX, pMouseY, pDelta);
        }
        if (ScheduleMakingScreen.m_96638_()) {
            List<ScheduleEntry> entries = this.schedule.entries;
            int y = (int)(pMouseY - (double)this.f_97736_ - 25.0 + (double)this.scroll.getValue());
            for (int i = 0; i < entries.size(); ++i) {
                ScheduleEntry entry = entries.get(i);
                maxRows = 0;
                for (List<ScheduleWaitCondition> list : entry.conditions) {
                    maxRows = Math.max(maxRows, list.size());
                }
                int cardHeight = 46 + maxRows * 18;
                if (y >= cardHeight) {
                    if ((y -= cardHeight + 9) >= 0) continue;
                    break;
                }
                if (!this.isConditionAreaScrollable(entry) || y < 24 || pMouseX < (double)(this.f_97735_ + 25) || pMouseX > (double)(this.f_97736_ + 205)) break;
                float chaseTarget = this.horizontalScrolls.get(i).getChaseTarget();
                if (pDelta > 0.0 && !Mth.m_14033_((float)chaseTarget, (float)0.0f)) {
                    this.horizontalScrolls.get(i).chase((double)(chaseTarget - 1.0f), 0.5, LerpedFloat.Chaser.EXP);
                    return true;
                }
                if (pDelta < 0.0 && !Mth.m_14033_((float)chaseTarget, (float)(entry.conditions.size() - 1))) {
                    this.horizontalScrolls.get(i).chase((double)(chaseTarget + 1.0f), 0.5, LerpedFloat.Chaser.EXP);
                    return true;
                }
                return false;
            }
        }
        float chaseTarget = this.scroll.getChaseTarget();
        float max = -133.0f;
        for (ScheduleEntry scheduleEntry : this.schedule.entries) {
            maxRows = 0;
            for (List<ScheduleWaitCondition> list : scheduleEntry.conditions) {
                maxRows = Math.max(maxRows, list.size());
            }
            max += (float)(46 + maxRows * 18 + 10);
        }
        if (max > 0.0f) {
            chaseTarget = (float)((double)chaseTarget - pDelta * 12.0);
            chaseTarget = Mth.m_14036_((float)chaseTarget, (float)0.0f, (float)max);
            this.scroll.chase((double)((int)chaseTarget), (double)0.7f, LerpedFloat.Chaser.EXP);
        } else {
            this.scroll.chase(0.0, (double)0.7f, LerpedFloat.Chaser.EXP);
        }
        return super.m_6050_(pMouseX, pMouseY, pDelta);
    }

    public boolean action(GuiGraphics graphics, double mouseX, double mouseY, int click) {
        if (this.editingCondition != null) {
            return false;
        }
        MutableComponent empty = Component.m_237119_();
        int mx = (int)mouseX;
        int my = (int)mouseY;
        int x = mx - this.f_97735_ - 25;
        int y = my - this.f_97736_ - 25;
        int x2 = this.f_96543_ - mx;
        if (this.editingDestination != null) {
            if (x2 > 50 && x2 < 100) {
                ArrayList<Component> components = new ArrayList<Component>();
                if (y > 36 && y < 52) {
                    components.add((Component)Component.m_237115_((String)"creatingspace.gui.rocket_controls.x_entry_coord"));
                    this.renderActionTooltip(graphics, components, mx, my);
                }
                if (y > 56 && y < 73) {
                    components.add((Component)Component.m_237115_((String)"creatingspace.gui.rocket_controls.z_entry_coord"));
                    this.renderActionTooltip(graphics, components, mx, my);
                }
            }
            return false;
        }
        if (x < 0 || x >= 205) {
            return false;
        }
        if (y < 0 || y >= 173) {
            return false;
        }
        y = (int)((float)y + this.scroll.getValue(0.0f));
        List<ScheduleEntry> entries = this.schedule.entries;
        for (int i = 0; i < entries.size(); ++i) {
            int center;
            ScheduleEntry entry = entries.get(i);
            int maxRows = 0;
            for (List<ScheduleWaitCondition> list : entry.conditions) {
                maxRows = Math.max(maxRows, list.size());
            }
            int cardHeight = 22 + (entry.instruction.supportsConditions() ? 24 + maxRows * 18 : 4);
            if (y >= cardHeight + 5) {
                if ((y -= cardHeight + 10) >= 0) continue;
                return false;
            }
            int fieldSize = this.getFieldSize(100, (Pair<ItemStack, Component>)entry.instruction.getSummary());
            if (x > 25 && x <= 25 + fieldSize && y > 4 && y <= 20) {
                ArrayList<Component> components = new ArrayList<Component>();
                components.addAll(entry.instruction.getTitleAs("instruction"));
                components.add((Component)empty);
                components.add(this.clickToEdit);
                this.renderActionTooltip(graphics, components, mx, my);
                if (click == 0) {
                    this.startEditing((IScheduleInput)entry.instruction, confirmed -> {
                        if (confirmed.booleanValue()) {
                            entry.instruction = this.editingDestination;
                        }
                    }, false);
                }
                return true;
            }
            if (x > 180 && x <= 192) {
                if (y > 0 && y <= 14) {
                    this.renderActionTooltip(graphics, (List<Component>)ImmutableList.of((Object)CreateLang.translateDirect((String)"gui.schedule.remove_entry", (Object[])new Object[0])), mx, my);
                    if (click == 0) {
                        entries.remove(entry);
                        this.m_7856_();
                    }
                    return true;
                }
                if (y > cardHeight - 14) {
                    this.renderActionTooltip(graphics, (List<Component>)ImmutableList.of((Object)CreateLang.translateDirect((String)"gui.schedule.duplicate", (Object[])new Object[0])), mx, my);
                    if (click == 0) {
                        entries.add(entries.indexOf(entry), entry.clone());
                        this.m_7856_();
                    }
                    return true;
                }
            }
            if (x > 194) {
                if (y > 7 && y <= 20 && i > 0) {
                    this.renderActionTooltip(graphics, (List<Component>)ImmutableList.of((Object)CreateLang.translateDirect((String)"gui.schedule.move_up", (Object[])new Object[0])), mx, my);
                    if (click == 0) {
                        entries.remove(entry);
                        entries.add(i - 1, entry);
                        this.m_7856_();
                    }
                    return true;
                }
                if (y > 20 && y <= 33 && i < entries.size() - 1) {
                    this.renderActionTooltip(graphics, (List<Component>)ImmutableList.of((Object)CreateLang.translateDirect((String)"gui.schedule.move_down", (Object[])new Object[0])), mx, my);
                    if (click == 0) {
                        entries.remove(entry);
                        entries.add(i + 1, entry);
                        this.m_7856_();
                    }
                    return true;
                }
            }
            if (y > (center = (cardHeight - 8 + 22) / 2) - 1 && y <= center + 7 && this.isConditionAreaScrollable(entry)) {
                float chaseTarget = this.horizontalScrolls.get(i).getChaseTarget();
                if (x > 12 && x <= 19 && !Mth.m_14033_((float)chaseTarget, (float)0.0f)) {
                    if (click == 0) {
                        this.horizontalScrolls.get(i).chase((double)(chaseTarget - 1.0f), 0.5, LerpedFloat.Chaser.EXP);
                    }
                    return true;
                }
                if (x > 177 && x <= 184 && !Mth.m_14033_((float)chaseTarget, (float)(entry.conditions.size() - 1))) {
                    if (click == 0) {
                        this.horizontalScrolls.get(i).chase((double)(chaseTarget + 1.0f), 0.5, LerpedFloat.Chaser.EXP);
                    }
                    return true;
                }
            }
            if ((x -= 18) < 0 || (y -= 28) < 0 || x > 160) {
                return false;
            }
            x = (int)((float)x + (this.getConditionScroll(entry, 0.0f, i) - 8.0f));
            List<List<ScheduleWaitCondition>> columns = entry.conditions;
            for (int j = 0; j < columns.size(); ++j) {
                List<ScheduleWaitCondition> conditions = columns.get(j);
                if (x < 0) {
                    return false;
                }
                int w = this.getConditionColumnWidth(conditions);
                if (x >= w) {
                    x -= w + 10;
                    continue;
                }
                int row = y / 18;
                if (row < conditions.size() && row >= 0) {
                    boolean canRemove = conditions.size() > 1 || columns.size() > 1;
                    ArrayList<Component> components = new ArrayList<Component>();
                    components.add((Component)CreateLang.translateDirect((String)"schedule.condition_type", (Object[])new Object[0]).m_130940_(ChatFormatting.GRAY));
                    ScheduleWaitCondition condition = conditions.get(row);
                    components.addAll(condition.getTitleAs("condition"));
                    components.add((Component)empty);
                    components.add(this.clickToEdit);
                    if (canRemove) {
                        components.add(this.rClickToDelete);
                    }
                    this.renderActionTooltip(graphics, components, mx, my);
                    if (canRemove && click == 1) {
                        conditions.remove(row);
                        if (conditions.isEmpty()) {
                            columns.remove(conditions);
                        }
                    }
                    if (click == 0) {
                        this.startEditing((IScheduleInput)condition, confirmed -> {
                            conditions.remove(row);
                            if (confirmed.booleanValue()) {
                                conditions.add(row, this.editingCondition);
                                return;
                            }
                            if (conditions.isEmpty()) {
                                columns.remove(conditions);
                            }
                        }, canRemove);
                    }
                    return true;
                }
                if (y > 18 * conditions.size() && y <= 18 * conditions.size() + 10 && x >= w / 2 - 5 && x < w / 2 + 5) {
                    this.renderActionTooltip(graphics, (List<Component>)ImmutableList.of((Object)CreateLang.translateDirect((String)"gui.schedule.add_condition", (Object[])new Object[0])), mx, my);
                    if (click == 0) {
                        this.startEditing((IScheduleInput)new ScheduledDelay(), confirmed -> {
                            if (confirmed.booleanValue()) {
                                conditions.add(this.editingCondition);
                            }
                        }, true);
                    }
                    return true;
                }
                return false;
            }
            if (x < 0 || x > 15 || y > 20) {
                return false;
            }
            this.renderActionTooltip(graphics, (List<Component>)ImmutableList.of((Object)CreateLang.translateDirect((String)"gui.schedule.alternative_condition", (Object[])new Object[0])), mx, my);
            if (click == 0) {
                this.startEditing((IScheduleInput)new ScheduledDelay(), confirmed -> {
                    if (!confirmed.booleanValue()) {
                        return;
                    }
                    ArrayList<ScheduleWaitCondition> conditions = new ArrayList<ScheduleWaitCondition>();
                    conditions.add(this.editingCondition);
                    columns.add(conditions);
                }, true);
            }
            return true;
        }
        if (x < 18 || x > 33 || y > 14) {
            return false;
        }
        this.renderActionTooltip(graphics, (List<Component>)ImmutableList.of((Object)CreateLang.translateDirect((String)"gui.schedule.add_entry", (Object[])new Object[0])), mx, my);
        if (click == 0) {
            this.startEditing((IScheduleInput)new DestinationInstruction(), confirmed -> {
                if (!confirmed.booleanValue()) {
                    return;
                }
                ScheduleEntry entry = new ScheduleEntry();
                ScheduledDelay delay = new ScheduledDelay();
                ArrayList<ScheduledDelay> initialConditions = new ArrayList<ScheduledDelay>();
                initialConditions.add(delay);
                entry.instruction = this.editingDestination;
                entry.conditions.add(initialConditions);
                this.schedule.entries.add(entry);
            }, true);
        }
        return true;
    }

    public void m_7861_() {
        PacketInit.getChannel().sendToServer((Object)new RocketScheduleEditPacket(this.schedule, ((RocketContraptionEntity)((Object)((RocketMenu)this.m_6262_()).contentHolder)).m_19879_()));
        ((RocketContraptionEntity)((Object)((RocketMenu)this.m_6262_()).contentHolder)).schedule.setSchedule(this.schedule, true);
        super.m_7861_();
    }

    protected void stopEditing() {
        this.cyclicButton.f_93624_ = true;
        this.cyclicIndicator.f_93624_ = true;
        this.skipProgress.f_93624_ = true;
        this.resetProgress.f_93624_ = true;
        if (this.editingCondition == null && this.editingDestination == null) {
            return;
        }
        this.validateSetting.runCallback((double)(this.validateSetting.m_252754_() + 1), (double)(this.validateSetting.m_252907_() + 1));
        this.validateSetting.f_93624_ = false;
        this.validateSetting.f_93623_ = false;
        this.m_169411_((GuiEventListener)this.scrollInput);
        this.m_169411_((GuiEventListener)this.scrollInputLabel);
        this.m_169411_((GuiEventListener)this.editorConfirm);
        this.m_169411_((GuiEventListener)this.editorDelete);
        ScheduleDataEntry editing = this.editingCondition == null ? this.editingDestination : this.editingCondition;
        this.editorSubWidgets.saveValues(editing.getData());
        this.editorSubWidgets.forEach(x$0 -> this.m_169411_((GuiEventListener)x$0));
        this.editorSubWidgets.clear();
        this.editingCondition = null;
        this.editingDestination = null;
        this.editorConfirm = null;
        this.editorDelete = null;
        this.m_7856_();
    }
}

