/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.content.rocket.network;

import com.rae.creatingspace.content.rocket.RocketContraptionEntity;
import com.rae.creatingspace.content.rocket.rocket_control.RocketControlsBlockEntity;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class RocketEntryPosMapClientPacket
extends SimplePacketBase {
    private HashMap<ResourceLocation, BlockPos> initialPosMap;
    private int id;

    public RocketEntryPosMapClientPacket(int id, HashMap<ResourceLocation, BlockPos> initialPosMap) {
        this.id = id;
        this.initialPosMap = initialPosMap;
    }

    public RocketEntryPosMapClientPacket(FriendlyByteBuf buffer) {
        this.id = buffer.readInt();
        this.initialPosMap = RocketControlsBlockEntity.getPosMap(buffer.m_130260_());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.id);
        buffer.m_130079_(RocketControlsBlockEntity.putPosMap(this.initialPosMap));
    }

    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ServerPlayer sender = context.getSender();
            assert (sender != null);
            Entity entity = sender.m_9236_().m_6815_(this.id);
            if (entity instanceof RocketContraptionEntity) {
                RocketContraptionEntity ce = (RocketContraptionEntity)entity;
                ce.setInitialPosMap(this.initialPosMap);
            }
        });
        return true;
    }
}

