/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.init;

import com.rae.creatingspace.CreatingSpace;
import com.rae.creatingspace.api.planets.RocketAccessibleDimension;
import com.rae.creatingspace.content.event.DataEventHandler;
import com.rae.creatingspace.content.rocket.engine.design.ExhaustPackType;
import com.rae.creatingspace.content.rocket.engine.design.PowerPackType;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;

public class MiscInit {
    public static final DeferredRegister<ExhaustPackType> DEFERRED_EXHAUST_PACK_TYPE = DeferredRegister.create(Keys.EXHAUST_PACK_TYPE, (String)"creatingspace");
    public static final Supplier<IForgeRegistry<ExhaustPackType>> EXHAUST_PACK_TYPE = DEFERRED_EXHAUST_PACK_TYPE.makeRegistry(() -> new RegistryBuilder().allowModification().disableSaving());
    public static final RegistryObject<ExhaustPackType> BELL_NOZZLE = DEFERRED_EXHAUST_PACK_TYPE.register("bell_nozzle", () -> new ExhaustPackType(2.0f, 100.0f, List.of(CreatingSpace.resource("methalox"))));
    public static final DeferredRegister<PowerPackType> DEFERRED_POWER_PACK_TYPE = DeferredRegister.create(Keys.POWER_PACK_TYPE, (String)"creatingspace");
    public static final Supplier<IForgeRegistry<PowerPackType>> POWER_PACK_TYPE = DEFERRED_POWER_PACK_TYPE.makeRegistry(() -> new RegistryBuilder().allowModification().disableSaving());
    public static final RegistryObject<PowerPackType> OPEN_CYCLE = DEFERRED_POWER_PACK_TYPE.register("open_cycle", () -> new PowerPackType(2.0f, 1, List.of(CreatingSpace.resource("methalox"))));
    public static final DeferredRegister<RocketAccessibleDimension> DEFERRED_ROCKET_ACCESSIBLE_DIMENSION = DeferredRegister.create(RocketAccessibleDimension.REGISTRY_KEY, (String)"creatingspace");
    public static final Supplier<IForgeRegistry<RocketAccessibleDimension>> ROCKET_ACCESSIBLE_DIMENSIONS = DEFERRED_ROCKET_ACCESSIBLE_DIMENSION.makeRegistry(() -> new RegistryBuilder().allowModification().disableSaving());

    public static Registry<ExhaustPackType> getSyncedExhaustPackRegistry() {
        return DataEventHandler.getSideAwareRegistry(Keys.EXHAUST_PACK_TYPE);
    }

    public static Registry<PowerPackType> getSyncedPowerPackRegistry() {
        return DataEventHandler.getSideAwareRegistry(Keys.POWER_PACK_TYPE);
    }

    public static void register(IEventBus modEventBus) {
        DEFERRED_EXHAUST_PACK_TYPE.register(modEventBus);
        DEFERRED_POWER_PACK_TYPE.register(modEventBus);
        DEFERRED_ROCKET_ACCESSIBLE_DIMENSION.register(modEventBus);
    }

    public static class Keys {
        public static final ResourceKey<Registry<ExhaustPackType>> EXHAUST_PACK_TYPE = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("creatingspace:exhaust_pack_type"));
        public static final ResourceKey<Registry<PowerPackType>> POWER_PACK_TYPE = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("creatingspace:power_pack_type"));
    }
}

