/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.init.ingameobject;

import com.rae.creatingspace.CreatingSpace;
import com.rae.creatingspace.init.TagsInit;
import com.simibubi.create.AllFluids;
import com.simibubi.create.content.fluids.VirtualFluid;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.tterrag.registrate.builders.FluidBuilder;
import com.tterrag.registrate.util.entry.FluidEntry;
import java.util.function.Supplier;
import net.createmod.catnip.theme.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidInteractionRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import org.joml.Vector3f;

public class FluidInit {
    public static final FluidEntry<VirtualFluid> LIQUID_METHANE = FluidInit.registrateCustomVirtualLiquid("liquid_methane").properties(p -> p.viscosity(1000).temperature(90).density(500).canExtinguish(true)).tag(new TagKey[]{TagsInit.CustomFluidTags.LIQUID_METHANE.tag}).register();
    public static final FluidEntry<VirtualFluid> LIQUID_OXYGEN = FluidInit.registrateCustomVirtualLiquid("liquid_oxygen").properties(p -> p.viscosity(1000).temperature(90).density(1000)).tag(new TagKey[]{TagsInit.CustomFluidTags.LIQUID_OXYGEN.tag}).register();
    public static final FluidEntry<VirtualFluid> LIQUID_HYDROGEN = FluidInit.registrateCustomVirtualLiquid("liquid_hydrogen").properties(p -> p.viscosity(1000).temperature(10).density(70)).tag(new TagKey[]{TagsInit.CustomFluidTags.LIQUID_HYDROGEN.tag}).register();
    public static final FluidEntry<VirtualFluid> LIQUID_CO2 = FluidInit.registrateCustomVirtualLiquid("liquid_co2").properties(p -> p.viscosity(1000).temperature(180).density(1100)).tag(new TagKey[]{TagsInit.CustomFluidTags.LIQUID_CO2.tag}).register();

    private static ResourceLocation customStill(String name) {
        return CreatingSpace.resource("fluid/" + name + "_still");
    }

    private static ResourceLocation customFlowing(String name) {
        return CreatingSpace.resource("fluid/" + name + "_flow");
    }

    private static FluidBuilder<VirtualFluid, CreateRegistrate> registrateCustomVirtualLiquid(String name) {
        return CreatingSpace.REGISTRATE.virtualFluid(name, FluidInit.customStill(name), FluidInit.customFlowing(name));
    }

    public static void register() {
    }

    public static void registerOpenEndedEffect() {
    }

    public static void registerFluidInteractions() {
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ForgeMod.LAVA_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(((VirtualFluid)LIQUID_HYDROGEN.get()).getFluidType(), fluidState -> {
            if (fluidState.m_76170_()) {
                return Blocks.f_50080_.m_49966_();
            }
            return Blocks.f_50652_.m_49966_();
        }));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ForgeMod.WATER_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(((VirtualFluid)LIQUID_HYDROGEN.get()).getFluidType(), fluidState -> {
            if (fluidState.m_76170_()) {
                return Blocks.f_50126_.m_49966_();
            }
            return Blocks.f_50127_.m_49966_();
        }));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ForgeMod.LAVA_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(((VirtualFluid)LIQUID_OXYGEN.get()).getFluidType(), fluidState -> {
            if (fluidState.m_76170_()) {
                return Blocks.f_50080_.m_49966_();
            }
            return Blocks.f_50652_.m_49966_();
        }));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ForgeMod.WATER_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(((VirtualFluid)LIQUID_OXYGEN.get()).getFluidType(), fluidState -> {
            if (fluidState.m_76170_()) {
                return Blocks.f_50126_.m_49966_();
            }
            return Blocks.f_50127_.m_49966_();
        }));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ForgeMod.LAVA_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(((VirtualFluid)LIQUID_METHANE.get()).getFluidType(), fluidState -> {
            if (fluidState.m_76170_()) {
                return Blocks.f_50080_.m_49966_();
            }
            return Blocks.f_50652_.m_49966_();
        }));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ForgeMod.WATER_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(((VirtualFluid)LIQUID_METHANE.get()).getFluidType(), fluidState -> {
            if (fluidState.m_76170_()) {
                return Blocks.f_50126_.m_49966_();
            }
            return Blocks.f_50127_.m_49966_();
        }));
    }

    private static class SolidRenderedPlaceableFluidType
    extends AllFluids.TintedFluidType {
        private Vector3f fogColor;
        private Supplier<Float> fogDistance;

        public static FluidBuilder.FluidTypeFactory create(int fogColor, Supplier<Float> fogDistance) {
            return (p, s, f) -> {
                SolidRenderedPlaceableFluidType fluidType = new SolidRenderedPlaceableFluidType(p, s, f);
                fluidType.fogColor = new Color(fogColor, false).asVectorF();
                fluidType.fogDistance = fogDistance;
                return fluidType;
            };
        }

        private SolidRenderedPlaceableFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture);
        }

        protected int getTintColor(FluidStack stack) {
            return -1;
        }

        public int getTintColor(FluidState state, BlockAndTintGetter world, BlockPos pos) {
            return 0xFFFFFF;
        }

        protected Vector3f getCustomFogColor() {
            return this.fogColor;
        }

        protected float getFogDistanceModifier() {
            return this.fogDistance.get().floatValue();
        }
    }
}

