/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.legacy.server.blockentities;

import com.rae.creatingspace.init.TagsInit;
import com.rae.creatingspace.init.ingameobject.FluidInit;
import com.rae.creatingspace.legacy.server.blocks.LegacyMechanicalElectrolyzerBlock;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LegacyMechanicalElectrolyzerBlockEntity
extends KineticBlockEntity
implements IHaveGoggleInformation {
    private static final int SYNC_RATE = 8;
    protected int syncCooldown;
    protected boolean queuedSync;
    float residualFloatO2Amount = 0.0f;
    float residualFloatH2Amount = 0.0f;
    private final LazyOptional<IFluidHandler> waterFluidOptional = LazyOptional.of(() -> this.WATER_TANK);
    private final FluidTank WATER_TANK = new FluidTank(4000){

        protected void onContentsChanged() {
            LegacyMechanicalElectrolyzerBlockEntity.this.sendData();
            super.onContentsChanged();
        }

        public boolean isFluidValid(FluidStack stack) {
            return stack.getFluid() == Fluids.f_76193_.m_5613_();
        }
    };
    private final LazyOptional<IFluidHandler> hydrogenFluidOptional = LazyOptional.of(() -> this.HYDROGEN_TANK);
    private final FluidTank HYDROGEN_TANK = new FluidTank(4000){

        protected void onContentsChanged() {
            LegacyMechanicalElectrolyzerBlockEntity.this.sendData();
            super.onContentsChanged();
        }

        public boolean isFluidValid(FluidStack stack) {
            return TagsInit.CustomFluidTags.LIQUID_HYDROGEN.matches(stack.getFluid());
        }
    };
    private final LazyOptional<IFluidHandler> oxygenFluidOptional = LazyOptional.of(() -> this.OXYGEN_TANK);
    private final FluidTank OXYGEN_TANK = new FluidTank(4000){

        protected void onContentsChanged() {
            LegacyMechanicalElectrolyzerBlockEntity.this.sendData();
            super.onContentsChanged();
        }

        public boolean isFluidValid(FluidStack stack) {
            return TagsInit.CustomFluidTags.LIQUID_OXYGEN.matches(stack.getFluid());
        }
    };
    float coefficient = 0.5f;

    public LegacyMechanicalElectrolyzerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void sendData() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        super.sendData();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            Direction localDir = (Direction)this.m_58900_().m_61143_((Property)LegacyMechanicalElectrolyzerBlock.H_FACING);
            if (side != Direction.DOWN && side != Direction.UP && side != null) {
                if (localDir == side.m_122424_()) {
                    return this.waterFluidOptional.cast();
                }
                if (localDir == side.m_122427_()) {
                    return this.hydrogenFluidOptional.cast();
                }
                if (localDir == side.m_122428_()) {
                    return this.oxygenFluidOptional.cast();
                }
            }
        }
        return LazyOptional.empty();
    }

    public void tick(Level level, BlockPos pos, BlockState state, LegacyMechanicalElectrolyzerBlockEntity blockEntity) {
        super.tick();
        if (!level.m_5776_()) {
            if (this.syncCooldown > 0) {
                --this.syncCooldown;
                if (this.syncCooldown == 0 && this.queuedSync) {
                    this.sendData();
                }
            }
            if (this.hasRecipe(blockEntity)) {
                float rot_speed = this.getSpeed();
                float H2Amount = this.hydrogenProduction(rot_speed) / (float)FluidInit.LIQUID_HYDROGEN.getType().getDensity() * 1000.0f;
                float O2Amount = this.oxygenProduction(rot_speed) / (float)FluidInit.LIQUID_OXYGEN.getType().getDensity() * 1000.0f;
                this.residualFloatH2Amount += H2Amount - (float)((int)H2Amount);
                this.residualFloatO2Amount += O2Amount - (float)((int)O2Amount);
                blockEntity.HYDROGEN_TANK.fill(new FluidStack((Fluid)FluidInit.LIQUID_HYDROGEN.get(), (int)H2Amount + (int)this.residualFloatH2Amount), IFluidHandler.FluidAction.EXECUTE);
                blockEntity.OXYGEN_TANK.fill(new FluidStack((Fluid)FluidInit.LIQUID_OXYGEN.get(), (int)O2Amount + (int)this.residualFloatO2Amount), IFluidHandler.FluidAction.EXECUTE);
                blockEntity.WATER_TANK.drain((int)this.waterConsumption(rot_speed), IFluidHandler.FluidAction.EXECUTE);
                this.residualFloatO2Amount -= (float)((int)this.residualFloatO2Amount);
                this.residualFloatH2Amount -= (float)((int)this.residualFloatH2Amount);
            }
        }
    }

    private boolean hasRecipe(LegacyMechanicalElectrolyzerBlockEntity blockEntity) {
        float rot_speed = this.getSpeed();
        boolean isRunning = !blockEntity.isOverStressed();
        boolean enoughWater = (float)blockEntity.WATER_TANK.getFluidAmount() > this.waterConsumption(rot_speed);
        boolean enoughSpaceInHTank = (float)blockEntity.HYDROGEN_TANK.getSpace() > this.hydrogenProduction(rot_speed) / (float)FluidInit.LIQUID_HYDROGEN.getType().getDensity() * 1000.0f;
        boolean enoughSpaceInOTank = (float)blockEntity.OXYGEN_TANK.getSpace() > this.oxygenProduction(rot_speed) / (float)FluidInit.LIQUID_OXYGEN.getType().getDensity() * 1000.0f;
        return enoughWater && isRunning;
    }

    protected void read(CompoundTag nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        this.HYDROGEN_TANK.setFluid(new FluidStack((Fluid)FluidInit.LIQUID_HYDROGEN.get(), nbt.m_128451_("hydrogenAmount")));
        this.OXYGEN_TANK.setFluid(new FluidStack((Fluid)FluidInit.LIQUID_OXYGEN.get(), nbt.m_128451_("oxygenAmount")));
        this.WATER_TANK.setFluid(new FluidStack(Fluids.f_76193_.m_5613_(), nbt.m_128451_("waterAmount")));
    }

    protected void write(CompoundTag nbt, boolean clientPacket) {
        nbt.m_128405_("oxygenAmount", this.OXYGEN_TANK.getFluidAmount());
        nbt.m_128405_("hydrogenAmount", this.HYDROGEN_TANK.getFluidAmount());
        nbt.m_128405_("waterAmount", this.WATER_TANK.getFluidAmount());
        super.write(nbt, clientPacket);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        LangBuilder mb = CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        LangBuilder mbs = CreateLang.translate((String)"generic.unit.fluidflow", (Object[])new Object[0]);
        CreateLang.translate((String)"gui.goggles.fluid_container", (Object[])new Object[0]).forGoggles(tooltip);
        for (int i = 0; i <= 2; ++i) {
            FluidTank tank = switch (i) {
                case 0 -> this.WATER_TANK;
                case 1 -> this.OXYGEN_TANK;
                case 2 -> this.HYDROGEN_TANK;
                default -> throw new IllegalStateException("Unexpected value: " + i);
            };
            String fluidName = switch (i) {
                case 0 -> Fluids.f_76193_.m_5613_().getFluidType().getDescriptionId();
                case 1 -> FluidInit.LIQUID_OXYGEN.getType().getDescriptionId();
                case 2 -> FluidInit.LIQUID_HYDROGEN.getType().getDescriptionId();
                default -> throw new IllegalStateException("Unexpected value: " + i);
            };
            FluidStack fluidStack = tank.getFluidInTank(0);
            CreateLang.builder().add(Component.m_237115_((String)fluidName)).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
            CreateLang.builder().add(CreateLang.number((double)fluidStack.getAmount()).add(mb).style(ChatFormatting.GOLD)).text(ChatFormatting.GRAY, " / ").add(CreateLang.number((double)tank.getTankCapacity(0)).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        }
        return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }

    private float waterConsumption(float speed) {
        return Math.abs(speed) * 1.0f * this.coefficient;
    }

    private float oxygenProduction(float speed) {
        return Math.abs(speed) * 32.0f / 36.0f * this.coefficient;
    }

    private float hydrogenProduction(float speed) {
        return Math.abs(speed) * 4.0f / 36.0f * this.coefficient;
    }
}

