/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.legacy.server.blockentities;

import com.rae.creatingspace.init.ingameobject.FluidInit;
import com.rae.creatingspace.legacy.server.blocks.RocketGeneratorBlock;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RocketGeneratorBlockEntity
extends GeneratingKineticBlockEntity {
    private static final int SYNC_RATE = 8;
    protected int syncCooldown;
    protected boolean queuedSync;
    private final LazyOptional<IFluidHandler> ofluidOptional = LazyOptional.of(() -> this.OXYGEN_TANK);
    private final FluidTank OXYGEN_TANK = new FluidTank(1000){

        protected void onContentsChanged() {
            super.onContentsChanged();
        }

        public boolean isFluidValid(FluidStack stack) {
            return stack.getRawFluid().m_6212_((Fluid)FluidInit.LIQUID_OXYGEN.get());
        }
    };
    private final LazyOptional<IFluidHandler> mfluidOptional = LazyOptional.of(() -> this.METHANE_TANK);
    private final FluidTank METHANE_TANK = new FluidTank(1000){

        protected void onContentsChanged() {
            super.onContentsChanged();
        }

        public boolean isFluidValid(FluidStack stack) {
            return stack.getRawFluid().m_6212_((Fluid)FluidInit.LIQUID_METHANE.get());
        }
    };

    public RocketGeneratorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void sendData() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        super.sendData();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    public void initialize() {
        super.initialize();
        if (!this.hasSource() || this.getGeneratedSpeed() > this.getTheoreticalSpeed()) {
            this.updateGeneratedRotation();
        }
    }

    public float getGeneratedSpeed() {
        if (((Boolean)this.m_58900_().m_61143_((Property)RocketGeneratorBlock.GENERATING)).booleanValue()) {
            return 64.0f;
        }
        return 0.0f;
    }

    protected void write(CompoundTag nbt, boolean clientPacket) {
        nbt.m_128405_("oxygenAmount", this.OXYGEN_TANK.getFluidAmount());
        nbt.m_128405_("methaneAmount", this.METHANE_TANK.getFluidAmount());
        super.write(nbt, clientPacket);
    }

    protected void read(CompoundTag nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        this.METHANE_TANK.setFluid(new FluidStack((Fluid)FluidInit.LIQUID_METHANE.get(), nbt.m_128451_("methaneAmount")));
        this.OXYGEN_TANK.setFluid(new FluidStack((Fluid)FluidInit.LIQUID_OXYGEN.get(), nbt.m_128451_("oxygenAmount")));
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            Direction localDir = (Direction)this.m_58900_().m_61143_((Property)RocketGeneratorBlock.H_FACING);
            if (localDir == side.m_175364_(Direction.Axis.Y)) {
                return this.ofluidOptional.cast();
            }
            if (localDir == side.m_175362_(Direction.Axis.Y)) {
                return this.mfluidOptional.cast();
            }
        }
        return super.getCapability(cap, side);
    }

    public void tick(Level level, BlockPos pos, BlockState state, RocketGeneratorBlockEntity blockEntity) {
        super.tick();
        if (!level.m_5776_()) {
            if (this.syncCooldown > 0) {
                --this.syncCooldown;
                if (this.syncCooldown == 0 && this.queuedSync) {
                    this.sendData();
                }
            }
            if (((Boolean)state.m_61143_((Property)RocketGeneratorBlock.GENERATING)).booleanValue()) {
                this.consumePropellant();
                if (this.OXYGEN_TANK.isEmpty() || this.METHANE_TANK.isEmpty()) {
                    BlockState newBlockState = (BlockState)state.m_61124_((Property)RocketGeneratorBlock.GENERATING, (Comparable)Boolean.valueOf(false));
                    level.m_46597_(pos, newBlockState);
                    this.updateGeneratedRotation();
                }
            }
        }
    }

    private void consumePropellant() {
        float o2Coef = 4000.0f / (float)FluidInit.LIQUID_OXYGEN.getType().getDensity();
        float methCoef = 1000.0f / (float)FluidInit.LIQUID_METHANE.getType().getDensity();
        int amount = 20;
        this.OXYGEN_TANK.drain((int)((float)amount * o2Coef), IFluidHandler.FluidAction.EXECUTE);
        this.METHANE_TANK.drain((int)((float)amount * methCoef), IFluidHandler.FluidAction.EXECUTE);
        this.sendData();
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        LangBuilder mb = CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        LangBuilder mbs = CreateLang.translate((String)"generic.unit.fluidflow", (Object[])new Object[0]);
        CreateLang.translate((String)"gui.goggles.fluid_container", (Object[])new Object[0]).forGoggles(tooltip);
        for (int i = 0; i <= 1; ++i) {
            FluidTank tank = switch (i) {
                case 0 -> this.OXYGEN_TANK;
                case 1 -> this.METHANE_TANK;
                default -> throw new IllegalStateException("Unexpected value: " + i);
            };
            String fluidName = switch (i) {
                case 0 -> FluidInit.LIQUID_OXYGEN.getType().getDescriptionId();
                case 1 -> FluidInit.LIQUID_METHANE.getType().getDescriptionId();
                default -> throw new IllegalStateException("Unexpected value: " + i);
            };
            FluidStack fluidStack = tank.getFluidInTank(0);
            CreateLang.builder().add(Component.m_237115_((String)fluidName)).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
            CreateLang.builder().add(CreateLang.number((double)fluidStack.getAmount()).add(mb).style(ChatFormatting.GOLD)).text(ChatFormatting.GRAY, " / ").add(CreateLang.number((double)tank.getTankCapacity(0)).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        }
        return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }
}

