/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.legacy.server.blockentities.atmosphere;

import com.rae.creatingspace.init.TagsInit;
import com.rae.creatingspace.init.ingameobject.BlockEntityInit;
import com.rae.creatingspace.init.ingameobject.BlockInit;
import com.rae.creatingspace.init.ingameobject.FluidInit;
import com.rae.creatingspace.legacy.server.blockentities.atmosphere.OxygenBlockEntity;
import com.rae.creatingspace.legacy.server.blocks.atmosphere.OxygenBlock;
import com.rae.creatingspace.legacy.server.blocks.atmosphere.SealerBlock;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SealerBlockEntity
extends KineticBlockEntity {
    public int o2amount = 0;
    public int prevO2amount = 0;
    private boolean trying = false;
    private boolean automaticRetry = false;
    public HashSet<BlockPos> oxygenBlockList = new HashSet();
    public int lastRoomSize = 0;
    public boolean roomIsSealed = false;
    private int remainingTries = 0;
    private int maxTries = 20;
    private int verificationCoolDown;
    private boolean oxygenBlockChange = false;
    private int range = 10;
    public FluidTank OXYGEN_TANK = new FluidTank(1000){

        protected void onContentsChanged() {
        }

        public boolean isFluidValid(FluidStack stack) {
            return TagsInit.CustomFluidTags.LIQUID_OXYGEN.matches(stack.getFluid());
        }
    };
    public LazyOptional<IFluidHandler> fluidOptional = LazyOptional.of(() -> this.OXYGEN_TANK);

    public void oxygenBlockChanged() {
        this.oxygenBlockChange = true;
    }

    public void setTrying(boolean trying) {
        this.trying = trying;
    }

    public void setAutomaticRetry(boolean automaticRetry) {
        this.automaticRetry = automaticRetry;
        this.m_6596_();
        this.sendData();
    }

    public boolean isAutomaticRetry() {
        return this.automaticRetry;
    }

    public boolean isTrying() {
        return this.trying;
    }

    public SealerBlockEntity(BlockEntityType<?> p_155228_, BlockPos p_155229_, BlockState p_155230_) {
        super(p_155228_, p_155229_, p_155230_);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        Direction localDir;
        if (cap == ForgeCapabilities.FLUID_HANDLER && (side == (localDir = (Direction)this.m_58900_().m_61143_((Property)SealerBlock.FACING)).m_122424_() || side == Direction.UP || side == Direction.DOWN)) {
            return this.fluidOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public Boolean isRoomSealable(Level level, BlockPos pos, BlockPos sealerPos, int distanceMax) {
        ArrayList<BlockPos> toVisit = new ArrayList<BlockPos>();
        if (!level.m_8055_(pos).m_60713_(Blocks.f_50016_)) {
            return true;
        }
        toVisit.add(0, pos);
        boolean test = true;
        while (test && !toVisit.isEmpty()) {
            if (this.distanceSquared(pos, sealerPos) > distanceMax * distanceMax) {
                test = false;
                continue;
            }
            pos = (BlockPos)toVisit.get(0);
            toVisit.remove(0);
            BlockState newBlock = (BlockState)BlockInit.OXYGEN.getDefaultState().m_61124_((Property)OxygenBlock.BREATHABLE, (Comparable)Boolean.valueOf(false));
            level.m_46597_(pos, newBlock);
            level.m_151523_((BlockEntity)new OxygenBlockEntity((BlockEntityType)BlockEntityInit.OXYGEN.get(), pos, newBlock));
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof OxygenBlockEntity) {
                OxygenBlockEntity oxygenBlockEntity = (OxygenBlockEntity)blockEntity;
                oxygenBlockEntity.setMasterPos(sealerPos);
            }
            this.oxygenBlockList.add(pos);
            for (Direction direction : Direction.values()) {
                BlockPos newPos = pos.m_121945_(direction);
                BlockState stateAtDir = level.m_8055_(newPos);
                if (!stateAtDir.m_60713_(Blocks.f_50016_)) continue;
                toVisit.add(0, newPos);
            }
        }
        this.oxygenBlockChange = false;
        return test;
    }

    public void unSealRoom() {
        this.roomIsSealed = false;
    }

    public void tick(Level level, BlockPos worldPos, BlockState sealerState) {
        if (!level.m_5776_()) {
            this.prevO2amount = this.o2amount;
            this.o2amount = this.OXYGEN_TANK.getFluidAmount();
            this.m_6596_();
            this.sendData();
            int nbrOfBlock = this.lastRoomSize;
            if (Math.abs(this.getSpeed()) >= (float)SealerBlockEntity.speedRequirement(nbrOfBlock) && this.OXYGEN_TANK.getFluidAmount() >= SealerBlockEntity.o2consumption(nbrOfBlock)) {
                if (this.trying || this.roomIsSealed) {
                    this.OXYGEN_TANK.drain(SealerBlockEntity.o2consumption(nbrOfBlock), IFluidHandler.FluidAction.EXECUTE);
                }
                this.tickSealingLogic(level, worldPos, sealerState);
            } else {
                this.unSealRoom();
                this.resetRemainingTries();
                this.removeO2inRoom(level);
                this.setTrying(this.automaticRetry);
            }
        }
        super.tick();
    }

    public void tickSealingLogic(Level level, BlockPos worldPos, BlockState sealerState) {
        if (!this.roomIsSealed && this.trying) {
            if (this.remainingTries > 0) {
                Direction facing = (Direction)sealerState.m_61143_((Property)SealerBlock.FACING);
                this.removeO2inRoom(level);
                boolean seal = level.m_8055_(worldPos.m_121945_(facing)).m_60713_(Blocks.f_50016_) ? this.isRoomSealable(level, worldPos.m_121945_(facing), worldPos, this.range) : true;
                if (seal) {
                    this.makeRoomBreathable(level, worldPos);
                } else {
                    --this.remainingTries;
                }
            } else {
                this.removeO2inRoom(level);
                if (!this.automaticRetry) {
                    this.setTrying(false);
                    AllSoundEvents.DENY.playAt(level, (Vec3i)worldPos, 0.4f, 1.0f, true);
                } else {
                    this.setTrying(true);
                    this.resetRemainingTries();
                }
            }
        } else if (this.roomIsSealed) {
            if (!this.trying) {
                if (this.oxygenBlockChange) {
                    this.verificationCoolDown = 0;
                    this.oxygenBlockChange = false;
                }
                if (this.verificationCoolDown > 0) {
                    --this.verificationCoolDown;
                } else {
                    this.verificationCoolDown = 80;
                    Direction facing = (Direction)sealerState.m_61143_((Property)SealerBlock.FACING);
                    this.removeO2inRoom(level);
                    boolean seal = this.isRoomSealable(level, worldPos.m_121945_(facing), worldPos, this.range);
                    if (!seal) {
                        this.unSealRoom();
                        this.resetRemainingTries();
                        this.removeO2inRoom(level);
                        this.setTrying(this.automaticRetry);
                    } else {
                        this.makeRoomBreathable(level, worldPos);
                    }
                }
            } else if (!this.isAutomaticRetry()) {
                this.unSealRoom();
                this.resetRemainingTries();
            }
        }
    }

    private void makeRoomBreathable(Level level, BlockPos worldPos) {
        for (BlockPos oxygenPos : this.oxygenBlockList) {
            BlockState state = level.m_8055_(oxygenPos);
            if (!(state.m_60734_() instanceof OxygenBlock)) continue;
            level.m_46597_(oxygenPos, (BlockState)state.m_61124_((Property)OxygenBlock.BREATHABLE, (Comparable)Boolean.valueOf(true)));
        }
        AllSoundEvents.CONFIRM.playAt(level, (Vec3i)worldPos, 0.4f, 1.0f, true);
        this.lastRoomSize = this.oxygenBlockList.size();
        this.roomIsSealed = true;
        this.setTrying(false);
        this.oxygenBlockChange = false;
    }

    protected void read(CompoundTag nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        this.roomIsSealed = nbt.m_128471_("roomIsSealed");
        this.automaticRetry = nbt.m_128471_("automaticRetry");
        this.trying = nbt.m_128471_("isTrying");
        this.lastRoomSize = nbt.m_128451_("lastRoomSize");
        this.range = nbt.m_128451_("range");
        this.remainingTries = nbt.m_128451_("remainingTries");
        this.maxTries = nbt.m_128451_("maxTries");
        this.verificationCoolDown = nbt.m_128451_("verificationCoolDown");
        this.oxygenBlockList = this.ListLongToPos(nbt.m_128467_("oxygenBlockPos"));
        this.o2amount = nbt.m_128451_("oxygenAmount");
        this.prevO2amount = nbt.m_128451_("prevO2amount");
        this.OXYGEN_TANK.setFluid(new FluidStack((Fluid)FluidInit.LIQUID_OXYGEN.get(), nbt.m_128451_("oxygenAmount")));
    }

    public void removeO2inRoom(Level level) {
        for (BlockPos oxygenPos : this.oxygenBlockList) {
            BlockState state = level.m_8055_(oxygenPos);
            if (!(state.m_60734_() instanceof OxygenBlock)) continue;
            level.m_46597_(oxygenPos, Blocks.f_50016_.m_49966_());
        }
        this.oxygenBlockList.clear();
    }

    protected void write(CompoundTag nbt, boolean clientPacket) {
        nbt.m_128379_("roomIsSealed", this.roomIsSealed);
        nbt.m_128379_("automaticRetry", this.automaticRetry);
        nbt.m_128379_("isTrying", this.trying);
        nbt.m_128405_("lastRoomSize", this.lastRoomSize);
        nbt.m_128405_("range", this.range);
        nbt.m_128405_("remainingTries", this.remainingTries);
        nbt.m_128405_("maxTries", this.maxTries);
        nbt.m_128405_("verificationCoolDown", this.verificationCoolDown);
        nbt.m_128405_("oxygenAmount", this.OXYGEN_TANK.getFluidAmount());
        nbt.m_128405_("prevO2amount", this.prevO2amount);
        nbt.m_128428_("oxygenBlockPos", this.ListPosToLong(this.oxygenBlockList));
        super.write(nbt, clientPacket);
    }

    private int distanceSquared(BlockPos pos1, BlockPos pos2) {
        return (pos1.m_123341_() - pos2.m_123341_()) * (pos1.m_123341_() - pos2.m_123341_()) + (pos1.m_123342_() - pos2.m_123342_()) * (pos1.m_123342_() - pos2.m_123342_()) + (pos1.m_123343_() - pos2.m_123343_()) * (pos1.m_123343_() - pos2.m_123343_());
    }

    public void resetRemainingTries() {
        this.remainingTries = this.maxTries;
    }

    private List<Long> ListPosToLong(HashSet<BlockPos> blockPosList) {
        ArrayList<Long> posList = new ArrayList<Long>();
        for (BlockPos pos : blockPosList) {
            posList.add(pos.m_121878_());
        }
        return posList;
    }

    private HashSet<BlockPos> ListLongToPos(long[] blockPosList) {
        HashSet<BlockPos> posList = new HashSet<BlockPos>();
        long[] lArray = blockPosList;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long posLong = lArray[i];
            posList.add(BlockPos.m_122022_((long)posLong));
        }
        return posList;
    }

    public static int speedRequirement(int nbrOfBlock) {
        int requirement = Math.max(nbrOfBlock / 20, 16);
        return Math.min(requirement, (Integer)AllConfigs.server().kinetics.maxRotationSpeed.get());
    }

    public static int o2consumption(int nbrOfBlock) {
        return Math.max(nbrOfBlock / 20, 1);
    }

    public void setSettings(int range, boolean isAutomaticRetry) {
        this.range = range;
        this.setAutomaticRetry(isAutomaticRetry);
    }

    public int getRange() {
        return this.range;
    }
}

