/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.legacy.utilities.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import com.rae.creatingspace.CreatingSpace;
import com.rae.creatingspace.legacy.utilities.data.SingleFileCodecJsonDataManager;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;

public class MassOfBlockReader {
    public static final UnboundedMapCodec<String, Integer> BLOCKS_MASS_CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.INT);
    public static final Codec<PartialMassMap> PARTIAL_BLOCKS_MASS_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("replace", (Object)false).forGetter(i -> i.replace), (App)BLOCKS_MASS_CODEC.fieldOf("values").forGetter(i -> i.massMap)).apply((Applicative)instance, PartialMassMap::new));
    public static final SingleFileCodecJsonDataManager<PartialMassMap> MASS_HOLDER = new SingleFileCodecJsonDataManager<PartialMassMap>("creatingspace_utilities", CreatingSpace.resource("blocks_mass"), PARTIAL_BLOCKS_MASS_CODEC, CreatingSpace.LOGGER);

    public static Map<TagKey<Block>, Integer> getOnlyTags(PartialMassMap data) {
        Map<String, Integer> rawMap = data.massMap();
        HashMap<TagKey<Block>, Integer> finalMap = new HashMap<TagKey<Block>, Integer>();
        for (String key : rawMap.keySet()) {
            if (!key.contains("#")) continue;
            String location = key.replace("#", "");
            ResourceLocation tagLocation = new ResourceLocation(location);
            TagKey blockTag = BlockTags.create((ResourceLocation)tagLocation);
            finalMap.put((TagKey<Block>)blockTag, rawMap.get(key));
        }
        return finalMap;
    }

    public static Map<ResourceLocation, Integer> getWithoutTags(PartialMassMap data) {
        Map<String, Integer> rawMap = data.massMap();
        HashMap<ResourceLocation, Integer> finalMap = new HashMap<ResourceLocation, Integer>();
        for (String key : rawMap.keySet()) {
            if (key.contains("#")) continue;
            ResourceLocation blockLocation = new ResourceLocation(key);
            finalMap.put(blockLocation, rawMap.get(key));
        }
        return finalMap;
    }

    public record PartialMassMap(boolean replace, Map<String, Integer> massMap) {
    }
}

