/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.mixin.entity;

import com.rae.creatingspace.init.ingameobject.BlockInit;
import com.rae.creatingspace.legacy.server.blocks.multiblock.BigRocketStructuralBlock;
import com.simibubi.create.content.contraptions.Contraption;
import java.util.Queue;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Contraption.class})
public class ContraptionMixin {
    @Unique
    private BlockPos local$Pos;

    @Inject(method={"moveBlock"}, at={@At(value="HEAD")}, remap=false)
    protected void gettingPos(Level world, Direction forcedDirection, @NotNull Queue<BlockPos> frontier, Set<BlockPos> visited, CallbackInfoReturnable<Boolean> cir) {
        this.local$Pos = frontier.peek();
    }

    @Inject(method={"moveBlock"}, at={@At(value="INVOKE", target="Lnet/minecraft/core/BlockPos;below()Lnet/minecraft/core/BlockPos;", shift=At.Shift.BEFORE)})
    protected void onMoveBlock(@NotNull Level world, Direction forcedDirection, Queue<BlockPos> frontier, Set<BlockPos> visited, CallbackInfoReturnable<Boolean> cir) {
        BlockPos nextPos;
        BlockState state = world.m_8055_(this.local$Pos);
        if (state.m_60713_((Block)BlockInit.BIG_ROCKET_ENGINE.get())) {
            this.moveBigRocketEngine(this.local$Pos, frontier, visited, state);
        } else if (state.m_60713_((Block)BlockInit.BIG_ENGINE_STRUCTURAL.get())) {
            BlockPos masterPos = BigRocketStructuralBlock.getMaster((BlockGetter)world, this.local$Pos, state);
            frontier.add(masterPos);
            this.moveBigRocketEngine(masterPos, frontier, visited, world.m_8055_(masterPos));
        }
        if (state.m_60713_((Block)BlockInit.SMALL_ROCKET_ENGINE.get()) || state.m_60713_((Block)BlockInit.ROCKET_ENGINE.get())) {
            nextPos = this.local$Pos.m_7495_();
            if (!visited.contains(nextPos)) {
                frontier.add(nextPos);
            }
        } else if ((state.m_60713_((Block)BlockInit.SMALL_ENGINE_STRUCTURAL.get()) || state.m_60713_((Block)BlockInit.ENGINE_STRUCTURAL.get())) && !visited.contains(nextPos = this.local$Pos.m_7494_())) {
            frontier.add(nextPos);
        }
    }

    private void moveBigRocketEngine(BlockPos pos, Queue<BlockPos> frontier, Set<BlockPos> visited, BlockState state) {
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos nextPos = pos.m_7918_(x, y, z);
                    if (visited.contains(nextPos)) continue;
                    frontier.add(nextPos);
                }
            }
        }
    }
}

