/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.mixin.recipe;

import com.rae.creatingspace.CreatingSpace;
import com.rae.creatingspace.configs.CSConfigs;
import com.rae.creatingspace.content.recipes.IMoreNbtConditions;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SequencedAssemblyRecipe.class})
public class SequencedAssemblyRecipeMixin
implements IMoreNbtConditions {
    @Unique
    public ArrayList<String> nbtKeys = new ArrayList();
    @Unique
    public ArrayList<String> matchNbtList = new ArrayList();

    @Override
    public void setKeepNbt(ArrayList<String> nbtKeys) {
        this.nbtKeys = nbtKeys;
    }

    @Override
    public ArrayList<String> getKeepNbt() {
        return this.nbtKeys;
    }

    @Override
    public void setMachNbt(ArrayList<String> machNbtList) {
        this.matchNbtList = machNbtList;
    }

    @Override
    public ArrayList<String> getMachNbt() {
        return this.matchNbtList;
    }

    @Override
    public boolean isKeepNbt() {
        return !this.nbtKeys.isEmpty();
    }

    @Override
    public boolean isMachNbt() {
        return !this.matchNbtList.isEmpty();
    }

    @Inject(method={"advance"}, at={@At(value="RETURN")}, cancellable=true, remap=false)
    public void addTagBack(ItemStack input, CallbackInfoReturnable<ItemStack> cir) {
        if (this.isKeepNbt()) {
            ItemStack advancedItem = (ItemStack)cir.getReturnValue();
            CompoundTag itemTag = advancedItem.m_41784_();
            CompoundTag toKeepTag = input.m_41784_();
            for (String key : this.nbtKeys) {
                Tag tag = toKeepTag.m_128423_(key);
                if (tag == null) continue;
                itemTag.m_128365_(key, Objects.requireNonNull(tag));
            }
            advancedItem.m_41751_(itemTag);
            cir.setReturnValue((Object)advancedItem);
        }
    }

    @Inject(method={"getRecipe(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/Container;Lnet/minecraft/world/item/crafting/RecipeType;Ljava/lang/Class;Ljava/util/function/Predicate;)Ljava/util/Optional;"}, at={@At(value="RETURN")}, remap=false)
    private static <C extends Container, R extends ProcessingRecipe<C>> void debugInfo(Level world, C inv, RecipeType<R> type, Class<R> recipeClass, Predicate<? super R> recipeFilter, CallbackInfoReturnable<Optional<R>> cir) {
        if (((Boolean)CSConfigs.COMMON.additionalLogInfo.get()).booleanValue()) {
            try {
                if (world.m_46467_() % 10L == 0L) {
                    CreatingSpace.LOGGER.info("getting possible recipe for :");
                    CreatingSpace.LOGGER.info("input : " + inv.m_8020_(0).serializeNBT());
                    CreatingSpace.LOGGER.info("adding : " + inv.m_8020_(1).serializeNBT());
                    for (ProcessingRecipe optional : SequencedAssemblyRecipe.getRecipes((Level)world, (ItemStack)inv.m_8020_(0), type, recipeClass).filter(recipeFilter).toList()) {
                        CreatingSpace.LOGGER.info("recipe id : " + optional.m_6423_());
                    }
                }
            }
            catch (Exception ignored) {
                CreatingSpace.LOGGER.error("crash while trying to print recipe log");
            }
        }
    }
}

