/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entities.tierheavy;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.util.AzureLibUtil;
import mod.azure.doom.MCDoom;
import mod.azure.doom.entities.DemonEntity;
import mod.azure.doom.entities.DoomAnimationsDefault;
import mod.azure.doom.entities.ai.DemonFloatControl;
import mod.azure.doom.entities.ai.goal.RandomFlyConvergeOnTargetGoal;
import mod.azure.doom.entities.task.DemonMeleeAttack;
import mod.azure.doom.entities.task.DemonProjectileAttack;
import mod.azure.doom.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StayWithinDistanceOfAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetPlayerLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetRandomLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.custom.UnreachableTargetSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import org.jetbrains.annotations.NotNull;

public class CacodemonEntity
extends DemonEntity
implements SmartBrainOwner<CacodemonEntity> {
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(CacodemonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);

    public CacodemonEntity(EntityType<? extends CacodemonEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new DemonFloatControl(this);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder m_21552_() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22280_, 0.25).m_22268_(Attributes.f_22276_, MCDoom.config.cacodemon_health).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22278_, (double)0.6f).m_22268_(Attributes.f_22282_, 0.0);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "livingController", 0, event -> {
            if (event.isMoving()) {
                return event.setAndContinue(DoomAnimationsDefault.WALKING);
            }
            if (this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_()) {
                return event.setAndContinue(DoomAnimationsDefault.DEATH);
            }
            return event.setAndContinue(DoomAnimationsDefault.IDLE);
        }).triggerableAnim("death", DoomAnimationsDefault.DEATH)}).add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 0, event -> PlayState.STOP).triggerableAnim("ranged", DoomAnimationsDefault.ATTACKING).triggerableAnim("melee", DoomAnimationsDefault.MELEE)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
    }

    @Override
    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariant());
    }

    public int getVariant() {
        return Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(VARIANT)), (int)1, (int)4);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public int getVariants() {
        return 4;
    }

    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor worldIn, @NotNull DifficultyInstance difficultyIn, @NotNull MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        int nextInt = this.m_217043_().m_216339_(0, 6);
        this.setVariant(nextInt);
        return spawnDataIn;
    }

    protected void m_8024_() {
        this.tickBrain((LivingEntity)this);
        super.m_8024_();
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Brain.Provider<?> m_5490_() {
        return new SmartBrainProvider((LivingEntity)this);
    }

    public List<ExtendedSensor<CacodemonEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new NearbyLivingEntitySensor().setPredicate((target, entity) -> target.m_6084_() && entity.m_142582_((Entity)target) && !(target instanceof DemonEntity)), new HurtBySensor(), new UnreachableTargetSensor()});
    }

    public BrainActivityGroup<CacodemonEntity> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new LookAtTarget(), new LookAtTargetSink(40, 300), new FloatToSurfaceOfFluid(), new StayWithinDistanceOfAttackTarget().speedMod(0.25f), new MoveToWalkTarget()});
    }

    public BrainActivityGroup<CacodemonEntity> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new FirstApplicableBehaviour(new ExtendedBehaviour[]{new TargetOrRetaliate().alertAlliesWhen((mob, entity) -> this.m_5912_()), new SetPlayerLookTarget().stopIf(target -> {
            Player player;
            return !target.m_6084_() || target instanceof Player && (player = (Player)target).m_7500_();
        }), new SetRandomLookTarget()}), new OneRandomBehaviour(new ExtendedBehaviour[]{new SetRandomWalkTarget().setRadius(20.0).speedModifier(1.0f), new Idle().runFor(entity -> entity.m_217043_().m_216339_(300, 600))})});
    }

    public BrainActivityGroup<CacodemonEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget().invalidateIf((target, entity) -> !target.m_6084_() || !entity.m_142582_((Entity)target)), new SetWalkTargetToAttackTarget().speedMod((owner, target) -> Float.valueOf(1.05f)), new DemonProjectileAttack<DemonEntity>(7).attackInterval(mob -> 80).attackDamage(MCDoom.config.cacodemon_ranged_damage), new DemonMeleeAttack(5)});
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new RandomFlyConvergeOnTargetGoal(this));
    }

    protected boolean m_8028_() {
        return true;
    }

    protected float m_6431_(@NotNull Pose poseIn, @NotNull EntityDimensions sizeIn) {
        return 1.0f;
    }

    protected void m_7840_(double y, boolean onGroundIn, @NotNull BlockState state, @NotNull BlockPos pos) {
    }

    public void m_7023_(@NotNull Vec3 movementInput) {
        if (this.m_20069_()) {
            this.m_19920_(0.02f, movementInput);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_((double)0.8f));
        } else if (this.m_20077_()) {
            this.m_19920_(0.02f, movementInput);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.5));
        } else {
            BlockPos ground = BlockPos.m_274561_((double)this.m_20185_(), (double)(this.m_20186_() - 1.0), (double)this.m_20189_());
            float f = 0.91f;
            if (this.m_20096_()) {
                f = this.m_9236_().m_8055_(ground).m_60734_().m_49958_() * 0.91f;
            }
            float f1 = 0.16277137f / (f * f * f);
            f = 0.91f;
            if (this.m_20096_()) {
                f = this.m_9236_().m_8055_(ground).m_60734_().m_49958_() * 0.91f;
            }
            this.m_19920_(this.m_20096_() ? 0.1f * f1 : 0.02f, movementInput);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_((double)f));
        }
    }

    public boolean m_6147_() {
        return false;
    }

    protected boolean shouldBurnInDay() {
        return false;
    }

    protected SoundEvent m_7515_() {
        return Services.SOUNDS_HELPER.getCACODEMON_AMBIENT();
    }

    protected SoundEvent m_7975_(@NotNull DamageSource damageSourceIn) {
        return Services.SOUNDS_HELPER.getCACODEMON_HURT();
    }

    protected SoundEvent m_5592_() {
        return Services.SOUNDS_HELPER.getCACODEMON_DEATH();
    }

    @Override
    protected float m_6121_() {
        return 1.0f;
    }

    public int m_5792_() {
        return 2;
    }
}

