/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entities.tierheavy;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.util.AzureLibUtil;
import mod.azure.doom.MCDoom;
import mod.azure.doom.entities.DemonEntity;
import mod.azure.doom.entities.DoomAnimationsDefault;
import mod.azure.doom.entities.task.DemonMeleeAttack;
import mod.azure.doom.entities.task.DemonProjectileAttack;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StrafeTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetPlayerLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetRandomLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.custom.UnreachableTargetSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import org.jetbrains.annotations.NotNull;

public class CarcassEntity
extends DemonEntity
implements SmartBrainOwner<CarcassEntity> {
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);

    public CarcassEntity(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder m_21552_() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22276_, MCDoom.config.carcass_health).m_22268_(Attributes.f_22278_, (double)0.6f).m_22268_(Attributes.f_22281_, MCDoom.config.carcass_melee_damage).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22282_, 0.0);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "livingController", 0, event -> {
            if (event.isMoving() && !this.m_5912_()) {
                return event.setAndContinue(DoomAnimationsDefault.WALKING);
            }
            if (event.isMoving() && this.m_5912_()) {
                return event.setAndContinue(DoomAnimationsDefault.RUN);
            }
            if (this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_()) {
                return event.setAndContinue(DoomAnimationsDefault.DEATH);
            }
            return event.setAndContinue(DoomAnimationsDefault.IDLE);
        }).triggerableAnim("death", DoomAnimationsDefault.DEATH)}).add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 0, event -> PlayState.STOP).triggerableAnim("melee", DoomAnimationsDefault.MELEE).triggerableAnim("ranged", DoomAnimationsDefault.RANGED)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected void m_8024_() {
        this.tickBrain((LivingEntity)this);
        super.m_8024_();
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Brain.Provider<?> m_5490_() {
        return new SmartBrainProvider((LivingEntity)this);
    }

    public List<ExtendedSensor<CarcassEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new NearbyLivingEntitySensor().setPredicate((target, entity) -> target.m_6084_() && entity.m_142582_((Entity)target) && !(target instanceof DemonEntity)), new HurtBySensor(), new UnreachableTargetSensor()});
    }

    public BrainActivityGroup<CarcassEntity> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new LookAtTarget(), new LookAtTargetSink(40, 300), new StrafeTarget().speedMod(0.25f), new FloatToSurfaceOfFluid(), new MoveToWalkTarget()});
    }

    public BrainActivityGroup<CarcassEntity> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new FirstApplicableBehaviour(new ExtendedBehaviour[]{new TargetOrRetaliate().alertAlliesWhen((mob, entity) -> this.m_5912_()), new SetPlayerLookTarget().stopIf(target -> {
            Player player;
            return !target.m_6084_() || target instanceof Player && (player = (Player)target).m_7500_();
        }), new SetRandomLookTarget()}), new OneRandomBehaviour(new ExtendedBehaviour[]{new SetRandomWalkTarget().setRadius(20.0).speedModifier(0.9f), new Idle().runFor(entity -> entity.m_217043_().m_216339_(300, 600))})});
    }

    public BrainActivityGroup<CarcassEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget().invalidateIf((target, entity) -> !target.m_6084_() || !entity.m_142582_((Entity)target)), new SetWalkTargetToAttackTarget().speedMod((owner, target) -> Float.valueOf(1.25f)), new DemonProjectileAttack<DemonEntity>(7).attackInterval(mob -> 20).attackDamage(MCDoom.config.cacodemon_ranged_damage), new DemonMeleeAttack(5)});
    }

    protected float m_6431_(@NotNull Pose poseIn, @NotNull EntityDimensions sizeIn) {
        return 1.0f;
    }
}

