/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.items.blockitems;

import java.util.function.Consumer;
import java.util.function.Supplier;
import mod.azure.azurelib.animatable.GeoItem;
import mod.azure.azurelib.animatable.client.RenderProvider;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.renderer.GeoItemRenderer;
import mod.azure.azurelib.util.AzureLibUtil;
import mod.azure.doom.client.render.item.GunCraftingItemRender;
import mod.azure.doom.client.render.item.TotemItemRender;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public abstract class DoomBlockItem
extends BlockItem
implements GeoItem {
    private final Supplier<Object> renderProvider = GeoItem.makeRenderer((GeoItem)this);
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    private String id;

    protected DoomBlockItem(Block block, Item.Properties properties, String id) {
        super(block, properties);
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "popup_controller", 0, state -> PlayState.CONTINUE)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public Supplier<Object> getRenderProvider() {
        return this.renderProvider;
    }

    public void createRenderer(Consumer<Object> consumer) {
        consumer.accept(new RenderProvider(){
            private GeoItemRenderer<?> renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    if (DoomBlockItem.this.getId().equalsIgnoreCase("gun_table")) {
                        this.renderer = new GunCraftingItemRender();
                    }
                    if (DoomBlockItem.this.getId().equalsIgnoreCase("totem")) {
                        this.renderer = new TotemItemRender();
                    }
                }
                return this.renderer;
            }
        });
    }
}

