/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.items.weapons;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mod.azure.azurelib.Keybindings;
import mod.azure.azurelib.animatable.GeoItem;
import mod.azure.azurelib.animatable.SingletonGeoAnimatable;
import mod.azure.azurelib.animatable.client.RenderProvider;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.Animation;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.platform.Services;
import mod.azure.azurelib.util.AzureLibUtil;
import mod.azure.doom.MCDoom;
import mod.azure.doom.client.render.weapons.MeleeRender;
import mod.azure.doom.entities.DemonEntity;
import mod.azure.doom.entities.tierboss.ArchMakyrEntity;
import mod.azure.doom.entities.tierboss.GladiatorEntity;
import mod.azure.doom.entities.tierboss.IconofsinEntity;
import mod.azure.doom.entities.tierboss.MotherDemonEntity;
import mod.azure.doom.entities.tierboss.SpiderMastermindEntity;
import mod.azure.doom.helper.CommonUtils;
import mod.azure.doom.items.enums.DoomTier;
import mod.azure.doom.items.enums.MeleeWeaponEnum;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public abstract class BaseSwordItem
extends SwordItem
implements GeoItem {
    private static final String controller = "controller";
    protected final MeleeWeaponEnum meleeWeaponEnum;
    private final Supplier<Object> renderProvider = GeoItem.makeRenderer((GeoItem)this);
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);

    protected BaseSwordItem(MeleeWeaponEnum meleeWeaponEnum, int maxUses) {
        super((Tier)DoomTier.DOOM_HIGHTEIR, 1, -2.5f, new Item.Properties().m_41487_(1).m_41503_(maxUses + 1));
        this.meleeWeaponEnum = meleeWeaponEnum;
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public static void reload(Player user, InteractionHand hand) {
        Item item = user.m_21120_(hand).m_41720_();
        if (item instanceof BaseSwordItem) {
            BaseSwordItem swordItem = (BaseSwordItem)item;
            while (!user.m_7500_() && user.m_21120_(hand).m_41773_() != 0 && user.m_150109_().m_18947_(swordItem.getAmmoType()) > 0) {
                CommonUtils.removeAmmo(swordItem.getAmmoType(), user);
                user.m_36335_().m_41524_((Item)swordItem, 5);
                user.m_21120_(hand).m_41622_(-5, (LivingEntity)user, s -> user.m_21190_(hand));
                user.m_21120_(hand).m_41754_(3);
            }
        }
    }

    public MeleeWeaponEnum getmeleeWeaponEnum() {
        return this.meleeWeaponEnum;
    }

    public Item getAmmoType() {
        switch (this.getmeleeWeaponEnum()) {
            case CHAINSAW: 
            case CHAINSAW_64: 
            case ETERNAL_CHAINSAW: {
                return mod.azure.doom.platform.Services.ITEMS_HELPER.getGasItem();
            }
            case MARAUDER_AXE: 
            case DARK_CRUCIBLE: 
            case CRUCIBLE: {
                return mod.azure.doom.platform.Services.ITEMS_HELPER.getArgentBlock();
            }
        }
        return mod.azure.doom.platform.Services.ITEMS_HELPER.getArgentEngery();
    }

    public void m_6883_(@NotNull ItemStack stack, Level level, @NotNull Entity entity, int slot, boolean selected) {
        Player playerentity = (Player)entity;
        if (!(level.f_46443_ || this.meleeWeaponEnum != MeleeWeaponEnum.CRUCIBLE && this.meleeWeaponEnum != MeleeWeaponEnum.DARK_CRUCIBLE)) {
            if (playerentity.m_21205_().m_150930_((Item)this) && selected) {
                this.triggerAnim((Entity)playerentity, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)((ServerLevel)level)), controller, "open");
            } else {
                this.triggerAnim((Entity)playerentity, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)((ServerLevel)level)), controller, "close");
            }
        }
        if (!level.f_46443_ && this.meleeWeaponEnum == MeleeWeaponEnum.ETERNAL_CHAINSAW) {
            this.triggerAnim((Entity)playerentity, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)((ServerLevel)level)), controller, "running");
        }
        if (level.f_46443_ && playerentity.m_21205_().m_41720_() instanceof BaseSwordItem && selected && Keybindings.RELOAD.m_90859_()) {
            mod.azure.doom.platform.Services.NETWORK.reloadMelee(slot);
        }
    }

    public boolean m_7579_(@NotNull ItemStack stack, @NotNull LivingEntity target, @NotNull LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Item item;
            Player playerentity = (Player)livingEntity;
            if (stack.m_41773_() < stack.m_41776_() - 1 && (item = playerentity.m_21205_().m_41720_()) instanceof BaseSwordItem) {
                BaseSwordItem swordItem = (BaseSwordItem)item;
                AABB aabb = new AABB(playerentity.m_20183_().m_7494_()).m_82377_(5.0, 5.0, 5.0);
                playerentity.m_9236_().m_45933_((Entity)playerentity, aabb).forEach(e -> this.doDamage(stack, (LivingEntity)playerentity, (Entity)e));
                if (swordItem.getmeleeWeaponEnum() == MeleeWeaponEnum.CHAINSAW || swordItem.getmeleeWeaponEnum() == MeleeWeaponEnum.CHAINSAW_64 || swordItem.getmeleeWeaponEnum() == MeleeWeaponEnum.ETERNAL_CHAINSAW) {
                    playerentity.m_9236_().m_45933_((Entity)playerentity, aabb).forEach(e -> this.doDeathCheck((LivingEntity)playerentity, (Entity)e, stack));
                    playerentity.m_9236_().m_45933_((Entity)playerentity, aabb).forEach(this::addParticle);
                }
                stack.m_41622_(1, (LivingEntity)playerentity, p -> p.m_21190_(playerentity.m_7655_()));
                if (swordItem.getmeleeWeaponEnum() == MeleeWeaponEnum.SENTINEL_HAMMER) {
                    AreaEffectCloud aoeEntity = new AreaEffectCloud(playerentity.m_9236_(), playerentity.m_20185_(), playerentity.m_20186_(), playerentity.m_20189_());
                    aoeEntity.m_19724_((ParticleOptions)ParticleTypes.f_123797_);
                    aoeEntity.m_19712_(5.0f);
                    aoeEntity.m_19734_(20);
                    aoeEntity.m_6034_(playerentity.m_20185_(), playerentity.m_20186_(), playerentity.m_20189_());
                    playerentity.m_9236_().m_7967_((Entity)aoeEntity);
                }
            }
        }
        return stack.m_41773_() < stack.m_41776_() - 1;
    }

    private void doDamage(ItemStack stack, LivingEntity user, Entity target) {
        if (target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            target.f_19802_ = 0;
            if (EnchantmentHelper.m_44843_((Enchantment)Services.PLATFORM.getIncendairyenchament(), (ItemStack)stack) > 0) {
                target.m_20254_(100);
            }
            switch (this.getmeleeWeaponEnum()) {
                case CHAINSAW: 
                case CHAINSAW_64: 
                case ETERNAL_CHAINSAW: {
                    target.m_6469_(user.m_269291_().m_269075_((Player)user), MCDoom.config.chainsaw_damage);
                    user.m_9236_().m_6263_(null, user.m_20185_(), user.m_20186_(), user.m_20189_(), mod.azure.doom.platform.Services.SOUNDS_HELPER.getCHAINSAW_ATTACKING(), SoundSource.PLAYERS, 0.3f, 1.0f / (user.m_9236_().f_46441_.m_188501_() * 0.4f + 1.2f) + 0.125f);
                    break;
                }
                case MARAUDER_AXE: {
                    target.m_6469_(user.m_269291_().m_269075_((Player)user), target instanceof ArchMakyrEntity || target instanceof GladiatorEntity || target instanceof IconofsinEntity || target instanceof MotherDemonEntity || target instanceof SpiderMastermindEntity ? MCDoom.config.marauder_axe_item_damage / 10.0f : MCDoom.config.marauder_axe_item_damage);
                    break;
                }
                case DARK_CRUCIBLE: {
                    target.m_6469_(user.m_269291_().m_269075_((Player)user), target instanceof ArchMakyrEntity || target instanceof GladiatorEntity || target instanceof IconofsinEntity || target instanceof MotherDemonEntity || target instanceof SpiderMastermindEntity ? MCDoom.config.darkcrucible_damage / 10.0f : MCDoom.config.darkcrucible_damage);
                    break;
                }
                case SENTINEL_HAMMER: {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 1000, 2));
                    target.m_6469_(user.m_269291_().m_269075_((Player)user), MCDoom.config.sentinelhammer_damage);
                    break;
                }
                case CRUCIBLE: {
                    target.m_6469_(user.m_269291_().m_269075_((Player)user), target instanceof ArchMakyrEntity || target instanceof GladiatorEntity || target instanceof IconofsinEntity || target instanceof MotherDemonEntity || target instanceof SpiderMastermindEntity ? MCDoom.config.crucible_damage / 10.0f : MCDoom.config.crucible_damage);
                }
            }
        }
    }

    private void doDeathCheck(LivingEntity user, Entity target, ItemStack stack) {
        block1: {
            List<Item> givenList = Arrays.asList(mod.azure.doom.platform.Services.ITEMS_HELPER.getChaingunBullets(), mod.azure.doom.platform.Services.ITEMS_HELPER.getShells(), mod.azure.doom.platform.Services.ITEMS_HELPER.getArgentBolts(), mod.azure.doom.platform.Services.ITEMS_HELPER.getEngeryCell(), mod.azure.doom.platform.Services.ITEMS_HELPER.getRocket());
            if (!(target instanceof DemonEntity) || !((LivingEntity)target).m_21224_() || !(user instanceof Player)) break block1;
            Player playerentity = (Player)user;
            if (stack.m_41773_() < stack.m_41776_() - 1 && !playerentity.m_36335_().m_41519_((Item)this)) {
                boolean i = false;
                int randomIndex = user.m_217043_().m_188503_(givenList.size());
                Item randomElement = givenList.get(randomIndex);
                target.m_19998_((ItemLike)randomElement);
            }
        }
    }

    private void addParticle(Entity target) {
        if (target instanceof LivingEntity) {
            target.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123784_, target.m_20208_(0.5), target.m_20187_(), target.m_20262_(0.5), 0.0, 0.0, 0.0);
        }
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 72000;
    }

    public void m_7373_(@NotNull ItemStack stack, Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        if (this.getmeleeWeaponEnum() == MeleeWeaponEnum.CHAINSAW || this.getmeleeWeaponEnum() == MeleeWeaponEnum.CHAINSAW_64 || this.getmeleeWeaponEnum() == MeleeWeaponEnum.ETERNAL_CHAINSAW) {
            tooltip.add((Component)Component.m_237115_((String)("Fuel: " + (stack.m_41776_() - stack.m_41773_() - 1) + " / " + (stack.m_41776_() - 1))).m_130940_(ChatFormatting.ITALIC));
        }
        if (this.getmeleeWeaponEnum() == MeleeWeaponEnum.DARK_CRUCIBLE || this.getmeleeWeaponEnum() == MeleeWeaponEnum.CRUCIBLE) {
            tooltip.add((Component)Component.m_237115_((String)"doom.crucible_sword.text").m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.ITALIC));
        }
        if (this.getmeleeWeaponEnum() == MeleeWeaponEnum.MARAUDER_AXE) {
            tooltip.add((Component)Component.m_237115_((String)"doom.marauder_axe1.text").m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.ITALIC));
            tooltip.add((Component)Component.m_237115_((String)"doom.marauder_axe2.text").m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.ITALIC));
            tooltip.add((Component)Component.m_237115_((String)"doom.marauder_axe3.text").m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.ITALIC));
        }
        if (this.getmeleeWeaponEnum() == MeleeWeaponEnum.SENTINEL_HAMMER || this.getmeleeWeaponEnum() == MeleeWeaponEnum.DARK_CRUCIBLE || this.getmeleeWeaponEnum() == MeleeWeaponEnum.CRUCIBLE || this.getmeleeWeaponEnum() == MeleeWeaponEnum.MARAUDER_AXE) {
            tooltip.add((Component)Component.m_237115_((String)("Ammo: " + (stack.m_41776_() - stack.m_41773_() - 1) + " / " + (stack.m_41776_() - 1))).m_130940_(ChatFormatting.ITALIC));
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public Supplier<Object> getRenderProvider() {
        return this.renderProvider;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, controller, event -> PlayState.CONTINUE).triggerableAnim("open", RawAnimation.begin().thenPlay("opening").thenLoop("open")).triggerableAnim("close", RawAnimation.begin().thenPlayAndHold("closed")).triggerableAnim("running", RawAnimation.begin().then("running", Animation.LoopType.LOOP))});
    }

    public void createRenderer(Consumer<Object> consumer) {
        consumer.accept(new RenderProvider(){
            private final MeleeRender<BaseSwordItem> renderer = null;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    return new MeleeRender(BaseSwordItem.this.getmeleeWeaponEnum());
                }
                return this.renderer;
            }
        });
    }
}

