/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.recipes;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import mod.azure.doom.MCDoom;
import mod.azure.doom.client.gui.DoomGunInventory;
import mod.azure.doom.platform.Services;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public record GunTableRecipe(ResourceLocation id, Pair<Ingredient, Integer>[] ingredients, ItemStack output) implements Recipe<DoomGunInventory>,
Comparable<GunTableRecipe>
{
    public static final ResourceLocation RECIPE_TYPE_ID = MCDoom.modResource("guns");

    public boolean matches(@NotNull DoomGunInventory inv, @NotNull Level world) {
        for (int i = 0; i < 5; ++i) {
            ItemStack slotStack = inv.m_8020_(i);
            Pair<Ingredient, Integer> pair = this.ingredients[i];
            Ingredient ingredient = (Ingredient)pair.getKey();
            Integer count = (Integer)pair.getRight();
            if (slotStack.m_41613_() >= count && ingredient.test(slotStack)) continue;
            return false;
        }
        return true;
    }

    public Ingredient getIngredientForSlot(int index) {
        return (Ingredient)this.ingredients[index].getLeft();
    }

    public int countRequired(int index) {
        return (Integer)this.ingredients[index].getRight();
    }

    @NotNull
    public ItemStack assemble(@NotNull DoomGunInventory inv, @NotNull RegistryAccess var2) {
        return this.m_8043_(var2).m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess var1) {
        return this.output;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return Services.PLATFORM.getRecipeSeializer();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    @Override
    public int compareTo(@NotNull GunTableRecipe o) {
        Item outputThis = this.output.m_41720_();
        Item outputOther = o.output.m_41720_();
        return BuiltInRegistries.f_257033_.m_7981_((Object)outputThis).compareTo(BuiltInRegistries.f_257033_.m_7981_((Object)outputOther));
    }

    public static class Type
    implements RecipeType<GunTableRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "gun_table";

        private Type() {
        }
    }

    public static class Serializer
    implements RecipeSerializer<GunTableRecipe> {
        private static List<Pair<Ingredient, Integer>> getIngredients(String pattern, Map<String, Pair<Ingredient, Integer>> keys, int width) {
            ArrayList<Pair<Ingredient, Integer>> pairList = new ArrayList<Pair<Ingredient, Integer>>();
            for (int i = 0; i < 5; ++i) {
                pairList.add(Pair.of((Object)Ingredient.f_43901_, (Object)0));
            }
            HashSet set = Sets.newHashSet(keys.keySet());
            set.remove(" ");
            for (int i = 0; i < pattern.length(); ++i) {
                String key = pattern.substring(i, i + 1);
                Ingredient ingredient = (Ingredient)keys.get(key).getKey();
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + key + "' but it's not defined in the key");
                }
                set.remove(key);
                pairList.set(i, (Pair<Ingredient, Integer>)Pair.of((Object)ingredient, (Object)((Integer)keys.get(key).getRight())));
            }
            if (!set.isEmpty()) {
                throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
            }
            return pairList;
        }

        private static Map<String, Pair<Ingredient, Integer>> getComponents(JsonObject json) {
            HashMap map = Maps.newHashMap();
            for (Map.Entry entry : json.entrySet()) {
                String key = (String)entry.getKey();
                JsonElement jsonElement = (JsonElement)entry.getValue();
                if (key.length() != 1) {
                    throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 String only).");
                }
                if (" ".equals(key)) {
                    throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
                }
                map.put(key, Pair.of((Object)Ingredient.m_43917_((JsonElement)jsonElement), (Object)GsonHelper.m_13824_((JsonObject)jsonElement.getAsJsonObject(), (String)"count", (int)1)));
            }
            map.put(" ", Pair.of((Object)Ingredient.f_43901_, (Object)0));
            return map;
        }

        @NotNull
        public GunTableRecipe fromJson(@NotNull ResourceLocation identifier, @NotNull JsonObject jsonObject) {
            Map<String, Pair<Ingredient, Integer>> map;
            String pattern = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"pattern");
            List<Pair<Ingredient, Integer>> pairList = Serializer.getIngredients(pattern, map = Serializer.getComponents(GsonHelper.m_13930_((JsonObject)jsonObject, (String)"key")), pattern.length());
            if (pairList.isEmpty()) {
                throw new JsonParseException("No ingredients for gun table recipe");
            }
            if (pairList.size() > 5) {
                throw new JsonParseException("Too many ingredients for gun table recipe");
            }
            ItemStack itemStack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"result"));
            return new GunTableRecipe(identifier, pairList.toArray(new Pair[0]), itemStack);
        }

        @NotNull
        public GunTableRecipe fromNetwork(@NotNull ResourceLocation identifier, @NotNull FriendlyByteBuf packetByteBuf) {
            Pair[] pairs = new Pair[5];
            for (int j = 0; j < 5; ++j) {
                Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)packetByteBuf);
                int count = packetByteBuf.readInt();
                pairs[j] = Pair.of((Object)ingredient, (Object)count);
            }
            ItemStack output = packetByteBuf.m_130267_();
            return new GunTableRecipe(identifier, pairs, output);
        }

        public void toNetwork(@NotNull FriendlyByteBuf packetByteBuf, @NotNull GunTableRecipe gunTableRecipe) {
            for (int i = 0; i < 5; ++i) {
                Pair<Ingredient, Integer> pair = gunTableRecipe.ingredients[i];
                Ingredient ingredient = (Ingredient)pair.getKey();
                Integer count = (Integer)pair.getRight();
                ingredient.m_43923_(packetByteBuf);
                packetByteBuf.writeInt(count.intValue());
            }
            packetByteBuf.m_130055_(gunTableRecipe.output);
        }
    }
}

