/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.fastpaintings;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.fastpaintings.PaintingBlock;
import net.mehvahdjukaar.fastpaintings.PaintingBlockEntity;
import net.mehvahdjukaar.moonlight.api.client.model.CustomBakedModel;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.PaintingTextureManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class PaintingBlockModel
implements CustomBakedModel {
    public static final ResourceLocation BACK_TEXTURE = new ResourceLocation("painting/back");
    private final BakedModel[] models = new BakedModel[16];

    public PaintingBlockModel(Map<String, BakedModel> paintingModels) {
        for (Map.Entry<String, BakedModel> e : paintingModels.entrySet()) {
            String k = e.getKey();
            int i = this.getIndex(k.contains("top"), k.contains("bottom"), k.contains("left"), k.contains("right"));
            this.models[i] = e.getValue();
        }
    }

    public int getIndex(boolean top, boolean bottom, boolean left, boolean right) {
        int index = 0;
        index |= (top ? 1 : 0) << 3;
        index |= (bottom ? 1 : 0) << 2;
        index |= (left ? 1 : 0) << 1;
        return index |= right ? 1 : 0;
    }

    public List<BakedQuad> getBlockQuads(BlockState state, Direction side, RandomSource rand, RenderType renderType, ExtraModelData data) {
        PaintingVariant variant = (PaintingVariant)data.get(PaintingBlockEntity.MIMIC_KEY);
        if (variant == null) {
            return List.of();
        }
        PaintingTextureManager paintingTextureManager = Minecraft.m_91087_().m_91305_();
        ResourceLocation paintingTexture = paintingTextureManager.m_235033_(variant).m_245424_().m_246162_();
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(new ResourceLocation(paintingTexture.m_135827_(), "painting/" + paintingTexture.m_135815_()));
        float segmentWScale = (float)sprite.m_245424_().m_246492_() / (float)variant.m_218908_();
        float segmentHScale = (float)sprite.m_245424_().m_245330_() / (float)variant.m_218909_();
        int rightOffset = (Integer)state.m_61143_((Property)PaintingBlock.RIGHT_OFFSET);
        int downOffset = (Integer)state.m_61143_((Property)PaintingBlock.DOWN_OFFSET);
        int paintingW = variant.m_218908_() / 16;
        int paintingH = variant.m_218909_() / 16;
        float spriteRightOff = (float)rightOffset * (sprite.m_118410_() - sprite.m_118409_()) / (float)paintingW;
        float spriteDownOff = (float)downOffset * (sprite.m_118412_() - sprite.m_118411_()) / (float)paintingH;
        ArrayList<BakedQuad> combinedQuads = new ArrayList<BakedQuad>();
        ArrayList<BakedModel> bakedModels = new ArrayList<BakedModel>();
        bakedModels.add(this.models[0]);
        int index = this.getIndex(downOffset == 0, downOffset == paintingH - 1, rightOffset == 0, rightOffset == paintingW - 1);
        bakedModels.add(this.models[index]);
        for (BakedModel model : bakedModels) {
            if (model == null) continue;
            List quads = model.m_213637_(null, side, rand);
            for (BakedQuad q : quads) {
                TextureAtlasSprite oldSprite = q.m_173410_();
                if (oldSprite.m_245424_().m_246162_().equals((Object)MissingTextureAtlasSprite.m_118071_())) {
                    int stride = DefaultVertexFormat.f_85811_.m_86017_();
                    int[] v = Arrays.copyOf(q.m_111303_(), q.m_111303_().length);
                    for (int i = 0; i < v.length / stride; ++i) {
                        float originalU = Float.intBitsToFloat(v[i * stride + 4]);
                        float originalV = Float.intBitsToFloat(v[i * stride + 5]);
                        float u1 = (originalU - oldSprite.m_118409_()) * segmentWScale + spriteRightOff;
                        v[i * stride + 4] = Float.floatToRawIntBits(u1 + sprite.m_118409_());
                        float v1 = (originalV - oldSprite.m_118411_()) * segmentHScale + spriteDownOff;
                        v[i * stride + 5] = Float.floatToRawIntBits(v1 + sprite.m_118411_());
                    }
                    combinedQuads.add(new BakedQuad(v, q.m_111305_(), q.m_111306_(), sprite, q.m_111307_()));
                    continue;
                }
                combinedQuads.add(q);
            }
        }
        return combinedQuads;
    }

    public ExtraModelData getModelData(@Nullable ExtraModelData originalTileData, BlockPos pos, BlockState state, BlockAndTintGetter level) {
        PaintingBlockEntity tile;
        if (state.m_60734_() instanceof PaintingBlock && !PaintingBlock.isMaster(state) && (tile = PaintingBlock.getMaster(state, pos, level)) != null) {
            return tile.getExtraModelData();
        }
        return originalTileData;
    }

    public TextureAtlasSprite getBlockParticle(ExtraModelData data) {
        return this.models[0].m_6160_();
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    public ItemTransforms m_7442_() {
        return ItemTransforms.f_111786_;
    }
}

