/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis;

import guideme.internal.shaded.lucene.analysis.TokenStream;
import guideme.internal.shaded.lucene.analysis.tokenattributes.CharTermAttribute;
import guideme.internal.shaded.lucene.analysis.tokenattributes.OffsetAttribute;
import guideme.internal.shaded.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import guideme.internal.shaded.lucene.analysis.tokenattributes.PositionLengthAttribute;
import guideme.internal.shaded.lucene.internal.hppc.IntArrayList;
import guideme.internal.shaded.lucene.internal.hppc.IntCursor;
import guideme.internal.shaded.lucene.internal.hppc.IntIntHashMap;
import guideme.internal.shaded.lucene.util.automaton.Automaton;
import guideme.internal.shaded.lucene.util.automaton.Operations;
import guideme.internal.shaded.lucene.util.automaton.Transition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class AutomatonToTokenStream {
    private AutomatonToTokenStream() {
    }

    public static TokenStream toTokenStream(Automaton automaton) {
        if (!Operations.isFinite(automaton)) {
            throw new IllegalArgumentException("Automaton must be finite");
        }
        ArrayList<IntArrayList> positionNodes = new ArrayList<IntArrayList>();
        Transition[][] transitions = automaton.getSortedTransitions();
        int[] indegree = new int[transitions.length];
        for (int i = 0; i < transitions.length; ++i) {
            for (int edge = 0; edge < transitions[i].length; ++edge) {
                int n = transitions[i][edge].dest;
                indegree[n] = indegree[n] + 1;
            }
        }
        if (indegree[0] != 0) {
            throw new IllegalArgumentException("Start node has incoming edges, creating cycle");
        }
        LinkedList<RemapNode> noIncomingEdges = new LinkedList<RemapNode>();
        IntIntHashMap idToPos = new IntIntHashMap();
        noIncomingEdges.addLast(new RemapNode(0, 0));
        while (!noIncomingEdges.isEmpty()) {
            RemapNode currState = (RemapNode)noIncomingEdges.removeFirst();
            for (int i = 0; i < transitions[currState.id].length; ++i) {
                int n = transitions[currState.id][i].dest;
                indegree[n] = indegree[n] - 1;
                if (indegree[transitions[currState.id][i].dest] != 0) continue;
                noIncomingEdges.addLast(new RemapNode(transitions[currState.id][i].dest, currState.pos + 1));
            }
            if (positionNodes.size() == currState.pos) {
                IntArrayList posIncs = new IntArrayList();
                posIncs.add(currState.id);
                positionNodes.add(posIncs);
            } else {
                ((IntArrayList)positionNodes.get(currState.pos)).add(currState.id);
            }
            idToPos.put(currState.id, currState.pos);
        }
        for (int i = 0; i < indegree.length; ++i) {
            if (indegree[i] == 0) continue;
            throw new IllegalArgumentException("Cycle found in automaton");
        }
        ArrayList<List<EdgeToken>> edgesByLayer = new ArrayList<List<EdgeToken>>();
        for (IntArrayList layer : positionNodes) {
            ArrayList<EdgeToken> edges = new ArrayList<EdgeToken>();
            for (IntCursor state : layer) {
                for (Transition t : transitions[state.value]) {
                    for (int val = t.min; val <= t.max; ++val) {
                        int destLayer = idToPos.get(t.dest);
                        edges.add(new EdgeToken(destLayer, val));
                        if (!automaton.isAccept(t.dest) || destLayer == positionNodes.size() - 1) continue;
                        edges.add(new EdgeToken(positionNodes.size() - 1, val));
                    }
                }
            }
            edgesByLayer.add(edges);
        }
        return new TopoTokenStream(edgesByLayer);
    }

    private static class RemapNode {
        public final int id;
        public final int pos;

        public RemapNode(int id, int pos) {
            this.id = id;
            this.pos = pos;
        }
    }

    private static class EdgeToken {
        public final int destination;
        public final int value;

        public EdgeToken(int destination, int value) {
            this.destination = destination;
            this.value = value;
        }
    }

    private static class TopoTokenStream
    extends TokenStream {
        private final List<List<EdgeToken>> edgesByPos;
        private int currentPos;
        private int currentEdgeIndex;
        private CharTermAttribute charAttr = this.addAttribute(CharTermAttribute.class);
        private PositionIncrementAttribute incAttr = this.addAttribute(PositionIncrementAttribute.class);
        private PositionLengthAttribute lenAttr = this.addAttribute(PositionLengthAttribute.class);
        private OffsetAttribute offAttr = this.addAttribute(OffsetAttribute.class);

        public TopoTokenStream(List<List<EdgeToken>> edgesByPos) {
            this.edgesByPos = edgesByPos;
        }

        @Override
        public boolean incrementToken() throws IOException {
            this.clearAttributes();
            while (this.currentPos < this.edgesByPos.size() && this.currentEdgeIndex == this.edgesByPos.get(this.currentPos).size()) {
                this.currentEdgeIndex = 0;
                ++this.currentPos;
            }
            if (this.currentPos == this.edgesByPos.size()) {
                return false;
            }
            EdgeToken currentEdge = this.edgesByPos.get(this.currentPos).get(this.currentEdgeIndex);
            this.charAttr.append((char)currentEdge.value);
            this.incAttr.setPositionIncrement(this.currentEdgeIndex == 0 ? 1 : 0);
            this.lenAttr.setPositionLength(currentEdge.destination - this.currentPos);
            this.offAttr.setOffset(this.currentPos, currentEdge.destination);
            ++this.currentEdgeIndex;
            return true;
        }

        @Override
        public void reset() throws IOException {
            super.reset();
            this.clearAttributes();
            this.currentPos = 0;
            this.currentEdgeIndex = 0;
        }

        @Override
        public void end() throws IOException {
            this.clearAttributes();
            this.incAttr.setPositionIncrement(0);
            this.offAttr.setOffset(this.edgesByPos.size() - 1, this.edgesByPos.size() - 1);
        }
    }
}

