/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search.comparators;

import guideme.internal.shaded.lucene.document.IntPoint;
import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.search.LeafFieldComparator;
import guideme.internal.shaded.lucene.search.Pruning;
import guideme.internal.shaded.lucene.search.comparators.NumericComparator;
import java.io.IOException;

public class IntComparator
extends NumericComparator<Integer> {
    private final int[] values;
    protected int topValue;
    protected int bottom;

    public IntComparator(int numHits, String field, Integer missingValue, boolean reverse, Pruning pruning) {
        super(field, missingValue != null ? missingValue : 0, reverse, pruning, 4);
        this.values = new int[numHits];
    }

    @Override
    public int compare(int slot1, int slot2) {
        return Integer.compare(this.values[slot1], this.values[slot2]);
    }

    @Override
    public void setTopValue(Integer value) {
        super.setTopValue(value);
        this.topValue = value;
    }

    @Override
    public Integer value(int slot) {
        return this.values[slot];
    }

    @Override
    public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
        return new IntLeafComparator(context);
    }

    public class IntLeafComparator
    extends NumericComparator.NumericLeafComparator {
        public IntLeafComparator(LeafReaderContext context) throws IOException {
            super(IntComparator.this, context);
        }

        private int getValueForDoc(int doc) throws IOException {
            if (this.docValues.advanceExact(doc)) {
                return (int)this.docValues.longValue();
            }
            return (Integer)IntComparator.this.missingValue;
        }

        @Override
        public void setBottom(int slot) throws IOException {
            IntComparator.this.bottom = IntComparator.this.values[slot];
            super.setBottom(slot);
        }

        @Override
        public int compareBottom(int doc) throws IOException {
            return Integer.compare(IntComparator.this.bottom, this.getValueForDoc(doc));
        }

        @Override
        public int compareTop(int doc) throws IOException {
            return Integer.compare(IntComparator.this.topValue, this.getValueForDoc(doc));
        }

        @Override
        public void copy(int slot, int doc) throws IOException {
            IntComparator.this.values[slot] = this.getValueForDoc(doc);
            super.copy(slot, doc);
        }

        @Override
        protected int compareMissingValueWithBottomValue() {
            return Integer.compare((Integer)IntComparator.this.missingValue, IntComparator.this.bottom);
        }

        @Override
        protected int compareMissingValueWithTopValue() {
            return Integer.compare((Integer)IntComparator.this.missingValue, IntComparator.this.topValue);
        }

        @Override
        protected void encodeBottom(byte[] packedValue) {
            IntPoint.encodeDimension(IntComparator.this.bottom, packedValue, 0);
        }

        @Override
        protected void encodeTop(byte[] packedValue) {
            IntPoint.encodeDimension(IntComparator.this.topValue, packedValue, 0);
        }
    }
}

