/*
 * Decompiled with CFR 0.152.
 */
package com.corrinedev.gundurability.init;

import com.corrinedev.gundurability.config.Config;
import com.corrinedev.gundurability.config.DurabilityItemHolder;
import com.corrinedev.gundurability.init.GundurabilityModBlocks;
import com.corrinedev.gundurability.item.RepairItem;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber
public class GundurabilityModItems {
    public static final HashMap<ResourceLocation, Item> REGISTRY = new HashMap();
    public static final DeferredRegister<Item> REPAIRTABLEREGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"gundurability");
    public static final RegistryObject<Item> REPAIR_TABLE = GundurabilityModItems.block(GundurabilityModBlocks.REPAIR_TABLE);

    private static RegistryObject<Item> block(RegistryObject<Block> block) {
        return REPAIRTABLEREGISTER.register(block.getId().m_135815_(), () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    @SubscribeEvent
    public static void register(RegisterEvent event) {
        event.register(ForgeRegistries.ITEMS.getRegistryKey(), items -> {
            for (DurabilityItemHolder holder : (List)Config.ITEMS.get()) {
                if (holder.gunTag() != null) {
                    ArrayList<String> gunIds = new ArrayList<String>();
                    for (JsonElement e : holder.gunTag().getAsJsonArray("gunIds")) {
                        gunIds.add(e.getAsString());
                    }
                    Pair pair = Pair.of((Object)holder.gunTag().getAsJsonPrimitive("tagName").getAsString(), gunIds);
                    RepairItem item = new RepairItem(holder.uses(), holder.durability(), holder.maxDurability(), holder.minDurability(), holder.slot(), (Pair<String, List<String>>)pair);
                    ResourceLocation resourceLocation = new ResourceLocation(holder.id());
                    REGISTRY.put(resourceLocation, item);
                    items.register(resourceLocation, (Object)item);
                    continue;
                }
                RepairItem item = new RepairItem(holder.uses(), holder.durability(), holder.maxDurability(), holder.minDurability(), holder.slot());
                ResourceLocation resourceLocation = new ResourceLocation(holder.id());
                REGISTRY.put(resourceLocation, item);
                items.register(resourceLocation, (Object)item);
            }
        });
    }
}

