/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.base.effects;

import dev.xkmc.l2library.base.effects.ForceAddEffectEvent;
import dev.xkmc.l2library.base.effects.api.ForceEffect;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;

public class EffectUtil {
    private static final ThreadLocal<AddReason> REASON = new ThreadLocal();
    private static final Set<EntityType<?>> INVALID = new HashSet();

    private static void forceAddEffect(LivingEntity e, MobEffectInstance ins, @Nullable Entity source) {
        if (INVALID.contains(e.m_6095_())) {
            return;
        }
        MobEffectInstance effectinstance = (MobEffectInstance)e.m_21221_().get(ins.m_19544_());
        ForceAddEffectEvent event = new ForceAddEffectEvent(e, ins);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return;
        }
        MinecraftForge.EVENT_BUS.post((Event)new MobEffectEvent.Added(e, effectinstance, ins, source));
        if (effectinstance == null) {
            try {
                e.m_21221_().put(ins.m_19544_(), ins);
            }
            catch (Exception ignored) {
                INVALID.add(e.m_6095_());
                return;
            }
            e.m_142540_(ins, source);
        } else if (effectinstance.m_19558_(ins)) {
            e.m_141973_(effectinstance, true, source);
        }
    }

    public static void addEffect(LivingEntity entity, MobEffectInstance ins, AddReason reason, @Nullable Entity source) {
        if (entity == source) {
            reason = AddReason.SELF;
        }
        if (ins.m_19544_() instanceof ForceEffect) {
            reason = AddReason.FORCE;
        }
        ins = new MobEffectInstance(ins.m_19544_(), ins.m_19557_(), ins.m_19564_(), ins.m_19571_(), reason != AddReason.FORCE && ins.m_19572_(), ins.m_19575_());
        REASON.set(reason);
        if (ins.m_19544_() instanceof ForceEffect) {
            EffectUtil.forceAddEffect(entity, ins, source);
        } else if (ins.m_19544_().m_8093_()) {
            ins.m_19544_().m_19461_(null, null, entity, ins.m_19564_(), 1.0);
        } else {
            entity.m_147207_(ins, source);
        }
        REASON.set(AddReason.NONE);
    }

    public static void refreshEffect(LivingEntity entity, MobEffectInstance ins, AddReason reason, Entity source) {
        MobEffectInstance cur;
        if (ins.f_19503_ < 40) {
            ins.f_19503_ = 40;
        }
        if ((cur = entity.m_21124_(ins.m_19544_())) == null || cur.m_19564_() < ins.m_19564_() || cur.m_19564_() == ins.m_19564_() && cur.m_19557_() < ins.m_19557_() / 2) {
            EffectUtil.addEffect(entity, ins, reason, source);
        }
    }

    public static void removeEffect(LivingEntity entity, Predicate<MobEffectInstance> pred) {
        Iterator itr = entity.f_20945_.values().iterator();
        while (itr.hasNext()) {
            MobEffectInstance effect = (MobEffectInstance)itr.next();
            if (!pred.test(effect) || MinecraftForge.EVENT_BUS.post((Event)new MobEffectEvent.Remove(entity, effect))) continue;
            entity.m_7285_(effect);
            itr.remove();
            entity.f_20948_ = true;
        }
    }

    public static AddReason getReason() {
        AddReason ans = REASON.get();
        return ans == null ? AddReason.NONE : ans;
    }

    public static enum AddReason {
        NONE,
        PROF,
        FORCE,
        SKILL,
        SELF;

    }
}

