/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lesraisinsarmor.network;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import me.xjqsh.lesraisinsarmor.network.s2c.ArmorDataMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkHandler {
    private static final String VERSION = "0.1.0";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("lrarmor", "network"), () -> "0.1.0", it -> it.equals(VERSION), it -> it.equals(VERSION));
    private static final AtomicInteger ID_COUNT = new AtomicInteger(1);

    public static void init() {
        CHANNEL.registerMessage(PacketId.S2C_ARMOR_DATA.value(), ArmorDataMessage.class, ArmorDataMessage::encode, ArmorDataMessage::decode, ArmorDataMessage::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    public static void sendToClientPlayer(Object message, Player player) {
        CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), message);
    }

    public static void sendToNearby(Level world, BlockPos pos, Object toSend) {
        if (world instanceof ServerLevel) {
            ServerLevel ws = (ServerLevel)world;
            ws.m_7726_().f_8325_.m_183262_(new ChunkPos(pos), false).stream().filter(p -> p.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) < 36864.0).forEach(p -> CHANNEL.send(PacketDistributor.PLAYER.with(() -> p), toSend));
        }
    }

    public static void sendToNearby(Entity entity, Object toSend, int distance) {
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel ws = (ServerLevel)level;
            BlockPos pos = entity.m_20183_();
            ws.m_7726_().f_8325_.m_183262_(new ChunkPos(pos), false).stream().filter(p -> p.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) < (double)(distance * distance)).forEach(p -> CHANNEL.send(PacketDistributor.PLAYER.with(() -> p), toSend));
        }
    }

    public static void sendToNearby(Entity entity, Object toSend) {
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel ws = (ServerLevel)level;
            BlockPos pos = entity.m_20183_();
            ws.m_7726_().f_8325_.m_183262_(new ChunkPos(pos), false).stream().filter(p -> p.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) < 36864.0).forEach(p -> CHANNEL.send(PacketDistributor.PLAYER.with(() -> p), toSend));
        }
    }

    static enum PacketId {
        S2C_ARMOR_DATA(100);

        private final int id;

        private PacketId(int id) {
            this.id = id;
        }

        int value() {
            return this.id;
        }
    }
}

