/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lrtactical.item.melee;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class AttributeData {
    private final List<AttributeInfo> attributes = new ArrayList<AttributeInfo>();

    public List<AttributeInfo> getAttributes() {
        return this.attributes;
    }

    public static class Deserializer
    implements JsonDeserializer<AttributeData> {
        public AttributeData deserialize(JsonElement element, Type type, JsonDeserializationContext ctx) throws JsonParseException {
            if (!element.isJsonObject()) {
                throw new JsonParseException("Expected a JsonObject, get " + element);
            }
            JsonObject jsonObject = (JsonObject)element;
            AttributeData attributeData = new AttributeData();
            for (Map.Entry entry : jsonObject.asMap().entrySet()) {
                String operationId;
                float amount;
                ResourceLocation id = ResourceLocation.m_135820_((String)((String)entry.getKey()));
                if (id == null) continue;
                if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                    JsonPrimitive primitive = ((JsonElement)entry.getValue()).getAsJsonPrimitive();
                    if (!primitive.isNumber()) continue;
                    amount = primitive.getAsFloat();
                    attributeData.attributes.add(new AttributeInfo(id, amount, AttributeModifier.Operation.ADDITION));
                    continue;
                }
                if (!((JsonElement)entry.getValue()).isJsonObject()) continue;
                JsonObject attributeObject = ((JsonElement)entry.getValue()).getAsJsonObject();
                amount = GsonHelper.m_13820_((JsonObject)attributeObject, (String)"amount", (float)0.0f);
                AttributeModifier.Operation operation = switch (operationId = GsonHelper.m_13851_((JsonObject)attributeObject, (String)"operation", (String)"addition")) {
                    case "addition" -> AttributeModifier.Operation.ADDITION;
                    case "percent" -> AttributeModifier.Operation.MULTIPLY_BASE;
                    case "multiply" -> AttributeModifier.Operation.MULTIPLY_TOTAL;
                    default -> AttributeModifier.Operation.ADDITION;
                };
                attributeData.attributes.add(new AttributeInfo(id, amount, operation));
            }
            return attributeData;
        }
    }

    public record AttributeInfo(@SerializedName(value="id") ResourceLocation id, @SerializedName(value="amount") float amount, @SerializedName(value="operation") AttributeModifier.Operation operation) {
    }
}

