/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lucent.core.mixin;

import com.legacy.lucent.core.capability.IEntityLightingData;
import com.legacy.lucent.core.dynamic_lighting.DynamicLightingEngine;
import com.legacy.lucent.core.dynamic_lighting.LightData;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@OnlyIn(value=Dist.CLIENT)
@Pseudo
@Mixin(value={EntityRenderer.class})
public class EntityRendererMixin {
    @Inject(at={@At(value="RETURN")}, method={"getPackedLightCoords(Lnet/minecraft/world/entity/Entity;F)I"}, cancellable=true)
    private void modifyLightValue(Entity entity, float eyePos, CallbackInfoReturnable<Integer> callback) {
        BlockPos pos = BlockPos.m_274446_((Position)entity.m_7371_(eyePos));
        LightData lightData = DynamicLightingEngine.getLightSource(pos);
        if (lightData != null) {
            int light = DynamicLightingEngine.calcLight((BlockAndTintGetter)entity.m_9236_(), entity.m_9236_().m_8055_(pos), pos, lightData);
            int entityLight = ((IEntityLightingData)entity).lucent$getBrightness();
            if (entityLight > 0) {
                light = Math.max(light, light >> 8 << 8 | entityLight << 4);
            }
            if (light > (Integer)callback.getReturnValue()) {
                callback.setReturnValue((Object)light);
            }
        }
    }
}

