/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.generator_extras.common.content.reactor;

import com.jerry.generator_extras.common.config.GenLoadConfig;
import com.jerry.generator_extras.common.genregistry.ExtraGenGases;
import com.jerry.generator_extras.common.item.ItemNquadahHohlraum;
import com.jerry.generator_extras.common.tile.reactor.TileEntityNaquadahReactorCasing;
import com.jerry.generator_extras.common.tile.reactor.TileEntityNaquadahReactorPort;
import com.jerry.mekanism_extras.common.ExtraTag;
import com.jerry.mekanism_extras.common.registry.ExtraGases;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.LongSupplier;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.heat.HeatAPI;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.api.math.MathUtils;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.chemical.multiblock.MultiblockChemicalTankBuilder;
import mekanism.common.capabilities.energy.VariableCapacityEnergyContainer;
import mekanism.common.capabilities.fluid.VariableCapacityFluidTank;
import mekanism.common.capabilities.heat.ITileHeatHandler;
import mekanism.common.capabilities.heat.VariableHeatCapacitor;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.SyntheticComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.sync.dynamic.ContainerSync;
import mekanism.common.lib.multiblock.IValveHandler;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.registries.MekanismGases;
import mekanism.common.tags.MekanismTags;
import mekanism.common.util.HeatUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import mekanism.generators.common.slot.ReactorInventorySlot;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class NaquadahReactorMultiblockData
extends MultiblockData
implements IValveHandler {
    public static final String HEAT_TAB = "heat";
    public static final String FUEL_TAB = "fuel";
    public static final String STATS_TAB = "stats";
    public static final int MAX_INJECTION = 98;
    private static final double burnTemperature = 4.0E8;
    private static final double burnRatio = 1.0;
    private static final double plasmaHeatCapacity = 100.0;
    private static final double caseHeatCapacity = 1.0;
    private static final double inverseInsulation = 100000.0;
    private static final double plasmaCaseConductivity = 0.2;
    private final Set<ITileHeatHandler> heatHandlers = new ObjectOpenHashSet();
    @ContainerSync
    private boolean burning = false;
    @ContainerSync
    public IEnergyContainer energyContainer;
    public IHeatCapacitor heatCapacitor;
    @ContainerSync(tags={"heat"})
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerFluidTankWrapper.class, methodNames={"getWater", "getWaterCapacity", "getWaterNeeded", "getWaterFilledPercentage"}, docPlaceholder="water tank")
    public IExtendedFluidTank waterTank;
    @ContainerSync(tags={"heat"})
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getSteam", "getSteamCapacity", "getSteamNeeded", "getSteamFilledPercentage"}, docPlaceholder="steam tank")
    public IGasTank steamTank;
    private double biomeAmbientTemp;
    @ContainerSync(tags={"heat"})
    private double lastPlasmaTemperature;
    @ContainerSync
    private double lastCaseTemperature;
    @ContainerSync
    @SyntheticComputerMethod(getter="getEnvironmentalLoss")
    public double lastEnvironmentLoss;
    @ContainerSync
    @SyntheticComputerMethod(getter="getTransferLoss")
    public double lastTransferLoss;
    @ContainerSync(tags={"fuel"})
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getNaquadah", "getNaquadahCapacity", "getNaquadahNeeded", "getNaquadahFilledPercentage"}, docPlaceholder="naquadah tank")
    public IGasTank naquadahTank;
    @ContainerSync(tags={"fuel"})
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getUranium", "getUraniumCapacity", "getUraniumNeeded", "getUraniumFilledPercentage"}, docPlaceholder="uranium tank")
    public IGasTank uraniumTank;
    @ContainerSync(tags={"fuel"})
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getNqUFuel", "getNqUFuelCapacity", "getNqUFuelNeeded", "getNqUFuelFilledPercentage"}, docPlaceholder="fuel tank")
    public IGasTank fuelTank;
    @ContainerSync(tags={"fuel", "heat", "stats"}, getter="getInjectionRate", setter="setInjectionRate")
    private int injectionRate = 2;
    @ContainerSync(tags={"fuel", "heat", "stats"})
    private long lastBurned;
    public double plasmaTemperature;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getHohlraum"}, docPlaceholder="Hohlraum slot")
    final ReactorInventorySlot reactorSlot;
    private boolean clientBurning;
    private double clientTemp;
    private int maxWater;
    private long maxSteam;
    private AABB deathZone;

    public NaquadahReactorMultiblockData(TileEntityNaquadahReactorCasing tile) {
        super((BlockEntity)tile);
        this.lastPlasmaTemperature = this.biomeAmbientTemp = HeatAPI.getAmbientTemp((LevelReader)tile.m_58904_(), (BlockPos)tile.getTilePos());
        this.lastCaseTemperature = this.biomeAmbientTemp;
        this.plasmaTemperature = this.biomeAmbientTemp;
        this.naquadahTank = (IGasTank)MultiblockChemicalTankBuilder.GAS.input((MultiblockData)this, (LongSupplier)GenLoadConfig.generatorConfig.reactorFuelCapacity, arg_0 -> ExtraTag.Gases.RICH_NAQUADAH_FUEL_LOOKUP.contains(arg_0), (IContentsListener)this);
        this.gasTanks.add(this.naquadahTank);
        this.uraniumTank = (IGasTank)MultiblockChemicalTankBuilder.GAS.input((MultiblockData)this, (LongSupplier)GenLoadConfig.generatorConfig.reactorFuelCapacity, arg_0 -> ExtraTag.Gases.RICH_URANIUM_FUEL_LOOKUP.contains(arg_0), (IContentsListener)this);
        this.gasTanks.add(this.uraniumTank);
        this.fuelTank = (IGasTank)MultiblockChemicalTankBuilder.GAS.input((MultiblockData)this, (LongSupplier)GenLoadConfig.generatorConfig.reactorFuelCapacity, arg_0 -> ExtraTag.Gases.NAQUADAH_URANIUM_FUEL_LOOKUP.contains(arg_0), this.createSaveAndComparator());
        this.gasTanks.add(this.fuelTank);
        this.steamTank = (IGasTank)MultiblockChemicalTankBuilder.GAS.output((MultiblockData)this, this::getMaxSteam, gas -> gas == ExtraGenGases.POLONIUM_CONTAINING_STEAM.getChemical() || gas == MekanismGases.STEAM.getChemical(), (IContentsListener)this);
        this.gasTanks.add(this.steamTank);
        this.waterTank = VariableCapacityFluidTank.input((MultiblockData)this, this::getMaxWater, fluid -> MekanismTags.Fluids.WATER_LOOKUP.contains((Object)fluid.getFluid()), (IContentsListener)this);
        this.fluidTanks.add(this.waterTank);
        this.energyContainer = VariableCapacityEnergyContainer.output((FloatingLongSupplier)GenLoadConfig.generatorConfig.reactorEnergyCapacity, (IContentsListener)this);
        this.energyContainers.add(this.energyContainer);
        this.heatCapacitor = VariableHeatCapacitor.create((double)1.0, NaquadahReactorMultiblockData::getInverseConductionCoefficient, () -> 100000.0, () -> this.biomeAmbientTemp, (IContentsListener)this);
        this.heatCapacitors.add(this.heatCapacitor);
        this.reactorSlot = ReactorInventorySlot.at(stack -> stack.m_41720_() instanceof ItemNquadahHohlraum, (IContentsListener)this, (int)80, (int)39);
        this.inventorySlots.add(this.reactorSlot);
    }

    public void onCreated(Level world) {
        super.onCreated(world);
        for (IValveHandler.ValveData data : this.valves) {
            BlockEntity tile = WorldUtils.getTileEntity((BlockGetter)world, (BlockPos)data.location);
            if (!(tile instanceof TileEntityNaquadahReactorPort)) continue;
            TileEntityNaquadahReactorPort port = (TileEntityNaquadahReactorPort)tile;
            this.heatHandlers.add((ITileHeatHandler)port);
        }
        this.biomeAmbientTemp = this.calculateAverageAmbientTemperature(world);
        this.deathZone = new AABB(this.getMinPos().m_7918_(1, 1, 1), this.getMaxPos());
    }

    public void readUpdateTag(CompoundTag tag) {
        super.readUpdateTag(tag);
        NBTUtils.setDoubleIfPresent((CompoundTag)tag, (String)"plasmaTemp", this::setLastPlasmaTemp);
        NBTUtils.setBooleanIfPresent((CompoundTag)tag, (String)"burning", this::setBurning);
    }

    public void writeUpdateTag(CompoundTag tag) {
        super.writeUpdateTag(tag);
        tag.m_128347_("plasmaTemp", this.getLastPlasmaTemp());
        tag.m_128379_("burning", this.isBurning());
    }

    public void addTemperatureFromEnergyInput(FloatingLong energyAdded) {
        if (this.isBurning()) {
            this.setPlasmaTemp(this.getPlasmaTemp() + energyAdded.divide(100.0).doubleValue());
        } else {
            this.setPlasmaTemp(this.getPlasmaTemp() + energyAdded.divide(100.0).multiply(10L).doubleValue());
        }
    }

    private boolean hasHohlraum() {
        IGasHandler gasHandlerItem;
        Optional capability;
        ItemStack hohlraum;
        if (!this.reactorSlot.isEmpty() && (hohlraum = this.reactorSlot.getStack()).m_41720_() instanceof ItemNquadahHohlraum && (capability = hohlraum.getCapability(Capabilities.GAS_HANDLER).resolve()).isPresent() && (gasHandlerItem = (IGasHandler)capability.get()).getTanks() > 0) {
            return ((GasStack)gasHandlerItem.getChemicalInTank(0)).getAmount() == gasHandlerItem.getTankCapacity(0);
        }
        return false;
    }

    public boolean tick(Level world) {
        boolean needsPacket = super.tick(world);
        long fuelBurned = 0L;
        if (this.getPlasmaTemp() >= 4.0E8) {
            if (!this.burning && this.hasHohlraum() && this.injectionRate >= 4) {
                this.vaporiseHohlraum();
            }
            if (this.isBurning()) {
                this.injectFuel();
                fuelBurned = this.burnFuel();
                if (fuelBurned == 0L) {
                    this.setBurning(false);
                }
            }
        } else {
            this.setBurning(false);
        }
        if (this.lastBurned != fuelBurned) {
            this.lastBurned = fuelBurned;
        }
        this.transferHeat();
        this.updateHeatCapacitors(null);
        this.updateTemperatures();
        if (this.isBurning()) {
            this.kill(world);
        }
        if (this.isBurning() != this.clientBurning || Math.abs(this.getLastPlasmaTemp() - this.clientTemp) > 1000000.0) {
            this.clientBurning = this.isBurning();
            this.clientTemp = this.getLastPlasmaTemp();
            needsPacket = true;
        }
        return needsPacket;
    }

    public void updateTemperatures() {
        this.lastPlasmaTemperature = this.getPlasmaTemp();
        this.lastCaseTemperature = this.heatCapacitor.getTemperature();
    }

    private void kill(Level world) {
        if (world.m_213780_().m_188502_() % 20 != 0) {
            return;
        }
        List entitiesToDie = this.getWorld().m_45976_(Entity.class, this.deathZone);
        for (Entity entity : entitiesToDie) {
            entity.m_6469_(entity.m_269291_().m_269425_(), 50000.0f);
        }
    }

    private void vaporiseHohlraum() {
        IGasHandler gasHandlerItem;
        ItemStack hohlraum = this.reactorSlot.getStack();
        Optional capability = hohlraum.getCapability(Capabilities.GAS_HANDLER).resolve();
        if (capability.isPresent() && (gasHandlerItem = (IGasHandler)capability.get()).getTanks() > 0) {
            this.fuelTank.insert((ChemicalStack)((GasStack)gasHandlerItem.getChemicalInTank(0)), Action.EXECUTE, AutomationType.INTERNAL);
            this.lastPlasmaTemperature = this.getPlasmaTemp();
            this.reactorSlot.setEmpty();
            this.setBurning(true);
        }
    }

    private void injectFuel() {
        long amountNeeded = this.fuelTank.getNeeded();
        long amountAvailable = 2L * Math.min(this.naquadahTank.getStored(), this.uraniumTank.getStored());
        long amountToInject = Math.min(amountNeeded, Math.min(amountAvailable, (long)this.injectionRate));
        amountToInject -= amountToInject % 2L;
        long injectingAmount = amountToInject / 2L;
        MekanismUtils.logMismatchedStackSize((long)this.naquadahTank.shrinkStack(injectingAmount, Action.EXECUTE), (long)injectingAmount);
        MekanismUtils.logMismatchedStackSize((long)this.uraniumTank.shrinkStack(injectingAmount, Action.EXECUTE), (long)injectingAmount);
        this.fuelTank.insert((ChemicalStack)ExtraGases.NAQUADAH_URANIUM_FUEL.getStack(amountToInject), Action.EXECUTE, AutomationType.INTERNAL);
    }

    private long burnFuel() {
        long fuelBurned = MathUtils.clampToLong((double)Mth.m_14008_((double)((this.lastPlasmaTemperature - 4.0E8) * 1.0), (double)0.0, (double)this.fuelTank.getStored()));
        MekanismUtils.logMismatchedStackSize((long)this.fuelTank.shrinkStack(fuelBurned, Action.EXECUTE), (long)fuelBurned);
        this.setPlasmaTemp(this.getPlasmaTemp() + ((FloatingLong)GenLoadConfig.generatorConfig.energyPerReactorFuel.get()).multiply(fuelBurned).divide(100.0).doubleValue());
        return fuelBurned;
    }

    private void transferHeat() {
        double caseWaterHeat;
        double plasmaCaseHeat = 0.2 * (this.lastPlasmaTemperature - this.lastCaseTemperature);
        if (Math.abs(plasmaCaseHeat) > (double)1.0E-6f) {
            this.setPlasmaTemp(this.getPlasmaTemp() - plasmaCaseHeat / 100.0);
            this.heatCapacitor.handleHeat(plasmaCaseHeat);
        }
        if (Math.abs(caseWaterHeat = GenLoadConfig.generatorConfig.reactorWaterHeatingRatio.get() * (this.lastCaseTemperature - this.biomeAmbientTemp)) > (double)1.0E-6f) {
            int waterToSteam = (int)(HeatUtils.getSteamEnergyEfficiency() * caseWaterHeat / HeatUtils.getWaterThermalEnthalpy());
            if ((waterToSteam = Math.min(waterToSteam, Math.min(this.waterTank.getFluidAmount(), MathUtils.clampToInt((long)this.steamTank.getNeeded())))) > 0) {
                MekanismUtils.logMismatchedStackSize((long)this.waterTank.shrinkStack(waterToSteam, Action.EXECUTE), (long)waterToSteam);
                if (this.isBurning()) {
                    this.steamTank.insert((ChemicalStack)ExtraGenGases.POLONIUM_CONTAINING_STEAM.getStack((long)waterToSteam), Action.EXECUTE, AutomationType.INTERNAL);
                } else {
                    this.steamTank.insert((ChemicalStack)MekanismGases.STEAM.getStack((long)waterToSteam), Action.EXECUTE, AutomationType.INTERNAL);
                }
                caseWaterHeat = (double)waterToSteam * HeatUtils.getWaterThermalEnthalpy() / HeatUtils.getSteamEnergyEfficiency();
                this.heatCapacitor.handleHeat(-caseWaterHeat);
            }
        }
        HeatAPI.HeatTransfer heatTransfer = this.simulate();
        this.lastEnvironmentLoss = heatTransfer.environmentTransfer();
        this.lastTransferLoss = heatTransfer.adjacentTransfer();
        double caseAirHeat = GenLoadConfig.generatorConfig.reactorCasingThermalConductivity.get() * (this.lastCaseTemperature - this.biomeAmbientTemp);
        if (Math.abs(caseAirHeat) > (double)1.0E-6f) {
            this.heatCapacitor.handleHeat(-caseAirHeat);
            this.energyContainer.insert(FloatingLong.create((double)(caseAirHeat * GenLoadConfig.generatorConfig.reactorThermocoupleEfficiency.get())), Action.EXECUTE, AutomationType.INTERNAL);
        }
    }

    @NotNull
    public HeatAPI.HeatTransfer simulate() {
        double environmentTransfer = 0.0;
        double adjacentTransfer = 0.0;
        for (ITileHeatHandler source : this.heatHandlers) {
            HeatAPI.HeatTransfer heatTransfer = source.simulate();
            adjacentTransfer += heatTransfer.adjacentTransfer();
            environmentTransfer += heatTransfer.environmentTransfer();
        }
        return new HeatAPI.HeatTransfer(adjacentTransfer, environmentTransfer);
    }

    public void setLastPlasmaTemp(double temp) {
        this.lastPlasmaTemperature = temp;
    }

    @ComputerMethod(nameOverride="getPlasmaTemperature")
    public double getLastPlasmaTemp() {
        return this.lastPlasmaTemperature;
    }

    @ComputerMethod(nameOverride="getCaseTemperature")
    public double getLastCaseTemp() {
        return this.lastCaseTemperature;
    }

    public double getPlasmaTemp() {
        return this.plasmaTemperature;
    }

    public void setPlasmaTemp(double temp) {
        if (this.plasmaTemperature != temp) {
            this.plasmaTemperature = temp;
            this.markDirty();
        }
    }

    @ComputerMethod
    public int getInjectionRate() {
        return this.injectionRate;
    }

    public void setInjectionRate(int rate) {
        if (this.injectionRate != rate) {
            this.injectionRate = rate;
            this.maxWater = this.injectionRate * GenLoadConfig.generatorConfig.reactorWaterPerInjection.get();
            this.maxSteam = (long)this.injectionRate * GenLoadConfig.generatorConfig.reactorSteamPerInjection.get();
            if (this.getWorld() != null && !this.isRemote()) {
                if (!this.waterTank.isEmpty()) {
                    this.waterTank.setStackSize(Math.min(this.waterTank.getFluidAmount(), this.waterTank.getCapacity()), Action.EXECUTE);
                }
                if (!this.steamTank.isEmpty()) {
                    this.steamTank.setStackSize(Math.min(this.steamTank.getStored(), this.steamTank.getCapacity()), Action.EXECUTE);
                }
            }
            this.markDirty();
        }
    }

    public int getMaxWater() {
        return this.maxWater;
    }

    public long getMaxSteam() {
        return this.maxSteam;
    }

    public boolean isBurning() {
        return this.burning;
    }

    public void setBurning(boolean burn) {
        if (this.burning != burn) {
            this.burning = burn;
            this.markDirty();
        }
    }

    public double getCaseTemp() {
        return this.heatCapacitor.getTemperature();
    }

    protected int getMultiblockRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents((long)this.fuelTank.getStored(), (long)this.fuelTank.getCapacity());
    }

    @ComputerMethod(methodDescription="true -> fissile cooled, false -> air cooled")
    public int getMinInjectionRate(boolean active) {
        double k = active ? GenLoadConfig.generatorConfig.reactorWaterHeatingRatio.get() : 0.0;
        double caseAirConductivity = GenLoadConfig.generatorConfig.reactorCasingThermalConductivity.get();
        double aMin = 8.0E7 * (k + caseAirConductivity) / (((FloatingLong)GenLoadConfig.generatorConfig.energyPerReactorFuel.get()).doubleValue() * 1.0 * (0.2 + k + caseAirConductivity) - 0.2 * (k + caseAirConductivity));
        return (int)(2.0 * Math.ceil(aMin / 2.0));
    }

    @ComputerMethod(methodDescription="true -> fissile cooled, false -> air cooled")
    public double getMaxPlasmaTemperature(boolean active) {
        double k = active ? GenLoadConfig.generatorConfig.reactorWaterHeatingRatio.get() : 0.0;
        double caseAirConductivity = GenLoadConfig.generatorConfig.reactorCasingThermalConductivity.get();
        long injectionRate = Math.max((long)this.injectionRate, this.lastBurned);
        return (double)injectionRate * ((FloatingLong)GenLoadConfig.generatorConfig.energyPerReactorFuel.get()).doubleValue() / 0.2 * (0.2 + k + caseAirConductivity) / (k + caseAirConductivity);
    }

    @ComputerMethod(methodDescription="true -> fissile cooled, false -> air cooled")
    public double getMaxCasingTemperature(boolean active) {
        double k = active ? GenLoadConfig.generatorConfig.reactorWaterHeatingRatio.get() : 0.0;
        long injectionRate = Math.max((long)this.injectionRate, this.lastBurned);
        return ((FloatingLong)GenLoadConfig.generatorConfig.energyPerReactorFuel.get()).multiply(injectionRate).divide(k + GenLoadConfig.generatorConfig.reactorCasingThermalConductivity.get()).doubleValue();
    }

    @ComputerMethod(methodDescription="true -> fissile cooled, false -> air cooled")
    public double getIgnitionTemperature(boolean active) {
        double k = active ? GenLoadConfig.generatorConfig.reactorWaterHeatingRatio.get() : 0.0;
        double caseAirConductivity = GenLoadConfig.generatorConfig.reactorCasingThermalConductivity.get();
        double energyPerReactorFuel = ((FloatingLong)GenLoadConfig.generatorConfig.energyPerReactorFuel.get()).doubleValue();
        return 4.0E8 * energyPerReactorFuel * 1.0 * (0.2 + k + caseAirConductivity) / (energyPerReactorFuel * 1.0 * (0.2 + k + caseAirConductivity) - 0.2 * (k + caseAirConductivity));
    }

    public FloatingLong getPassiveGeneration(boolean active, boolean current) {
        double temperature = current ? this.getLastCaseTemp() : this.getMaxCasingTemperature(active);
        return FloatingLong.create((double)(GenLoadConfig.generatorConfig.reactorThermocoupleEfficiency.get() * GenLoadConfig.generatorConfig.reactorCasingThermalConductivity.get() * temperature));
    }

    public long getSteamPerTick(boolean current) {
        double temperature = current ? this.getLastCaseTemp() : this.getMaxCasingTemperature(true);
        return MathUtils.clampToLong((double)(HeatUtils.getSteamEnergyEfficiency() * GenLoadConfig.generatorConfig.reactorWaterHeatingRatio.get() * temperature / HeatUtils.getWaterThermalEnthalpy()));
    }

    private static double getInverseConductionCoefficient() {
        return 1.0 / GenLoadConfig.generatorConfig.reactorCasingThermalConductivity.get();
    }

    @ComputerMethod(nameOverride="setInjectionRate")
    void computerSetInjectionRate(int rate) throws ComputerException {
        if (rate < 0 || rate > 98) {
            throw new ComputerException("Injection Rate '%d' is out of range must be an even number between 0 and %d. (Inclusive)", new Object[]{rate, 98});
        }
        if (rate % 2 != 0) {
            throw new ComputerException("Injection Rate '%d' must be an even number between 0 and %d. (Inclusive)", new Object[]{rate, 98});
        }
        this.setInjectionRate(rate);
    }

    @ComputerMethod
    FloatingLong getPassiveGeneration(boolean active) {
        return this.getPassiveGeneration(active, false);
    }

    @ComputerMethod
    FloatingLong getProductionRate() {
        return this.getPassiveGeneration(false, true);
    }
}

