/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.common.config;

import com.jerry.mekanism_extras.common.tier.BTier;
import com.jerry.mekanism_extras.common.tier.CTTier;
import com.jerry.mekanism_extras.common.tier.ECTier;
import com.jerry.mekanism_extras.common.tier.FTTier;
import com.jerry.mekanism_extras.common.tier.ICTier;
import com.jerry.mekanism_extras.common.tier.IPTier;
import com.jerry.mekanism_extras.common.util.ExtraEnumUtils;
import java.util.Locale;
import java.util.function.Predicate;
import mekanism.api.math.FloatingLong;
import mekanism.common.config.BaseMekanismConfig;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedBooleanValue;
import mekanism.common.config.value.CachedFloatingLongValue;
import mekanism.common.config.value.CachedIntValue;
import mekanism.common.config.value.CachedLongValue;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class ExtraConfig
extends BaseMekanismConfig {
    private final ForgeConfigSpec configSpec;
    public final CachedBooleanValue transmitterAlloyUpgrade;
    public final CachedFloatingLongValue absoluteUniversalCableCapacity;
    public final CachedFloatingLongValue supremeUniversalCableCapacity;
    public final CachedFloatingLongValue cosmicUniversalCableCapacity;
    public final CachedFloatingLongValue infiniteUniversalCableCapacity;
    public final CachedFloatingLongValue absoluteMechanicalPipeCapacity;
    public final CachedFloatingLongValue absoluteMechanicalPipePullAmount;
    public final CachedFloatingLongValue supremeMechanicalPipeCapacity;
    public final CachedFloatingLongValue supremeMechanicalPipePullAmount;
    public final CachedFloatingLongValue cosmicMechanicalPipeCapacity;
    public final CachedFloatingLongValue cosmicMechanicalPipePullAmount;
    public final CachedFloatingLongValue infiniteMechanicalPipeCapacity;
    public final CachedFloatingLongValue infiniteMechanicalPipePullAmount;
    public final CachedFloatingLongValue absolutePressurizedTubeCapacity;
    public final CachedFloatingLongValue absolutePressurizedTubePullAmount;
    public final CachedFloatingLongValue supremePressurizedTubeCapacity;
    public final CachedFloatingLongValue supremePressurizedTubePullAmount;
    public final CachedFloatingLongValue cosmicPressurizedTubeCapacity;
    public final CachedFloatingLongValue cosmicPressurizedTubePullAmount;
    public final CachedFloatingLongValue infinitePressurizedTubeCapacity;
    public final CachedFloatingLongValue infinitePressurizedTubePullAmount;
    public final CachedFloatingLongValue absoluteLogisticalTransporterSpeed;
    public final CachedFloatingLongValue absoluteLogisticalTransporterPullAmount;
    public final CachedFloatingLongValue supremeLogisticalTransporterSpeed;
    public final CachedFloatingLongValue supremeLogisticalTransporterPullAmount;
    public final CachedFloatingLongValue cosmicLogisticalTransporterSpeed;
    public final CachedFloatingLongValue cosmicLogisticalTransporterPullAmount;
    public final CachedFloatingLongValue infiniteLogisticalTransporterSpeed;
    public final CachedFloatingLongValue infiniteLogisticalTransporterPullAmount;
    public final CachedFloatingLongValue absoluteThermodynamicConductorConduction;
    public final CachedFloatingLongValue absoluteThermodynamicConductornCapacity;
    public final CachedFloatingLongValue absoluteThermodynamicConductornInsulation;
    public final CachedFloatingLongValue supremeThermodynamicConductorConduction;
    public final CachedFloatingLongValue supremeThermodynamicConductornCapacity;
    public final CachedFloatingLongValue supremeThermodynamicConductornInsulation;
    public final CachedFloatingLongValue cosmicThermodynamicConductorConduction;
    public final CachedFloatingLongValue cosmicThermodynamicConductornCapacity;
    public final CachedFloatingLongValue cosmicThermodynamicConductornInsulation;
    public final CachedFloatingLongValue infiniteThermodynamicConductorConduction;
    public final CachedFloatingLongValue infiniteThermodynamicConductornCapacity;
    public final CachedFloatingLongValue infiniteThermodynamicConductornInsulation;
    public final CachedLongValue radioactiveWasteBarrelMaxGas;
    public final CachedIntValue radioactiveWasteBarrelProcessTicks;
    public final CachedLongValue radioactiveWasteBarrelDecayAmount;
    public final CachedIntValue pumpHeavyWaterAmount;

    public ExtraConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("Config").push("mekanism_extras");
        String noteUC = "Internal buffer in Joules of each 'TIER' universal cable.(long)";
        builder.comment("Universal Cables").push("universal cables");
        this.absoluteUniversalCableCapacity = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Internal buffer in Joules of each 'TIER' universal cable.(long)", (String)"absoluteUniversalCable", (FloatingLong)FloatingLong.createConst((long)65536000L));
        this.supremeUniversalCableCapacity = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Internal buffer in Joules of each 'TIER' universal cable.(long)", (String)"supremeUniversalCable", (FloatingLong)FloatingLong.createConst((long)524288000L));
        this.cosmicUniversalCableCapacity = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Internal buffer in Joules of each 'TIER' universal cable.(long)", (String)"cosmicUniversalCable", (FloatingLong)FloatingLong.createConst((long)0xFA000000L));
        this.infiniteUniversalCableCapacity = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Internal buffer in Joules of each 'TIER' universal cable.(long)", (String)"infiniteUniversalCable", (FloatingLong)FloatingLong.createConst((long)0x7D0000000L));
        builder.pop();
        String noteMP = "Capacity of 'TIER' mechanical pipes in mB.(long)";
        String noteMP2 = "Pump rate of 'TIER' mechanical pipes in mB/t.(int)";
        builder.comment("Mechanical Pipes").push("mechanical pipes");
        this.absoluteMechanicalPipeCapacity = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Capacity of 'TIER' mechanical pipes in mB.(long)", (String)"absoluteMechanicalPipesCapacity", (FloatingLong)FloatingLong.createConst((long)1024000L));
        this.absoluteMechanicalPipePullAmount = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Pump rate of 'TIER' mechanical pipes in mB/t.(int)", (String)"absoluteMechanicalPipesPullAmount", (FloatingLong)FloatingLong.createConst((long)256000L));
        this.supremeMechanicalPipeCapacity = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Capacity of 'TIER' mechanical pipes in mB.(long)", (String)"supremeMechanicalPipesCapacity", (FloatingLong)FloatingLong.createConst((long)0x7D0000L));
        this.supremeMechanicalPipePullAmount = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Pump rate of 'TIER' mechanical pipes in mB/t.(int)", (String)"supremeMechanicalPipesPullAmount", (FloatingLong)FloatingLong.createConst((long)2048000L));
        this.cosmicMechanicalPipeCapacity = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Capacity of 'TIER' mechanical pipes in mB.(long)", (String)"cosmicMechanicalPipesCapacity", (FloatingLong)FloatingLong.createConst((long)65536000L));
        this.cosmicMechanicalPipePullAmount = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Pump rate of 'TIER' mechanical pipes in mB/t.(int)", (String)"cosmicMechanicalPipesPullAmount", (FloatingLong)FloatingLong.createConst((long)0xFA0000L));
        this.infiniteMechanicalPipeCapacity = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Capacity of 'TIER' mechanical pipes in mB.(long)", (String)"infiniteMechanicalPipesCapacity", (FloatingLong)FloatingLong.createConst((long)524288000L));
        this.infiniteMechanicalPipePullAmount = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Pump rate of 'TIER' mechanical pipes in mB/t.(int)", (String)"infiniteMechanicalPipesPullAmount", (FloatingLong)FloatingLong.createConst((long)0x7D00000L));
        builder.pop();
        String notePT = "Capacity of 'TIER' pressurized tubes in mB.(long)";
        String notePT2 = "Pump rate of 'TIER' pressurized tubes in mB/t.(long)";
        builder.comment("Pressurized Tubes").push("pressurized tubes");
        this.absolutePressurizedTubeCapacity = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Capacity of 'TIER' pressurized tubes in mB.(long)", (String)"absolutePressurizedTubesCapacity", (FloatingLong)FloatingLong.createConst((long)0x7D0000L));
        this.absolutePressurizedTubePullAmount = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Pump rate of 'TIER' pressurized tubes in mB/t.(long)", (String)"absolutePressurizedTubesPullAmount", (FloatingLong)FloatingLong.createConst((long)2048000L));
        this.supremePressurizedTubeCapacity = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Capacity of 'TIER' pressurized tubes in mB.(long)", (String)"supremePressurizedTubesCapacity", (FloatingLong)FloatingLong.createConst((long)65536000L));
        this.supremePressurizedTubePullAmount = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Pump rate of 'TIER' pressurized tubes in mB/t.(long)", (String)"supremePressurizedTubesPullAmount", (FloatingLong)FloatingLong.createConst((long)0xFA0000L));
        this.cosmicPressurizedTubeCapacity = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Capacity of 'TIER' pressurized tubes in mB.(long)", (String)"cosmicPressurizedTubesCapacity", (FloatingLong)FloatingLong.createConst((long)524288000L));
        this.cosmicPressurizedTubePullAmount = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Pump rate of 'TIER' pressurized tubes in mB/t.(long)", (String)"cosmicPressurizedTubesPullAmount", (FloatingLong)FloatingLong.createConst((long)0x7D00000L));
        this.infinitePressurizedTubeCapacity = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Capacity of 'TIER' pressurized tubes in mB.(long)", (String)"infinitePressurizedTubesCapacity", (FloatingLong)FloatingLong.createConst((long)0xFA000000L));
        this.infinitePressurizedTubePullAmount = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Pump rate of 'TIER' pressurized tubes in mB/t.(long)", (String)"infinitePressurizedTubesPullAmount", (FloatingLong)FloatingLong.createConst((long)1048576000L));
        builder.pop();
        String noteLT = "Five times the travel speed in m/s of 'TIER' logistical transporter.(int)";
        String noteLT2 = "Item throughput rate of 'TIER' logistical transporters in items/half second.(int)";
        builder.comment("Logistical Transporters").push("logistical transporters");
        this.absoluteLogisticalTransporterSpeed = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Five times the travel speed in m/s of 'TIER' logistical transporter.(int)", (String)"absoluteLogisticalTransporterSpeed", (FloatingLong)FloatingLong.createConst((long)55L));
        this.absoluteLogisticalTransporterPullAmount = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Item throughput rate of 'TIER' logistical transporters in items/half second.(int)", (String)"absoluteLogisticalTransporterPullAmount", (FloatingLong)FloatingLong.createConst((long)128L));
        this.supremeLogisticalTransporterSpeed = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Five times the travel speed in m/s of 'TIER' logistical transporter.(int)", (String)"supremeLogisticalTransporterSpeed", (FloatingLong)FloatingLong.createConst((long)60L));
        this.supremeLogisticalTransporterPullAmount = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Item throughput rate of 'TIER' logistical transporters in items/half second.(int)", (String)"supremeLogisticalTransporterPullAmount", (FloatingLong)FloatingLong.createConst((long)256L));
        this.cosmicLogisticalTransporterSpeed = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Five times the travel speed in m/s of 'TIER' logistical transporter.(int)", (String)"cosmicLogisticalTransporterSpeed", (FloatingLong)FloatingLong.createConst((long)70L));
        this.cosmicLogisticalTransporterPullAmount = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Item throughput rate of 'TIER' logistical transporters in items/half second.(int)", (String)"cosmicLogisticalTransporterPullAmount", (FloatingLong)FloatingLong.createConst((long)512L));
        this.infiniteLogisticalTransporterSpeed = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Five times the travel speed in m/s of 'TIER' logistical transporter.(int)", (String)"infiniteLogisticalTransporterSpeed", (FloatingLong)FloatingLong.createConst((long)100L));
        this.infiniteLogisticalTransporterPullAmount = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Item throughput rate of 'TIER' logistical transporters in items/half second.(int)", (String)"infiniteLogisticalTransporterPullAmount", (FloatingLong)FloatingLong.createConst((long)1024L));
        builder.pop();
        String noteTC = "Conduction value of 'TIER' thermodynamic conductors.(long)";
        String noteTC2 = "Heat capacity of 'TIER' thermodynamic conductors.(long)";
        String noteTC3 = "Insulation value of 'TIER' thermodynamic conductor(long).";
        builder.comment("Thermodynamic Conductors").push("thermodynamic conductors");
        this.absoluteThermodynamicConductorConduction = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Conduction value of 'TIER' thermodynamic conductors.(long)", (String)"absoluteThermodynamicConductorConduction", (FloatingLong)FloatingLong.createConst((long)10L));
        this.absoluteThermodynamicConductornCapacity = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Heat capacity of 'TIER' thermodynamic conductors.(long)", (String)"absoluteThermodynamicConductornCapacity", (FloatingLong)FloatingLong.createConst((double)1.0));
        this.absoluteThermodynamicConductornInsulation = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Insulation value of 'TIER' thermodynamic conductor(long).", (String)"absoluteThermodynamicConductornInsulation", (FloatingLong)FloatingLong.createConst((long)400000L));
        this.supremeThermodynamicConductorConduction = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Conduction value of 'TIER' thermodynamic conductors.(long)", (String)"supremeThermodynamicConductorConduction", (FloatingLong)FloatingLong.createConst((long)15L));
        this.supremeThermodynamicConductornCapacity = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Heat capacity of 'TIER' thermodynamic conductors.(long)", (String)"supremeThermodynamicConductornCapacity", (FloatingLong)FloatingLong.createConst((double)1.0));
        this.supremeThermodynamicConductornInsulation = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Insulation value of 'TIER' thermodynamic conductor(long).", (String)"supremeThermodynamicConductornInsulation", (FloatingLong)FloatingLong.createConst((long)800000L));
        this.cosmicThermodynamicConductorConduction = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Conduction value of 'TIER' thermodynamic conductors.(long)", (String)"cosmicThermodynamicConductorConduction", (FloatingLong)FloatingLong.createConst((long)20L));
        this.cosmicThermodynamicConductornCapacity = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Heat capacity of 'TIER' thermodynamic conductors.(long)", (String)"cosmicThermodynamicConductornCapacity", (FloatingLong)FloatingLong.createConst((double)1.0));
        this.cosmicThermodynamicConductornInsulation = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Insulation value of 'TIER' thermodynamic conductor(long).", (String)"cosmicThermodynamicConductornInsulation", (FloatingLong)FloatingLong.createConst((long)1000000L));
        this.infiniteThermodynamicConductorConduction = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Conduction value of 'TIER' thermodynamic conductors.(long)", (String)"infiniteThermodynamicConductorConduction", (FloatingLong)FloatingLong.createConst((long)25L));
        this.infiniteThermodynamicConductornCapacity = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Heat capacity of 'TIER' thermodynamic conductors.(long)", (String)"infiniteThermodynamicConductornCapacity", (FloatingLong)FloatingLong.createConst((double)1.0));
        this.infiniteThermodynamicConductornInsulation = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Insulation value of 'TIER' thermodynamic conductor(long).", (String)"infiniteThermodynamicConductornInsulation", (FloatingLong)FloatingLong.createConst((long)4000000L));
        builder.pop();
        builder.comment("Expand Radioactive Waste Barrel").push("expand radioactive waste barrel");
        this.radioactiveWasteBarrelMaxGas = CachedLongValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Amount of gas (mB) that can be stored in a Radioactive Waste Barrel.").defineInRange("radioactiveWasteBarrelMaxGas", 2048000L, 1L, Long.MAX_VALUE));
        this.radioactiveWasteBarrelProcessTicks = CachedIntValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Number of ticks required for radioactive gas stored in a Radioactive Waste Barrel to decay radioactiveWasteBarrelDecayAmount mB.").defineInRange("radioactiveWasteBarrelProcessTicks", 5, 1, Integer.MAX_VALUE));
        this.radioactiveWasteBarrelDecayAmount = CachedLongValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Number of mB of gas that decay every radioactiveWasteBarrelProcessTicks ticks when stored in a Radioactive Waste Barrel. Set to zero to disable decay all together. (Gases in the mekanism:waste_barrel_decay_blacklist tag will not decay).").defineInRange("radioactiveWasteBarrelDecayAmount", 4L, 0L, Long.MAX_VALUE));
        builder.pop();
        builder.comment("Alloy Upgrade").push("alloy upgrade");
        this.transmitterAlloyUpgrade = CachedBooleanValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Allow right clicking on Cables/Pipes/Tubes with alloys to upgrade the tier.").define("transmitterAlloyUpgrade", true));
        builder.pop();
        builder.comment("Advance Electric Pump").push("advance electric pump");
        this.pumpHeavyWaterAmount = CachedIntValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("mB of Heavy Water that is extracted per block of Water by the Electric Pump with a Filter Upgrade.").defineInRange("pumpHeavyWaterAmount", 1000, 1, 1000));
        builder.pop();
        this.addEnergyCubeCategory(builder);
        this.addFluidTankCategory(builder);
        this.addGasTankCategory(builder);
        this.addBinCategory(builder);
        this.addInductionCategory(builder);
        builder.pop();
        this.configSpec = builder.build();
    }

    private void addEnergyCubeCategory(ForgeConfigSpec.Builder builder) {
        builder.comment("Energy Cubes").push("energy cube");
        for (ECTier tier : ExtraEnumUtils.ENERGY_CUBE_TIERS) {
            String tierName = tier.getAdvanceTier().getSimpleName();
            CachedFloatingLongValue storageReference = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)("Maximum number of Joules " + tierName + " energy cubes can store."), (String)(tier.toString().toLowerCase() + "Storage"), (FloatingLong)tier.getAdvanceMaxEnergy(), (Predicate)CachedFloatingLongValue.POSITIVE);
            CachedFloatingLongValue outputReference = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)("Output rate in Joules of " + tierName + " energy cubes."), (String)(tier.toString().toLowerCase() + "Output"), (FloatingLong)tier.getAdvanceOutput(), (Predicate)CachedFloatingLongValue.POSITIVE);
            tier.setConfigReference(storageReference, outputReference);
        }
        builder.pop();
    }

    private void addFluidTankCategory(ForgeConfigSpec.Builder builder) {
        builder.comment("Fluid Tanks").push("fluid tanks");
        for (FTTier tier : ExtraEnumUtils.FLUID_TANK_TIERS) {
            String tierName = tier.getAdvanceTier().getSimpleName();
            CachedIntValue storageReference = CachedIntValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Storage size of " + tier.toString().toLowerCase() + " fluid tanks in mB.").defineInRange(tierName.toLowerCase(Locale.ROOT) + "Storage", tier.getAdvanceStorage(), 1, Integer.MAX_VALUE));
            CachedIntValue outputReference = CachedIntValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Output rate of " + tier.toString().toLowerCase() + " fluid tanks in mB.").defineInRange(tierName.toLowerCase(Locale.ROOT) + "Output", tier.getAdvanceOutput(), 1, Integer.MAX_VALUE));
            tier.setConfigReference(storageReference, outputReference);
        }
        builder.pop();
    }

    private void addGasTankCategory(ForgeConfigSpec.Builder builder) {
        builder.comment("Chemical Tanks").push("chemical tanks");
        for (CTTier tier : ExtraEnumUtils.CHEMICAL_TANK_TIERS) {
            String tierName = tier.getAdvanceTier().getSimpleName();
            CachedLongValue storageReference = CachedLongValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Storage size of " + tier.toString().toLowerCase() + " chemical tanks in mB.").defineInRange(tierName.toLowerCase(Locale.ROOT) + "Storage", tier.getAdvanceStorage(), 1L, Long.MAX_VALUE));
            CachedLongValue outputReference = CachedLongValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Output rate of " + tier.toString().toLowerCase() + " chemical tanks in mB.").defineInRange(tierName.toLowerCase(Locale.ROOT) + "Output", tier.getAdvanceOutput(), 1L, Long.MAX_VALUE));
            tier.setConfigReference(storageReference, outputReference);
        }
        builder.pop();
    }

    private void addBinCategory(ForgeConfigSpec.Builder builder) {
        builder.comment("Bins").push("bins");
        for (BTier tier : ExtraEnumUtils.BIN_TIERS) {
            String tierName = tier.getAdvanceTier().getSimpleName();
            CachedIntValue storageReference = CachedIntValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("The number of items " + tier.toString().toLowerCase() + " bins can store.").defineInRange(tierName.toLowerCase(Locale.ROOT) + "Storage", tier.getAdvanceStorage(), 1, Integer.MAX_VALUE));
            tier.setConfigReference(storageReference);
        }
        builder.pop();
    }

    private void addInductionCategory(ForgeConfigSpec.Builder builder) {
        String tierName;
        builder.comment("Induction").push("induction");
        for (ICTier iCTier : ExtraEnumUtils.INDUCTION_CELL_TIERS) {
            tierName = iCTier.getBaseTier().getSimpleName();
            CachedFloatingLongValue storageReference = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)("Maximum number of Joules " + iCTier.toString().toLowerCase() + " induction cells can store."), (String)(tierName.toLowerCase(Locale.ROOT) + "Storage"), (FloatingLong)iCTier.getBaseMaxEnergy(), (Predicate)CachedFloatingLongValue.POSITIVE);
            iCTier.setConfigReference(storageReference);
        }
        for (Enum enum_ : ExtraEnumUtils.INDUCTION_PROVIDER_TIERS) {
            tierName = ((IPTier)enum_).getBaseTier().getSimpleName();
            CachedFloatingLongValue outputReference = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)("Maximum number of Joules " + enum_.toString().toLowerCase() + " induction providers can output or accept."), (String)(tierName.toLowerCase(Locale.ROOT) + "Output"), (FloatingLong)((IPTier)enum_).getBaseOutput(), (Predicate)CachedFloatingLongValue.POSITIVE);
            ((IPTier)enum_).setConfigReference(outputReference);
        }
        builder.pop();
    }

    public String getFileName() {
        return "mekanism_extras";
    }

    public ForgeConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    public ModConfig.Type getConfigType() {
        return ModConfig.Type.SERVER;
    }
}

