/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.common.content.network.transmitter;

import com.jerry.mekanism_extras.api.IMixinLogisticalTransporterBase;
import com.jerry.mekanism_extras.common.content.network.transmitter.IExtraUpgradeableTransmitter;
import com.jerry.mekanism_extras.common.tier.transmitter.TPTier;
import com.jerry.mekanism_extras.common.tile.transmitter.ExtraTileEntityTransmitter;
import com.jerry.mekanism_extras.common.util.ExtraTransporterUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.text.EnumColor;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.content.network.InventoryNetwork;
import mekanism.common.content.network.transmitter.LogisticalTransporterBase;
import mekanism.common.content.network.transmitter.Transmitter;
import mekanism.common.content.transporter.PathfinderCache;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.lib.inventory.TransitRequest;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.network.to_client.PacketTransporterUpdate;
import mekanism.common.tier.TransporterTier;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.upgrade.transmitter.LogisticalTransporterUpgradeData;
import mekanism.common.upgrade.transmitter.TransmitterUpgradeData;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.TransporterUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ExtraLogisticalTransporter
extends LogisticalTransporterBase
implements IExtraUpgradeableTransmitter<LogisticalTransporterUpgradeData> {
    private EnumColor color;

    public ExtraLogisticalTransporter(IBlockProvider blockProvider, ExtraTileEntityTransmitter tile) {
        super((TileEntityTransmitter)tile, (TransporterTier)Attribute.getTier((IBlockProvider)blockProvider, TransporterTier.class));
    }

    public TransporterTier getTier() {
        return this.tier;
    }

    public EnumColor getColor() {
        return this.color;
    }

    public void setColor(EnumColor c) {
        this.color = c;
    }

    public InteractionResult onConfigure(Player player, Direction side) {
        ExtraTransporterUtils.incrementColor(this);
        PathfinderCache.onChanged((InventoryNetwork[])new InventoryNetwork[]{(InventoryNetwork)this.getTransmitterNetwork()});
        this.getTransmitterTile().sendUpdatePacket();
        EnumColor color = this.getColor();
        player.m_213846_(MekanismUtils.logFormat((Object)MekanismLang.TOGGLE_COLOR.translate(new Object[]{color == null ? MekanismLang.NONE : color.getColoredName()})));
        return InteractionResult.SUCCESS;
    }

    public InteractionResult onRightClick(Player player, Direction side) {
        EnumColor color = this.getColor();
        player.m_213846_(MekanismUtils.logFormat((Object)MekanismLang.CURRENT_COLOR.translate(new Object[]{color == null ? MekanismLang.NONE : color.getColoredName()})));
        return super.onRightClick(player, side);
    }

    public boolean isValidTransmitterBasic(TileEntityTransmitter transmitter, Direction side) {
        Transmitter transmitter2 = transmitter.getTransmitter();
        if (transmitter2 instanceof LogisticalTransporterBase) {
            LogisticalTransporterBase transporter = (LogisticalTransporterBase)transmitter2;
            if (this.getColor() == null || transporter.getColor() == null || this.getColor() == transporter.getColor()) {
                return super.isValidTransmitterBasic(transmitter, side);
            }
        }
        return false;
    }

    @Override
    @Nullable
    public LogisticalTransporterUpgradeData getUpgradeData() {
        return new LogisticalTransporterUpgradeData(this.redstoneReactive, this.getConnectionTypesRaw(), this.getColor(), this.transit, this.needsSync, this.nextId, this.delay, this.delayCount);
    }

    @Override
    public boolean dataTypeMatches(@Nonnull TransmitterUpgradeData data) {
        return data instanceof LogisticalTransporterUpgradeData;
    }

    @Override
    public void parseUpgradeData(@Nonnull LogisticalTransporterUpgradeData data) {
        this.redstoneReactive = data.redstoneReactive;
        this.setConnectionTypesRaw(data.connectionTypes);
        this.setColor(data.color);
        this.transit.putAll((Map)data.transit);
        this.needsSync.putAll((Map)data.needsSync);
        this.nextId = data.nextId;
        this.delay = data.delay;
        this.delayCount = data.delayCount;
    }

    protected void readFromNBT(CompoundTag nbtTags) {
        super.readFromNBT(nbtTags);
        NBTUtils.setEnumIfPresent((CompoundTag)nbtTags, (String)"color", ExtraTransporterUtils::readColor, this::setColor);
    }

    public void writeToNBT(CompoundTag nbtTags) {
        super.writeToNBT(nbtTags);
        nbtTags.m_128405_("color", ExtraTransporterUtils.getColorIndex(this.getColor()));
    }

    @Nonnull
    public CompoundTag getReducedUpdateTag(CompoundTag updateTag) {
        updateTag = super.getReducedUpdateTag(updateTag);
        updateTag.m_128405_("color", ExtraTransporterUtils.getColorIndex(this.getColor()));
        return updateTag;
    }

    public void handleUpdateTag(@Nonnull CompoundTag tag) {
        super.handleUpdateTag(tag);
        NBTUtils.setEnumIfPresent((CompoundTag)tag, (String)"color", ExtraTransporterUtils::readColor, this::setColor);
    }

    public void onUpdateClient() {
        for (TransporterStack stack : this.transit.values()) {
            stack.progress = Math.min(100, stack.progress + TPTier.getSpeed(this.tier));
        }
    }

    public void onUpdateServer() {
        if (this.getTransmitterNetwork() != null) {
            if (this.delay > 0) {
                --this.delay;
            } else {
                this.delay = 3;
                for (Direction side : this.getConnections(ConnectionType.PULL)) {
                    TransitRequest request;
                    BlockEntity tile = WorldUtils.getTileEntity((BlockGetter)this.getTileWorld(), (BlockPos)this.getTilePos().m_121945_(side));
                    if (tile == null || (request = TransitRequest.anyItem((BlockEntity)tile, (Direction)side.m_122424_(), (int)TPTier.getPullAmount(this.tier))).isEmpty()) continue;
                    TransitRequest.TransitResponse response = this.insert(tile, request, this.getColor(), true, 0);
                    if (response.isEmpty()) {
                        ++this.delayCount;
                        this.delay = Math.min(40, (int)Math.exp(this.delayCount));
                        continue;
                    }
                    response.useAll();
                    this.delay = 10;
                }
            }
            if (!this.transit.isEmpty()) {
                InventoryNetwork network = (InventoryNetwork)this.getTransmitterNetwork();
                IntOpenHashSet deletes = new IntOpenHashSet();
                for (Int2ObjectMap.Entry entry : this.transit.int2ObjectEntrySet()) {
                    ExtraLogisticalTransporter extraLogisticalTransporter;
                    boolean tryRecalculate;
                    ExtraLogisticalTransporter extraLogisticalTransporter2;
                    int stackId = entry.getIntKey();
                    TransporterStack stack = (TransporterStack)entry.getValue();
                    if (!stack.initiatedPath && (extraLogisticalTransporter2 = this) instanceof IMixinLogisticalTransporterBase) {
                        IMixinLogisticalTransporterBase mixLog = (IMixinLogisticalTransporterBase)((Object)extraLogisticalTransporter2);
                        if (stack.itemStack.m_41619_() || !mixLog.mekanismExtras$getRecalculate(stackId, stack, null)) {
                            deletes.add(stackId);
                            continue;
                        }
                    }
                    int prevProgress = stack.progress;
                    stack.progress += TPTier.getSpeed(this.tier);
                    if (stack.progress >= 100) {
                        ExtraLogisticalTransporter next;
                        ExtraLogisticalTransporter prevSet = null;
                        if (stack.hasPath()) {
                            int currentIndex = stack.getPath().indexOf(this.getTilePos());
                            if (currentIndex == 0) {
                                deletes.add(stackId);
                                continue;
                            }
                            next = (BlockPos)stack.getPath().get(currentIndex - 1);
                            if (next != null) {
                                BlockEntity tile;
                                if (!stack.isFinal((LogisticalTransporterBase)this)) {
                                    LogisticalTransporterBase transmitter = network.getTransmitter((BlockPos)next);
                                    if (stack.canInsertToTransporter(transmitter, stack.getSide((LogisticalTransporterBase)this), (LogisticalTransporterBase)this)) {
                                        if (transmitter instanceof IMixinLogisticalTransporterBase) {
                                            IMixinLogisticalTransporterBase mixTransmitter = (IMixinLogisticalTransporterBase)transmitter;
                                            mixTransmitter.mekanismExtras$getEntering(stack, stack.progress % 100);
                                        }
                                        deletes.add(stackId);
                                        continue;
                                    }
                                    prevSet = next;
                                } else if (stack.getPathType() != TransporterStack.Path.NONE && (tile = WorldUtils.getTileEntity((BlockGetter)this.getTileWorld(), (BlockPos)next)) != null) {
                                    TransitRequest.TransitResponse response = TransitRequest.simple((ItemStack)stack.itemStack).addToInventory(tile, stack.getSide((LogisticalTransporterBase)this), 0, stack.getPathType() == TransporterStack.Path.HOME);
                                    if (!response.isEmpty()) {
                                        ItemStack rejected = response.getRejected();
                                        if (rejected.m_41619_()) {
                                            TransporterManager.remove((Level)this.getTileWorld(), (TransporterStack)stack);
                                            deletes.add(stackId);
                                            continue;
                                        }
                                        stack.itemStack = rejected;
                                    }
                                    prevSet = next;
                                }
                            }
                        }
                        if (!((next = this) instanceof IMixinLogisticalTransporterBase)) continue;
                        IMixinLogisticalTransporterBase mixLog = (IMixinLogisticalTransporterBase)((Object)next);
                        if (!mixLog.mekanismExtras$getRecalculate(stackId, stack, (BlockPos)prevSet)) {
                            deletes.add(stackId);
                            continue;
                        }
                        if (prevSet == null) {
                            stack.progress = 50;
                            continue;
                        }
                        stack.progress = 0;
                        continue;
                    }
                    if (prevProgress >= 50 || stack.progress < 50) continue;
                    if (stack.isFinal((LogisticalTransporterBase)this)) {
                        Direction side;
                        ConnectionType connectionType;
                        TransporterStack.Path pathType = stack.getPathType();
                        tryRecalculate = pathType == TransporterStack.Path.DEST || pathType == TransporterStack.Path.HOME ? (connectionType = this.getConnectionType(side = stack.getSide((LogisticalTransporterBase)this))) != ConnectionType.NORMAL && connectionType != ConnectionType.PUSH || !TransporterUtils.canInsert((BlockEntity)WorldUtils.getTileEntity((BlockGetter)this.getTileWorld(), (BlockPos)stack.getDest()), (EnumColor)stack.color, (ItemStack)stack.itemStack, (Direction)side, (pathType == TransporterStack.Path.HOME ? 1 : 0) != 0) : pathType == TransporterStack.Path.NONE;
                    } else {
                        LogisticalTransporterBase nextTransmitter = network.getTransmitter(stack.getNext((LogisticalTransporterBase)this));
                        if (nextTransmitter == null && stack.getPathType() == TransporterStack.Path.NONE && stack.getPath().size() == 2) {
                            ConnectionType connectionType = this.getConnectionType(stack.getSide((LogisticalTransporterBase)this));
                            tryRecalculate = connectionType != ConnectionType.NORMAL && connectionType != ConnectionType.PUSH;
                        } else {
                            boolean bl = tryRecalculate = !stack.canInsertToTransporter(nextTransmitter, stack.getSide((LogisticalTransporterBase)this), (LogisticalTransporterBase)this);
                        }
                    }
                    if (!((extraLogisticalTransporter = this) instanceof IMixinLogisticalTransporterBase)) continue;
                    IMixinLogisticalTransporterBase mixLog = (IMixinLogisticalTransporterBase)((Object)extraLogisticalTransporter);
                    if (!tryRecalculate || mixLog.mekanismExtras$getRecalculate(stackId, stack, null)) continue;
                    deletes.add(stackId);
                }
                if (!deletes.isEmpty() || !this.needsSync.isEmpty()) {
                    Mekanism.packetHandler().sendToAllTracking((Object)new PacketTransporterUpdate((LogisticalTransporterBase)this, this.needsSync, (IntSet)deletes), (BlockEntity)this.getTransmitterTile());
                    deletes.forEach(arg_0 -> ((ExtraLogisticalTransporter)this).deleteStack(arg_0));
                    this.needsSync.clear();
                    this.getTransmitterTile().markForSave();
                }
            }
        }
    }
}

