/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.common.registry;

import com.jerry.mekanism_extras.api.ExtraUpgrade;
import com.jerry.mekanism_extras.api.tier.AdvancedTier;
import com.jerry.mekanism_extras.api.tier.ExtraAlloyTier;
import com.jerry.mekanism_extras.common.item.ExtraItemAlloy;
import com.jerry.mekanism_extras.common.item.ExtraItemQIODrive;
import com.jerry.mekanism_extras.common.item.ExtraItemTierInstaller;
import com.jerry.mekanism_extras.common.item.ItemAlloyRadiance;
import com.jerry.mekanism_extras.common.resource.ExtraResource;
import com.jerry.mekanism_extras.common.tier.ExtraQIODriverTier;
import java.util.Locale;
import mekanism.api.Upgrade;
import mekanism.common.item.ItemUpgrade;
import mekanism.common.registration.impl.ItemDeferredRegister;
import mekanism.common.registration.impl.ItemRegistryObject;
import mekanism.common.resource.ResourceType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtraItem {
    public static final ItemDeferredRegister EXTRA_ITEM = new ItemDeferredRegister("mekanism_extras");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"mekanism_extras");
    public static final ItemRegistryObject<ExtraItemQIODrive> COLLAPSE_QIO_DRIVE = ExtraItem.registryQIODrive(ExtraQIODriverTier.COLLAPSE);
    public static final ItemRegistryObject<ExtraItemQIODrive> GAMMA_QIO_DRIVE = ExtraItem.registryQIODrive(ExtraQIODriverTier.GAMMA);
    public static final ItemRegistryObject<ExtraItemQIODrive> BLACK_HOLE_QIO_DRIVE = ExtraItem.registryQIODrive(ExtraQIODriverTier.BLACK_HOLE);
    public static final ItemRegistryObject<ExtraItemQIODrive> SINGULARITY_QIO_DRIVE = ExtraItem.registryQIODrive(ExtraQIODriverTier.SINGULARITY);
    public static final ItemRegistryObject<ItemUpgrade> STACK = ExtraItem.registerUpgrade(ExtraUpgrade.STACK);
    public static final ItemRegistryObject<ItemUpgrade> IONIC_MEMBRANE = ExtraItem.registerUpgrade(ExtraUpgrade.IONIC_MEMBRANE);
    public static final ItemRegistryObject<ItemUpgrade> CREATIVE = ExtraItem.registerUpgrade(ExtraUpgrade.CREATIVE);
    public static final ItemRegistryObject<ExtraItemTierInstaller> ABSOLUTE_TIER_INSTALLER = ExtraItem.registerInstaller(null, AdvancedTier.ABSOLUTE);
    public static final ItemRegistryObject<ExtraItemTierInstaller> SUPREME_TIER_INSTALLER = ExtraItem.registerInstaller(AdvancedTier.ABSOLUTE, AdvancedTier.SUPREME);
    public static final ItemRegistryObject<ExtraItemTierInstaller> COSMIC_TIER_INSTALLER = ExtraItem.registerInstaller(AdvancedTier.SUPREME, AdvancedTier.COSMIC);
    public static final ItemRegistryObject<ExtraItemTierInstaller> INFINITE_TIER_INSTALLER = ExtraItem.registerInstaller(AdvancedTier.COSMIC, AdvancedTier.INFINITE);
    public static final ItemRegistryObject<Item> ABSOLUTE_CONTROL_CIRCUIT = ExtraItem.registerCircuit("absolute", Rarity.COMMON);
    public static final ItemRegistryObject<Item> SUPREME_CONTROL_CIRCUIT = ExtraItem.registerCircuit("supreme", Rarity.UNCOMMON);
    public static final ItemRegistryObject<Item> COSMIC_CONTROL_CIRCUIT = ExtraItem.registerCircuit("cosmic", Rarity.RARE);
    public static final ItemRegistryObject<Item> INFINITE_CONTROL_CIRCUIT = ExtraItem.registerCircuit("infinite", Rarity.EPIC);
    public static final ItemRegistryObject<Item> RADIANCE_ALLOY = EXTRA_ITEM.register("alloy_radiance", properties -> new ItemAlloyRadiance(properties.m_41497_(Rarity.COMMON)));
    public static final ItemRegistryObject<ExtraItemAlloy> THERMONUCLEAR_ALLOY = ExtraItem.registerAlloy(ExtraAlloyTier.THERMONUCLEAR, Rarity.UNCOMMON);
    public static final ItemRegistryObject<ExtraItemAlloy> SHINING_ALLOY = ExtraItem.registerAlloy(ExtraAlloyTier.SHINING, Rarity.RARE);
    public static final ItemRegistryObject<ExtraItemAlloy> SPECTRUM_ALLOY = ExtraItem.registerAlloy(ExtraAlloyTier.SPECTRUM, Rarity.EPIC);
    public static final ItemRegistryObject<Item> ENRICHED_OSMIUM = ExtraItem.registerEnriched("osmium", Rarity.COMMON);
    public static final ItemRegistryObject<Item> ENRICHED_LEAD = ExtraItem.registerEnriched("lead", Rarity.COMMON);
    public static final ItemRegistryObject<Item> ENRICHED_RADIANCE = ExtraItem.registerEnriched("radiance", Rarity.COMMON);
    public static final ItemRegistryObject<Item> ENRICHED_THERMONUCLEAR = ExtraItem.registerEnriched("thermonuclear", Rarity.UNCOMMON);
    public static final ItemRegistryObject<Item> ENRICHED_SHINING = ExtraItem.registerEnriched("shining", Rarity.RARE);
    public static final ItemRegistryObject<Item> ENRICHED_SPECTRUM = ExtraItem.registerEnriched("spectrum", Rarity.EPIC);
    public static final ItemRegistryObject<Item> DUST_RADIANCE = EXTRA_ITEM.register("dust_radiance");
    public static final ItemRegistryObject<Item> NAQUADAH_DUST = ExtraItem.registerResource(ResourceType.DUST);
    public static final ItemRegistryObject<Item> SHARD_NAQUADAH = ExtraItem.registerResource(ResourceType.SHARD);
    public static final ItemRegistryObject<Item> CRYSTAL_NAQUADAH = ExtraItem.registerResource(ResourceType.CRYSTAL);
    public static final ItemRegistryObject<Item> DIRTY_DUST_NAQUADAH = ExtraItem.registerResource(ResourceType.DIRTY_DUST);
    public static final ItemRegistryObject<Item> CLUMP_NAQUADAH = ExtraItem.registerResource(ResourceType.CLUMP);
    public static final ItemRegistryObject<Item> INGOT_NAQUADAH = ExtraItem.registerResource(ResourceType.INGOT);
    public static final ItemRegistryObject<Item> RAW_NAQUADAH = ExtraItem.registerResource(ResourceType.RAW);

    private static ItemRegistryObject<ExtraItemQIODrive> registryQIODrive(ExtraQIODriverTier tier) {
        return EXTRA_ITEM.register("qio_drive_" + tier.name().toLowerCase(Locale.ROOT), properties -> new ExtraItemQIODrive(tier, (Item.Properties)properties));
    }

    private static ItemRegistryObject<ItemUpgrade> registerUpgrade(Upgrade type) {
        return EXTRA_ITEM.register("upgrade_" + type.getRawName(), properties -> new ItemUpgrade(type, properties));
    }

    private static ItemRegistryObject<ExtraItemTierInstaller> registerInstaller(@Nullable AdvancedTier fromTier, @NotNull AdvancedTier toTier) {
        return EXTRA_ITEM.register(toTier.getLowerName() + "_tier_installer", properties -> new ExtraItemTierInstaller(fromTier, toTier, (Item.Properties)properties));
    }

    private static ItemRegistryObject<Item> registerCircuit(String name, Rarity rarity) {
        return EXTRA_ITEM.register(name + "_control_circuit", properties -> new Item(properties.m_41497_(rarity)));
    }

    private static ItemRegistryObject<ExtraItemAlloy> registerAlloy(ExtraAlloyTier tier, Rarity rarity) {
        return EXTRA_ITEM.register("alloy_" + tier.getName(), properties -> new ExtraItemAlloy(tier, properties.m_41497_(rarity)));
    }

    private static ItemRegistryObject<Item> registerEnriched(String name, Rarity rarity) {
        return EXTRA_ITEM.register("enriched_" + name, properties -> new Item(properties.m_41497_(rarity)));
    }

    private static ItemRegistryObject<Item> registerResource(ResourceType type) {
        return EXTRA_ITEM.register(type.getRegistryPrefix() + "_" + ExtraResource.NAQUADAH.getRegistrySuffix());
    }

    public static void register(IEventBus eventBus) {
        EXTRA_ITEM.register(eventBus);
    }
}

