/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.common.registry;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.jerry.mekanism_extras.common.registry.ExtraBlock;
import com.jerry.mekanism_extras.common.tier.AdvancedFactoryTier;
import com.jerry.mekanism_extras.common.tile.ExtraTileEntityBin;
import com.jerry.mekanism_extras.common.tile.ExtraTileEntityChemicalTank;
import com.jerry.mekanism_extras.common.tile.ExtraTileEntityEnergyCube;
import com.jerry.mekanism_extras.common.tile.ExtraTileEntityFluidTank;
import com.jerry.mekanism_extras.common.tile.ExtraTileEntityRadioactiveWasteBarrel;
import com.jerry.mekanism_extras.common.tile.factory.TileEntityCombiningExtraFactory;
import com.jerry.mekanism_extras.common.tile.factory.TileEntityExtraFactory;
import com.jerry.mekanism_extras.common.tile.factory.TileEntityItemStackGasToItemStackExtraFactory;
import com.jerry.mekanism_extras.common.tile.factory.TileEntityItemStackToItemStackExtraFactory;
import com.jerry.mekanism_extras.common.tile.factory.TileEntityMetallurgicInfuserExtraFactory;
import com.jerry.mekanism_extras.common.tile.factory.TileEntitySawingExtraFactory;
import com.jerry.mekanism_extras.common.tile.machine.TileEntityAdvancedElectricPump;
import com.jerry.mekanism_extras.common.tile.multiblock.ExtraTileEntityInductionCell;
import com.jerry.mekanism_extras.common.tile.multiblock.ExtraTileEntityInductionProvider;
import com.jerry.mekanism_extras.common.tile.multiblock.TileEntityReinforcedInductionCasing;
import com.jerry.mekanism_extras.common.tile.multiblock.TileEntityReinforcedInductionPort;
import com.jerry.mekanism_extras.common.tile.transmitter.ExtraTileEntityLogisticalTransporter;
import com.jerry.mekanism_extras.common.tile.transmitter.ExtraTileEntityLogisticalTransporterBase;
import com.jerry.mekanism_extras.common.tile.transmitter.ExtraTileEntityMechanicalPipe;
import com.jerry.mekanism_extras.common.tile.transmitter.ExtraTileEntityPressurizedTube;
import com.jerry.mekanism_extras.common.tile.transmitter.ExtraTileEntityThermodynamicConductor;
import com.jerry.mekanism_extras.common.tile.transmitter.ExtraTileEntityTransmitter;
import com.jerry.mekanism_extras.common.tile.transmitter.ExtraTileEntityUniversalCable;
import com.jerry.mekanism_extras.common.util.ExtraEnumUtils;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.content.blocktype.FactoryType;
import mekanism.common.registration.impl.BlockRegistryObject;
import mekanism.common.registration.impl.TileEntityTypeDeferredRegister;
import mekanism.common.registration.impl.TileEntityTypeRegistryObject;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.eventbus.api.IEventBus;

public class ExtraTileEntityTypes {
    public static final TileEntityTypeDeferredRegister TILE_ENTITY_TYPES = new TileEntityTypeDeferredRegister("mekanism_extras");
    private static final Table<AdvancedFactoryTier, FactoryType, TileEntityTypeRegistryObject<? extends TileEntityExtraFactory<?>>> FACTORIES = HashBasedTable.create();
    public static final TileEntityTypeRegistryObject<ExtraTileEntityRadioactiveWasteBarrel> EXPAND_RADIOACTIVE_WASTE_BARREL;
    public static final TileEntityTypeRegistryObject<TileEntityReinforcedInductionCasing> REINFORCED_INDUCTION_CASING;
    public static final TileEntityTypeRegistryObject<TileEntityReinforcedInductionPort> REINFORCED_INDUCTION_PORT;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityBin> ABSOLUTE_BIN;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityBin> SUPREME_BIN;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityBin> COSMIC_BIN;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityBin> INFINITE_BIN;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityInductionCell> ABSOLUTE_INDUCTION_CELL;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityInductionCell> SUPREME_INDUCTION_CELL;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityInductionCell> COSMIC_INDUCTION_CELL;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityInductionCell> INFINITE_INDUCTION_CELL;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityInductionProvider> ABSOLUTE_INDUCTION_PROVIDER;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityInductionProvider> SUPREME_INDUCTION_PROVIDER;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityInductionProvider> COSMIC_INDUCTION_PROVIDER;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityInductionProvider> INFINITE_INDUCTION_PROVIDER;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityFluidTank> ABSOLUTE_FLUID_TANK;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityFluidTank> SUPREME_FLUID_TANK;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityFluidTank> COSMIC_FLUID_TANK;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityFluidTank> INFINITE_FLUID_TANK;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityEnergyCube> ABSOLUTE_ENERGY_CUBE;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityEnergyCube> SUPREME_ENERGY_CUBE;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityEnergyCube> COSMIC_ENERGY_CUBE;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityEnergyCube> INFINITE_ENERGY_CUBE;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityUniversalCable> ABSOLUTE_UNIVERSAL_CABLE;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityUniversalCable> SUPREME_UNIVERSAL_CABLE;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityUniversalCable> COSMIC_UNIVERSAL_CABLE;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityUniversalCable> INFINITE_UNIVERSAL_CABLE;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityMechanicalPipe> ABSOLUTE_MECHANICAL_PIPE;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityMechanicalPipe> SUPREME_MECHANICAL_PIPE;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityMechanicalPipe> COSMIC_MECHANICAL_PIPE;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityMechanicalPipe> INFINITE_MECHANICAL_PIPE;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityPressurizedTube> ABSOLUTE_PRESSURIZED_TUBE;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityPressurizedTube> SUPREME_PRESSURIZED_TUBE;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityPressurizedTube> COSMIC_PRESSURIZED_TUBE;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityPressurizedTube> INFINITE_PRESSURIZED_TUBE;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityLogisticalTransporter> ABSOLUTE_LOGISTICAL_TRANSPORTER;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityLogisticalTransporter> SUPREME_LOGISTICAL_TRANSPORTER;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityLogisticalTransporter> COSMIC_LOGISTICAL_TRANSPORTER;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityLogisticalTransporter> INFINITE_LOGISTICAL_TRANSPORTER;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityThermodynamicConductor> ABSOLUTE_THERMODYNAMIC_CONDUCTOR;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityThermodynamicConductor> SUPREME_THERMODYNAMIC_CONDUCTOR;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityThermodynamicConductor> COSMIC_THERMODYNAMIC_CONDUCTOR;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityThermodynamicConductor> INFINITE_THERMODYNAMIC_CONDUCTOR;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityChemicalTank> ABSOLUTE_CHEMICAL_TANK;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityChemicalTank> SUPREME_CHEMICAL_TANK;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityChemicalTank> COSMIC_CHEMICAL_TANK;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityChemicalTank> INFINITE_CHEMICAL_TANK;
    public static final TileEntityTypeRegistryObject<TileEntityAdvancedElectricPump> ADVANCED_ELECTRIC_PUMP;

    private static <BE extends TileEntityTransmitter> TileEntityTypeRegistryObject<BE> registerTransmitter(BlockRegistryObject<?, ?> block, BlockEntityType.BlockEntitySupplier<? extends BE> factory) {
        return TILE_ENTITY_TYPES.builder(block, factory).serverTicker(TileEntityTransmitter::tickServer).build();
    }

    public static TileEntityTypeRegistryObject<? extends TileEntityExtraFactory<?>> getAdvancedFactoryTile(AdvancedFactoryTier tier, FactoryType type) {
        return (TileEntityTypeRegistryObject)FACTORIES.get((Object)tier, (Object)type);
    }

    public static TileEntityTypeRegistryObject<? extends TileEntityExtraFactory<?>>[] getAdvancedFactoryTiles() {
        return FACTORIES.values().toArray(new TileEntityTypeRegistryObject[0]);
    }

    public static void register(IEventBus eventBus) {
        TILE_ENTITY_TYPES.register(eventBus);
    }

    static {
        for (AdvancedFactoryTier tier : ExtraEnumUtils.ADVANCED_FACTORY_TIERS) {
            FACTORIES.put((Object)tier, (Object)FactoryType.COMBINING, (Object)TILE_ENTITY_TYPES.register(ExtraBlock.getAdvancedFactory(tier, FactoryType.COMBINING), (pos, state) -> new TileEntityCombiningExtraFactory((IBlockProvider)ExtraBlock.getAdvancedFactory(tier, FactoryType.COMBINING), pos, state), TileEntityMekanism::tickServer, TileEntityMekanism::tickClient));
            FACTORIES.put((Object)tier, (Object)FactoryType.COMPRESSING, (Object)TILE_ENTITY_TYPES.register(ExtraBlock.getAdvancedFactory(tier, FactoryType.COMPRESSING), (pos, state) -> new TileEntityItemStackGasToItemStackExtraFactory((IBlockProvider)ExtraBlock.getAdvancedFactory(tier, FactoryType.COMPRESSING), pos, state), TileEntityMekanism::tickServer, TileEntityMekanism::tickClient));
            FACTORIES.put((Object)tier, (Object)FactoryType.CRUSHING, (Object)TILE_ENTITY_TYPES.register(ExtraBlock.getAdvancedFactory(tier, FactoryType.CRUSHING), (pos, state) -> new TileEntityItemStackToItemStackExtraFactory((IBlockProvider)ExtraBlock.getAdvancedFactory(tier, FactoryType.CRUSHING), pos, state), TileEntityMekanism::tickServer, TileEntityMekanism::tickClient));
            FACTORIES.put((Object)tier, (Object)FactoryType.ENRICHING, (Object)TILE_ENTITY_TYPES.register(ExtraBlock.getAdvancedFactory(tier, FactoryType.ENRICHING), (pos, state) -> new TileEntityItemStackToItemStackExtraFactory((IBlockProvider)ExtraBlock.getAdvancedFactory(tier, FactoryType.ENRICHING), pos, state), TileEntityMekanism::tickServer, TileEntityMekanism::tickClient));
            FACTORIES.put((Object)tier, (Object)FactoryType.INFUSING, (Object)TILE_ENTITY_TYPES.register(ExtraBlock.getAdvancedFactory(tier, FactoryType.INFUSING), (pos, state) -> new TileEntityMetallurgicInfuserExtraFactory((IBlockProvider)ExtraBlock.getAdvancedFactory(tier, FactoryType.INFUSING), pos, state), TileEntityMekanism::tickServer, TileEntityMekanism::tickClient));
            FACTORIES.put((Object)tier, (Object)FactoryType.INJECTING, (Object)TILE_ENTITY_TYPES.register(ExtraBlock.getAdvancedFactory(tier, FactoryType.INJECTING), (pos, state) -> new TileEntityItemStackGasToItemStackExtraFactory((IBlockProvider)ExtraBlock.getAdvancedFactory(tier, FactoryType.INJECTING), pos, state), TileEntityMekanism::tickServer, TileEntityMekanism::tickClient));
            FACTORIES.put((Object)tier, (Object)FactoryType.PURIFYING, (Object)TILE_ENTITY_TYPES.register(ExtraBlock.getAdvancedFactory(tier, FactoryType.PURIFYING), (pos, state) -> new TileEntityItemStackGasToItemStackExtraFactory((IBlockProvider)ExtraBlock.getAdvancedFactory(tier, FactoryType.PURIFYING), pos, state), TileEntityMekanism::tickServer, TileEntityMekanism::tickClient));
            FACTORIES.put((Object)tier, (Object)FactoryType.SAWING, (Object)TILE_ENTITY_TYPES.register(ExtraBlock.getAdvancedFactory(tier, FactoryType.SAWING), (pos, state) -> new TileEntitySawingExtraFactory((IBlockProvider)ExtraBlock.getAdvancedFactory(tier, FactoryType.SAWING), pos, state), TileEntityMekanism::tickServer, TileEntityMekanism::tickClient));
            FACTORIES.put((Object)tier, (Object)FactoryType.SMELTING, (Object)TILE_ENTITY_TYPES.register(ExtraBlock.getAdvancedFactory(tier, FactoryType.SMELTING), (pos, state) -> new TileEntityItemStackToItemStackExtraFactory((IBlockProvider)ExtraBlock.getAdvancedFactory(tier, FactoryType.SMELTING), pos, state), TileEntityMekanism::tickServer, TileEntityMekanism::tickClient));
        }
        EXPAND_RADIOACTIVE_WASTE_BARREL = TILE_ENTITY_TYPES.register(ExtraBlock.EXPAND_RADIOACTIVE_WASTE_BARREL, ExtraTileEntityRadioactiveWasteBarrel::new, TileEntityMekanism::tickServer, TileEntityMekanism::tickClient);
        REINFORCED_INDUCTION_CASING = TILE_ENTITY_TYPES.register(ExtraBlock.REINFORCED_INDUCTION_CASING, TileEntityReinforcedInductionCasing::new, TileEntityMekanism::tickServer, TileEntityMekanism::tickClient);
        REINFORCED_INDUCTION_PORT = TILE_ENTITY_TYPES.register(ExtraBlock.REINFORCED_INDUCTION_PORT, TileEntityReinforcedInductionPort::new, TileEntityMekanism::tickServer, TileEntityMekanism::tickClient);
        ABSOLUTE_BIN = TILE_ENTITY_TYPES.register(ExtraBlock.ABSOLUTE_BIN, (pos, state) -> new ExtraTileEntityBin((IBlockProvider)ExtraBlock.ABSOLUTE_BIN, pos, state), TileEntityMekanism::tickServer, TileEntityMekanism::tickClient);
        SUPREME_BIN = TILE_ENTITY_TYPES.register(ExtraBlock.SUPREME_BIN, (pos, state) -> new ExtraTileEntityBin((IBlockProvider)ExtraBlock.SUPREME_BIN, pos, state), TileEntityMekanism::tickServer, TileEntityMekanism::tickClient);
        COSMIC_BIN = TILE_ENTITY_TYPES.register(ExtraBlock.COSMIC_BIN, (pos, state) -> new ExtraTileEntityBin((IBlockProvider)ExtraBlock.COSMIC_BIN, pos, state), TileEntityMekanism::tickServer, TileEntityMekanism::tickClient);
        INFINITE_BIN = TILE_ENTITY_TYPES.register(ExtraBlock.INFINITE_BIN, (pos, state) -> new ExtraTileEntityBin((IBlockProvider)ExtraBlock.INFINITE_BIN, pos, state), TileEntityMekanism::tickServer, TileEntityMekanism::tickClient);
        ABSOLUTE_INDUCTION_CELL = TILE_ENTITY_TYPES.register(ExtraBlock.ABSOLUTE_INDUCTION_CELL, (pos, state) -> new ExtraTileEntityInductionCell((IBlockProvider)ExtraBlock.ABSOLUTE_INDUCTION_CELL, pos, state), TileEntityMekanism::tickServer, TileEntityMekanism::tickClient);
        SUPREME_INDUCTION_CELL = TILE_ENTITY_TYPES.register(ExtraBlock.SUPREME_INDUCTION_CELL, (pos, state) -> new ExtraTileEntityInductionCell((IBlockProvider)ExtraBlock.SUPREME_INDUCTION_CELL, pos, state), TileEntityMekanism::tickServer, TileEntityMekanism::tickClient);
        COSMIC_INDUCTION_CELL = TILE_ENTITY_TYPES.register(ExtraBlock.COSMIC_INDUCTION_CELL, (pos, state) -> new ExtraTileEntityInductionCell((IBlockProvider)ExtraBlock.COSMIC_INDUCTION_CELL, pos, state), TileEntityMekanism::tickServer, TileEntityMekanism::tickClient);
        INFINITE_INDUCTION_CELL = TILE_ENTITY_TYPES.register(ExtraBlock.INFINITE_INDUCTION_CELL, (pos, state) -> new ExtraTileEntityInductionCell((IBlockProvider)ExtraBlock.INFINITE_INDUCTION_CELL, pos, state), TileEntityMekanism::tickServer, TileEntityMekanism::tickClient);
        ABSOLUTE_INDUCTION_PROVIDER = TILE_ENTITY_TYPES.register(ExtraBlock.ABSOLUTE_INDUCTION_PROVIDER, (pos, state) -> new ExtraTileEntityInductionProvider((IBlockProvider)ExtraBlock.ABSOLUTE_INDUCTION_PROVIDER, pos, state), TileEntityMekanism::tickServer, TileEntityMekanism::tickClient);
        SUPREME_INDUCTION_PROVIDER = TILE_ENTITY_TYPES.register(ExtraBlock.SUPREME_INDUCTION_PROVIDER, (pos, state) -> new ExtraTileEntityInductionProvider((IBlockProvider)ExtraBlock.SUPREME_INDUCTION_PROVIDER, pos, state), TileEntityMekanism::tickServer, TileEntityMekanism::tickClient);
        COSMIC_INDUCTION_PROVIDER = TILE_ENTITY_TYPES.register(ExtraBlock.COSMIC_INDUCTION_PROVIDER, (pos, state) -> new ExtraTileEntityInductionProvider((IBlockProvider)ExtraBlock.COSMIC_INDUCTION_PROVIDER, pos, state), TileEntityMekanism::tickServer, TileEntityMekanism::tickClient);
        INFINITE_INDUCTION_PROVIDER = TILE_ENTITY_TYPES.register(ExtraBlock.INFINITE_INDUCTION_PROVIDER, (pos, state) -> new ExtraTileEntityInductionProvider((IBlockProvider)ExtraBlock.INFINITE_INDUCTION_PROVIDER, pos, state), TileEntityMekanism::tickServer, TileEntityMekanism::tickClient);
        ABSOLUTE_FLUID_TANK = TILE_ENTITY_TYPES.register(ExtraBlock.ABSOLUTE_FLUID_TANK, (pos, state) -> new ExtraTileEntityFluidTank((IBlockProvider)ExtraBlock.ABSOLUTE_FLUID_TANK, pos, state), TileEntityMekanism::tickServer, TileEntityMekanism::tickClient);
        SUPREME_FLUID_TANK = TILE_ENTITY_TYPES.register(ExtraBlock.SUPREME_FLUID_TANK, (pos, state) -> new ExtraTileEntityFluidTank((IBlockProvider)ExtraBlock.SUPREME_FLUID_TANK, pos, state), TileEntityMekanism::tickServer, TileEntityMekanism::tickClient);
        COSMIC_FLUID_TANK = TILE_ENTITY_TYPES.register(ExtraBlock.COSMIC_FLUID_TANK, (pos, state) -> new ExtraTileEntityFluidTank((IBlockProvider)ExtraBlock.COSMIC_FLUID_TANK, pos, state), TileEntityMekanism::tickServer, TileEntityMekanism::tickClient);
        INFINITE_FLUID_TANK = TILE_ENTITY_TYPES.register(ExtraBlock.INFINITE_FLUID_TANK, (pos, state) -> new ExtraTileEntityFluidTank((IBlockProvider)ExtraBlock.INFINITE_FLUID_TANK, pos, state), TileEntityMekanism::tickServer, TileEntityMekanism::tickClient);
        ABSOLUTE_ENERGY_CUBE = TILE_ENTITY_TYPES.register(ExtraBlock.ABSOLUTE_ENERGY_CUBE, (pos, state) -> new ExtraTileEntityEnergyCube((IBlockProvider)ExtraBlock.ABSOLUTE_ENERGY_CUBE, pos, state), TileEntityMekanism::tickServer, TileEntityMekanism::tickClient);
        SUPREME_ENERGY_CUBE = TILE_ENTITY_TYPES.register(ExtraBlock.SUPREME_ENERGY_CUBE, (pos, state) -> new ExtraTileEntityEnergyCube((IBlockProvider)ExtraBlock.SUPREME_ENERGY_CUBE, pos, state), TileEntityMekanism::tickServer, TileEntityMekanism::tickClient);
        COSMIC_ENERGY_CUBE = TILE_ENTITY_TYPES.register(ExtraBlock.COSMIC_ENERGY_CUBE, (pos, state) -> new ExtraTileEntityEnergyCube((IBlockProvider)ExtraBlock.COSMIC_ENERGY_CUBE, pos, state), TileEntityMekanism::tickServer, TileEntityMekanism::tickClient);
        INFINITE_ENERGY_CUBE = TILE_ENTITY_TYPES.register(ExtraBlock.INFINITE_ENERGY_CUBE, (pos, state) -> new ExtraTileEntityEnergyCube((IBlockProvider)ExtraBlock.INFINITE_ENERGY_CUBE, pos, state), TileEntityMekanism::tickServer, TileEntityMekanism::tickClient);
        ABSOLUTE_UNIVERSAL_CABLE = ExtraTileEntityTypes.registerTransmitter(ExtraBlock.ABSOLUTE_UNIVERSAL_CABLE, (pos, state) -> new ExtraTileEntityUniversalCable((IBlockProvider)ExtraBlock.ABSOLUTE_UNIVERSAL_CABLE, pos, state));
        SUPREME_UNIVERSAL_CABLE = ExtraTileEntityTypes.registerTransmitter(ExtraBlock.SUPREME_UNIVERSAL_CABLE, (pos, state) -> new ExtraTileEntityUniversalCable((IBlockProvider)ExtraBlock.SUPREME_UNIVERSAL_CABLE, pos, state));
        COSMIC_UNIVERSAL_CABLE = ExtraTileEntityTypes.registerTransmitter(ExtraBlock.COSMIC_UNIVERSAL_CABLE, (pos, state) -> new ExtraTileEntityUniversalCable((IBlockProvider)ExtraBlock.COSMIC_UNIVERSAL_CABLE, pos, state));
        INFINITE_UNIVERSAL_CABLE = ExtraTileEntityTypes.registerTransmitter(ExtraBlock.INFINITE_UNIVERSAL_CABLE, (pos, state) -> new ExtraTileEntityUniversalCable((IBlockProvider)ExtraBlock.INFINITE_UNIVERSAL_CABLE, pos, state));
        ABSOLUTE_MECHANICAL_PIPE = ExtraTileEntityTypes.registerTransmitter(ExtraBlock.ABSOLUTE_MECHANICAL_PIPE, (pos, state) -> new ExtraTileEntityMechanicalPipe((IBlockProvider)ExtraBlock.ABSOLUTE_MECHANICAL_PIPE, pos, state));
        SUPREME_MECHANICAL_PIPE = ExtraTileEntityTypes.registerTransmitter(ExtraBlock.SUPREME_MECHANICAL_PIPE, (pos, state) -> new ExtraTileEntityMechanicalPipe((IBlockProvider)ExtraBlock.SUPREME_MECHANICAL_PIPE, pos, state));
        COSMIC_MECHANICAL_PIPE = ExtraTileEntityTypes.registerTransmitter(ExtraBlock.COSMIC_MECHANICAL_PIPE, (pos, state) -> new ExtraTileEntityMechanicalPipe((IBlockProvider)ExtraBlock.COSMIC_MECHANICAL_PIPE, pos, state));
        INFINITE_MECHANICAL_PIPE = ExtraTileEntityTypes.registerTransmitter(ExtraBlock.INFINITE_MECHANICAL_PIPE, (pos, state) -> new ExtraTileEntityMechanicalPipe((IBlockProvider)ExtraBlock.INFINITE_MECHANICAL_PIPE, pos, state));
        ABSOLUTE_PRESSURIZED_TUBE = ExtraTileEntityTypes.registerTransmitter(ExtraBlock.ABSOLUTE_PRESSURIZED_TUBE, (pos, state) -> new ExtraTileEntityPressurizedTube((IBlockProvider)ExtraBlock.ABSOLUTE_PRESSURIZED_TUBE, pos, state));
        SUPREME_PRESSURIZED_TUBE = ExtraTileEntityTypes.registerTransmitter(ExtraBlock.SUPREME_PRESSURIZED_TUBE, (pos, state) -> new ExtraTileEntityPressurizedTube((IBlockProvider)ExtraBlock.SUPREME_PRESSURIZED_TUBE, pos, state));
        COSMIC_PRESSURIZED_TUBE = ExtraTileEntityTypes.registerTransmitter(ExtraBlock.COSMIC_PRESSURIZED_TUBE, (pos, state) -> new ExtraTileEntityPressurizedTube((IBlockProvider)ExtraBlock.COSMIC_PRESSURIZED_TUBE, pos, state));
        INFINITE_PRESSURIZED_TUBE = ExtraTileEntityTypes.registerTransmitter(ExtraBlock.INFINITE_PRESSURIZED_TUBE, (pos, state) -> new ExtraTileEntityPressurizedTube((IBlockProvider)ExtraBlock.INFINITE_PRESSURIZED_TUBE, pos, state));
        ABSOLUTE_LOGISTICAL_TRANSPORTER = TILE_ENTITY_TYPES.builder(ExtraBlock.ABSOLUTE_LOGISTICAL_TRANSPORTER, (pos, state) -> new ExtraTileEntityLogisticalTransporter((IBlockProvider)ExtraBlock.ABSOLUTE_LOGISTICAL_TRANSPORTER, pos, state)).clientTicker(ExtraTileEntityLogisticalTransporterBase::tickClient).serverTicker(ExtraTileEntityTransmitter::extraTickServer).build();
        SUPREME_LOGISTICAL_TRANSPORTER = TILE_ENTITY_TYPES.builder(ExtraBlock.SUPREME_LOGISTICAL_TRANSPORTER, (pos, state) -> new ExtraTileEntityLogisticalTransporter((IBlockProvider)ExtraBlock.SUPREME_LOGISTICAL_TRANSPORTER, pos, state)).clientTicker(ExtraTileEntityLogisticalTransporterBase::tickClient).serverTicker(ExtraTileEntityTransmitter::extraTickServer).build();
        COSMIC_LOGISTICAL_TRANSPORTER = TILE_ENTITY_TYPES.builder(ExtraBlock.COSMIC_LOGISTICAL_TRANSPORTER, (pos, state) -> new ExtraTileEntityLogisticalTransporter((IBlockProvider)ExtraBlock.COSMIC_LOGISTICAL_TRANSPORTER, pos, state)).clientTicker(ExtraTileEntityLogisticalTransporterBase::tickClient).serverTicker(ExtraTileEntityTransmitter::extraTickServer).build();
        INFINITE_LOGISTICAL_TRANSPORTER = TILE_ENTITY_TYPES.builder(ExtraBlock.INFINITE_LOGISTICAL_TRANSPORTER, (pos, state) -> new ExtraTileEntityLogisticalTransporter((IBlockProvider)ExtraBlock.INFINITE_LOGISTICAL_TRANSPORTER, pos, state)).clientTicker(ExtraTileEntityLogisticalTransporterBase::tickClient).serverTicker(ExtraTileEntityTransmitter::extraTickServer).build();
        ABSOLUTE_THERMODYNAMIC_CONDUCTOR = ExtraTileEntityTypes.registerTransmitter(ExtraBlock.ABSOLUTE_THERMODYNAMIC_CONDUCTOR, (pos, state) -> new ExtraTileEntityThermodynamicConductor((IBlockProvider)ExtraBlock.ABSOLUTE_THERMODYNAMIC_CONDUCTOR, pos, state));
        SUPREME_THERMODYNAMIC_CONDUCTOR = ExtraTileEntityTypes.registerTransmitter(ExtraBlock.SUPREME_THERMODYNAMIC_CONDUCTOR, (pos, state) -> new ExtraTileEntityThermodynamicConductor((IBlockProvider)ExtraBlock.SUPREME_THERMODYNAMIC_CONDUCTOR, pos, state));
        COSMIC_THERMODYNAMIC_CONDUCTOR = ExtraTileEntityTypes.registerTransmitter(ExtraBlock.COSMIC_THERMODYNAMIC_CONDUCTOR, (pos, state) -> new ExtraTileEntityThermodynamicConductor((IBlockProvider)ExtraBlock.COSMIC_THERMODYNAMIC_CONDUCTOR, pos, state));
        INFINITE_THERMODYNAMIC_CONDUCTOR = ExtraTileEntityTypes.registerTransmitter(ExtraBlock.INFINITE_THERMODYNAMIC_CONDUCTOR, (pos, state) -> new ExtraTileEntityThermodynamicConductor((IBlockProvider)ExtraBlock.INFINITE_THERMODYNAMIC_CONDUCTOR, pos, state));
        ABSOLUTE_CHEMICAL_TANK = TILE_ENTITY_TYPES.register(ExtraBlock.ABSOLUTE_CHEMICAL_TANK, (pos, state) -> new ExtraTileEntityChemicalTank((IBlockProvider)ExtraBlock.ABSOLUTE_CHEMICAL_TANK, pos, state), TileEntityMekanism::tickServer, TileEntityMekanism::tickClient);
        SUPREME_CHEMICAL_TANK = TILE_ENTITY_TYPES.register(ExtraBlock.SUPREME_CHEMICAL_TANK, (pos, state) -> new ExtraTileEntityChemicalTank((IBlockProvider)ExtraBlock.SUPREME_CHEMICAL_TANK, pos, state), TileEntityMekanism::tickServer, TileEntityMekanism::tickClient);
        COSMIC_CHEMICAL_TANK = TILE_ENTITY_TYPES.register(ExtraBlock.COSMIC_CHEMICAL_TANK, (pos, state) -> new ExtraTileEntityChemicalTank((IBlockProvider)ExtraBlock.COSMIC_CHEMICAL_TANK, pos, state), TileEntityMekanism::tickServer, TileEntityMekanism::tickClient);
        INFINITE_CHEMICAL_TANK = TILE_ENTITY_TYPES.register(ExtraBlock.INFINITE_CHEMICAL_TANK, (pos, state) -> new ExtraTileEntityChemicalTank((IBlockProvider)ExtraBlock.INFINITE_CHEMICAL_TANK, pos, state), TileEntityMekanism::tickServer, TileEntityMekanism::tickClient);
        ADVANCED_ELECTRIC_PUMP = TILE_ENTITY_TYPES.register(ExtraBlock.ADVANCED_ELECTRIC_PUMP, TileEntityAdvancedElectricPump::new, TileEntityMekanism::tickServer, TileEntityMekanism::tickClient);
    }
}

