/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.common.tile;

import com.jerry.mekanism_extras.common.block.attribute.ExtraAttribute;
import com.jerry.mekanism_extras.common.capabilities.chemical.ExtraChemicalTankChemicalTank;
import com.jerry.mekanism_extras.common.tier.CTTier;
import com.jerry.mekanism_extras.common.upgrade.ExtraChemicalTankUpgradeData;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import mekanism.api.Action;
import mekanism.api.IContentsListener;
import mekanism.api.IIncrementalEnum;
import mekanism.api.RelativeSide;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.merged.MergedChemicalTank;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.SyntheticComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.inventory.slot.chemical.MergedChemicalInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.interfaces.IHasGasMode;
import mekanism.common.tile.interfaces.ISustainedData;
import mekanism.common.tile.prefab.TileEntityConfigurableMachine;
import mekanism.common.upgrade.ChemicalTankUpgradeData;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtraTileEntityChemicalTank
extends TileEntityConfigurableMachine
implements ISustainedData,
IHasGasMode {
    @SyntheticComputerMethod(getter="getDumpingMode", getterDescription="Get the current Dumping configuration")
    public GasMode dumping = GasMode.IDLE;
    private MergedChemicalTank chemicalTank;
    private CTTier tier;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getDrainItem"}, docPlaceholder="drain slot")
    MergedChemicalInventorySlot<MergedChemicalTank> drainSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getFillItem"}, docPlaceholder="fill slot")
    MergedChemicalInventorySlot<MergedChemicalTank> fillSlot;

    public ExtraTileEntityChemicalTank(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
        this.configComponent = new TileComponentConfig((TileEntityMekanism)this, new TransmissionType[]{TransmissionType.GAS, TransmissionType.INFUSION, TransmissionType.PIGMENT, TransmissionType.SLURRY, TransmissionType.ITEM});
        this.configComponent.setupIOConfig(TransmissionType.ITEM, this.drainSlot, this.fillSlot, RelativeSide.FRONT, true).setCanEject(false);
        this.configComponent.setupIOConfig(TransmissionType.GAS, (Object)this.getGasTank(), RelativeSide.FRONT).setEjecting(true);
        this.configComponent.setupIOConfig(TransmissionType.INFUSION, (Object)this.getInfusionTank(), RelativeSide.FRONT).setEjecting(true);
        this.configComponent.setupIOConfig(TransmissionType.PIGMENT, (Object)this.getPigmentTank(), RelativeSide.FRONT).setEjecting(true);
        this.configComponent.setupIOConfig(TransmissionType.SLURRY, (Object)this.getSlurryTank(), RelativeSide.FRONT).setEjecting(true);
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this, () -> this.tier.getOutput());
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.GAS, TransmissionType.INFUSION, TransmissionType.PIGMENT, TransmissionType.SLURRY}).setCanEject(type -> MekanismUtils.canFunction((TileEntityMekanism)this) && this.dumping != GasMode.DUMPING);
    }

    protected void presetVariables() {
        super.presetVariables();
        this.tier = ExtraAttribute.getTier(this.getBlockType(), CTTier.class);
        this.chemicalTank = ExtraChemicalTankChemicalTank.create(this.tier, (IContentsListener)this);
    }

    @NotNull
    public IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks(IContentsListener listener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSideGasWithConfig(() -> ((ExtraTileEntityChemicalTank)this).getDirection(), () -> ((ExtraTileEntityChemicalTank)this).getConfig());
        builder.addTank((IChemicalTank)this.getGasTank());
        return builder.build();
    }

    @NotNull
    public IChemicalTankHolder<InfuseType, InfusionStack, IInfusionTank> getInitialInfusionTanks(IContentsListener listener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSideInfusionWithConfig(() -> ((ExtraTileEntityChemicalTank)this).getDirection(), () -> ((ExtraTileEntityChemicalTank)this).getConfig());
        builder.addTank((IChemicalTank)this.getInfusionTank());
        return builder.build();
    }

    @NotNull
    public IChemicalTankHolder<Pigment, PigmentStack, IPigmentTank> getInitialPigmentTanks(IContentsListener listener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSidePigmentWithConfig(() -> ((ExtraTileEntityChemicalTank)this).getDirection(), () -> ((ExtraTileEntityChemicalTank)this).getConfig());
        builder.addTank((IChemicalTank)this.getPigmentTank());
        return builder.build();
    }

    @NotNull
    public IChemicalTankHolder<Slurry, SlurryStack, ISlurryTank> getInitialSlurryTanks(IContentsListener listener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSideSlurryWithConfig(() -> ((ExtraTileEntityChemicalTank)this).getDirection(), () -> ((ExtraTileEntityChemicalTank)this).getConfig());
        builder.addTank((IChemicalTank)this.getSlurryTank());
        return builder.build();
    }

    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig(() -> ((ExtraTileEntityChemicalTank)this).getDirection(), () -> ((ExtraTileEntityChemicalTank)this).getConfig());
        this.drainSlot = MergedChemicalInventorySlot.drain((MergedChemicalTank)this.chemicalTank, (IContentsListener)listener, (int)16, (int)16);
        builder.addSlot((IInventorySlot)this.drainSlot);
        this.fillSlot = MergedChemicalInventorySlot.fill((MergedChemicalTank)this.chemicalTank, (IContentsListener)listener, (int)16, (int)48);
        builder.addSlot((IInventorySlot)this.fillSlot);
        this.drainSlot.setSlotType(ContainerSlotType.OUTPUT);
        this.drainSlot.setSlotOverlay(SlotOverlay.PLUS);
        this.fillSlot.setSlotType(ContainerSlotType.INPUT);
        this.fillSlot.setSlotOverlay(SlotOverlay.MINUS);
        return builder.build();
    }

    protected void onUpdateServer() {
        MergedChemicalTank.Current current;
        super.onUpdateServer();
        this.drainSlot.drainChemicalTanks();
        this.fillSlot.fillChemicalTanks();
        if (this.dumping != GasMode.IDLE && (current = this.chemicalTank.getCurrent()) != MergedChemicalTank.Current.EMPTY) {
            IChemicalTank currentTank = this.chemicalTank.getTankFromCurrent(current);
            if (this.dumping == GasMode.DUMPING) {
                currentTank.shrinkStack(this.tier.getStorage() / 400L, Action.EXECUTE);
            } else {
                long stored;
                long target = MathUtils.clampToLong((double)((double)currentTank.getCapacity() * MekanismConfig.general.dumpExcessKeepRatio.get()));
                if (target < (stored = currentTank.getStored())) {
                    currentTank.shrinkStack(Math.min(stored - target, this.tier.getOutput()), Action.EXECUTE);
                }
            }
        }
    }

    public void nextMode(int tank) {
        if (tank == 0) {
            this.dumping = (GasMode)this.dumping.getNext();
            this.markForSave();
        }
    }

    public boolean shouldDumpRadiation() {
        return true;
    }

    public int getRedstoneLevel() {
        IChemicalTank<?, ?> currentTank = this.getCurrentTank();
        return MekanismUtils.redstoneLevelFromContents((long)currentTank.getStored(), (long)currentTank.getCapacity());
    }

    protected boolean makesComparatorDirty(@Nullable SubstanceType type) {
        return type == SubstanceType.GAS || type == SubstanceType.INFUSION || type == SubstanceType.PIGMENT || type == SubstanceType.SLURRY;
    }

    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getStored", "getCapacity", "getNeeded", "getFilledPercentage"}, docPlaceholder="tank")
    IChemicalTank<?, ?> getCurrentTank() {
        MergedChemicalTank.Current current = this.chemicalTank.getCurrent();
        return this.chemicalTank.getTankFromCurrent(current == MergedChemicalTank.Current.EMPTY ? MergedChemicalTank.Current.GAS : current);
    }

    public CTTier getTier() {
        return this.tier;
    }

    public MergedChemicalTank getChemicalTank() {
        return this.chemicalTank;
    }

    public IGasTank getGasTank() {
        return this.chemicalTank.getGasTank();
    }

    public IInfusionTank getInfusionTank() {
        return this.chemicalTank.getInfusionTank();
    }

    public IPigmentTank getPigmentTank() {
        return this.chemicalTank.getPigmentTank();
    }

    public ISlurryTank getSlurryTank() {
        return this.chemicalTank.getSlurryTank();
    }

    public void parseUpgradeData(@NotNull IUpgradeData upgradeData) {
        if (upgradeData instanceof ExtraChemicalTankUpgradeData) {
            ExtraChemicalTankUpgradeData data = (ExtraChemicalTankUpgradeData)upgradeData;
            this.redstone = data.redstone;
            this.setControlType(data.controlType);
            this.drainSlot.setStack(data.drainSlot.getStack());
            this.fillSlot.setStack(data.fillSlot.getStack());
            this.dumping = data.dumping;
            this.getGasTank().setStack((ChemicalStack)data.storedGas);
            this.getInfusionTank().setStack((ChemicalStack)data.storedInfusion);
            this.getPigmentTank().setStack((ChemicalStack)data.storedPigment);
            this.getSlurryTank().setStack((ChemicalStack)data.storedSlurry);
            for (ITileComponent component : this.getComponents()) {
                component.read(data.components);
            }
        } else if (upgradeData instanceof ChemicalTankUpgradeData) {
            ChemicalTankUpgradeData data = (ChemicalTankUpgradeData)upgradeData;
            this.redstone = data.redstone;
            this.setControlType(data.controlType);
            this.drainSlot.setStack(data.drainSlot.getStack());
            this.fillSlot.setStack(data.fillSlot.getStack());
            this.dumping = GasMode.byIndexStatic(data.dumping.ordinal());
            this.getGasTank().setStack((ChemicalStack)data.storedGas);
            this.getInfusionTank().setStack((ChemicalStack)data.storedInfusion);
            this.getPigmentTank().setStack((ChemicalStack)data.storedPigment);
            this.getSlurryTank().setStack((ChemicalStack)data.storedSlurry);
            for (ITileComponent component : this.getComponents()) {
                component.read(data.components);
            }
        } else {
            super.parseUpgradeData(upgradeData);
        }
    }

    @NotNull
    public ExtraChemicalTankUpgradeData getUpgradeData() {
        return new ExtraChemicalTankUpgradeData(this.redstone, this.getControlType(), this.drainSlot, this.fillSlot, this.dumping, (GasStack)this.getGasTank().getStack(), (InfusionStack)this.getInfusionTank().getStack(), (PigmentStack)this.getPigmentTank().getStack(), (SlurryStack)this.getSlurryTank().getStack(), this.getComponents());
    }

    public void writeSustainedData(CompoundTag dataMap) {
        NBTUtils.writeEnum((CompoundTag)dataMap, (String)"dumping", (Enum)this.dumping);
    }

    public void readSustainedData(CompoundTag dataMap) {
        NBTUtils.setEnumIfPresent((CompoundTag)dataMap, (String)"dumping", GasMode::byIndexStatic, mode -> {
            this.dumping = mode;
        });
    }

    public Map<String, String> getTileDataRemap() {
        Object2ObjectOpenHashMap remap = new Object2ObjectOpenHashMap();
        remap.put("dumping", "dumping");
        return remap;
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track((ISyncableData)SyncableEnum.create(GasMode::byIndexStatic, (Enum)GasMode.IDLE, () -> this.dumping, value -> {
            this.dumping = value;
        }));
    }

    @ComputerMethod(requiresPublicSecurity=true, methodDescription="Set the Dumping mode of the tank")
    void setDumpingMode(GasMode mode) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.dumping != mode) {
            this.dumping = mode;
            this.markForSave();
        }
    }

    @ComputerMethod(requiresPublicSecurity=true, methodDescription="Advance the Dumping mode to the next configuration in the list")
    void incrementDumpingMode() throws ComputerException {
        this.validateSecurityIsPublic();
        this.nextMode(0);
    }

    @ComputerMethod(requiresPublicSecurity=true, methodDescription="Descend the Dumping mode to the previous configuration in the list")
    void decrementDumpingMode() throws ComputerException {
        this.validateSecurityIsPublic();
        this.dumping = (GasMode)this.dumping.getPrevious();
        this.markForSave();
    }

    @NothingNullByDefault
    public static enum GasMode implements IIncrementalEnum<GasMode>,
    IHasTextComponent
    {
        IDLE((ILangEntry)MekanismLang.IDLE),
        DUMPING_EXCESS((ILangEntry)MekanismLang.DUMPING_EXCESS),
        DUMPING((ILangEntry)MekanismLang.DUMPING);

        private static final GasMode[] MODES;
        private final ILangEntry langEntry;

        private GasMode(ILangEntry langEntry) {
            this.langEntry = langEntry;
        }

        public Component getTextComponent() {
            return this.langEntry.translate(new Object[0]);
        }

        public GasMode byIndex(int index) {
            return GasMode.byIndexStatic(index);
        }

        public static GasMode byIndexStatic(int index) {
            return (GasMode)((Object)MathUtils.getByIndexMod((Object[])MODES, (int)index));
        }

        static {
            MODES = GasMode.values();
        }
    }
}

