/*
 * Decompiled with CFR 0.152.
 */
package com.folumo.mekanism_lasers_old.common.item;

import com.folumo.mekanism_lasers_old.common.block_entity.ToggleableLaserBlockEntity;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class RemoteControlItem
extends Item {
    public static final String TAG_ACTIVITY = "Activity";
    public static final String TAG_POS = "pos";

    public RemoteControlItem(Item.Properties properties) {
        super(properties.m_41497_(Rarity.UNCOMMON).m_41487_(1));
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        return TextComponentUtil.build((Object[])new Object[]{EnumColor.AQUA, super.m_7626_(stack)});
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level world, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_) {
            player.m_213846_((Component)Component.m_237113_((String)"Switching laser mode"));
            this.switchLaserMode(stack, world, player);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos;
        BlockEntity tile;
        Player player = context.m_43723_();
        Level world = context.m_43725_();
        ItemStack stack = context.m_43722_();
        if (!world.f_46443_ && player != null && (tile = WorldUtils.getTileEntity((BlockGetter)world, (BlockPos)(pos = context.m_8083_()))) instanceof ToggleableLaserBlockEntity && ((ToggleableLaserBlockEntity)tile).ownerMatches(player)) {
            List<BlockPos> linkedLasers = this.getBlockPos(stack);
            if (linkedLasers.contains(pos)) {
                linkedLasers.remove(pos);
                player.m_213846_((Component)Component.m_237113_((String)"removed"));
            } else {
                linkedLasers.add(pos);
                player.m_213846_((Component)Component.m_237113_((String)"added"));
            }
            this.saveLinkedLasers(stack, linkedLasers);
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    public void switchLaserMode(ItemStack stack, Level world, Player player) {
        assert (stack.m_41783_() != null);
        stack.m_41783_().m_128379_(TAG_ACTIVITY, !this.getActive(stack));
        List<BlockPos> linkedLasers = this.getBlockPos(stack);
        boolean finalLasersStatus = this.getActive(stack);
        linkedLasers.forEach(pos2 -> {
            BlockEntity tile2 = WorldUtils.getTileEntity((BlockGetter)world, (BlockPos)pos2);
            if (tile2 instanceof ToggleableLaserBlockEntity) {
                ((ToggleableLaserBlockEntity)tile2).setLaserActivity(finalLasersStatus, player);
            }
        });
    }

    public boolean doesSneakBypassUse(@NotNull ItemStack stack, @NotNull LevelReader world, @NotNull BlockPos pos, @NotNull Player player) {
        return false;
    }

    private void saveLinkedLasers(ItemStack stack, List<BlockPos> linkedLasers) {
        if (stack.m_41783_() == null) {
            this.setTags(stack);
        }
        ArrayList newPosList = new ArrayList();
        linkedLasers.forEach(blockPos -> {
            newPosList.add(blockPos.m_123341_());
            newPosList.add(blockPos.m_123342_());
            newPosList.add(blockPos.m_123343_());
        });
        if (stack.m_41783_() == null) {
            this.setTags(stack);
        }
        stack.m_41783_().m_128408_(TAG_POS, newPosList);
    }

    private List<BlockPos> getBlockPos(ItemStack stack) {
        if (stack.m_41783_() == null) {
            this.setTags(stack);
        }
        int[] posList = stack.m_41783_().m_128465_(TAG_POS);
        ArrayList<BlockPos> newPosList = new ArrayList<BlockPos>();
        for (int i = 0; i < posList.length; i += 3) {
            int x = posList[i];
            int y = posList[i + 1];
            int z = posList[i + 2];
            BlockPos blockPos = new BlockPos(x, y, z);
            newPosList.add(blockPos);
        }
        return newPosList;
    }

    private boolean getActive(ItemStack stack) {
        if (stack.m_41783_() == null) {
            this.setTags(stack);
        }
        return Boolean.TRUE.equals(stack.m_41783_().m_128471_(TAG_ACTIVITY));
    }

    private void setTags(ItemStack stack) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_(TAG_ACTIVITY, false);
        nbt.m_128408_(TAG_POS, new ArrayList());
        stack.m_41751_(nbt);
    }
}

