/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_turrets.common.packet;

import com.github.x3r.mekanism_turrets.common.block_entity.LaserTurretBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class ModifyTurretTargetPacket {
    private final BlockPos blockEntityPos;
    private final byte index;
    private final boolean value;

    public ModifyTurretTargetPacket(BlockPos blockEntityPos, byte index, boolean value) {
        this.blockEntityPos = blockEntityPos;
        this.index = index;
        this.value = value;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.blockEntityPos);
        buffer.writeByte((int)this.index);
        buffer.writeBoolean(this.value);
    }

    public static ModifyTurretTargetPacket decode(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.m_130135_();
        byte index = buffer.readByte();
        boolean value = buffer.readBoolean();
        return new ModifyTurretTargetPacket(pos, index, value);
    }

    public void receivePacket(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            BlockEntity be = player.m_9236_().m_7702_(this.blockEntityPos);
            if (be instanceof LaserTurretBlockEntity) {
                LaserTurretBlockEntity turret = (LaserTurretBlockEntity)be;
                switch (this.index) {
                    case 0: {
                        turret.setTargetsHostile(this.value);
                        break;
                    }
                    case 1: {
                        turret.setTargetsPassive(this.value);
                        break;
                    }
                    case 2: {
                        turret.setTargetsPlayers(this.value);
                        break;
                    }
                    case 3: {
                        turret.setTargetsTrusted(this.value);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid index: " + this.index);
                    }
                }
                turret.markUpdated();
                turret.tryInvalidateTarget();
            }
        });
        context.get().setPacketHandled(true);
    }
}

